/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.crafting;

import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.item.BasicEquip;
import com.lulan.shincolle.reference.Values;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class EquipCalc {
    private static Random rand = new Random();
    private static List<int[]> EquipSmall = new ArrayList<int[]>();
    private static List<int[]> EquipLarge = new ArrayList<int[]>();

    public static float[] getEquipStat(BasicEntityShip entity, ItemStack item) {
        float[] itemStat;
        if (entity != null && item != null && item.func_77973_b() instanceof BasicEquip && (itemStat = Values.EquipMap.get(((BasicEquip)item.func_77973_b()).getEquipID(item.func_77960_j()))) != null) {
            if (entity.getEquipType() != 2 && itemStat[0] != 2.0f && (float)entity.getEquipType() != itemStat[0]) {
                return null;
            }
            return itemStat;
        }
        return null;
    }

    public static float[] getEquipStatMisc(BasicEntityShip entity, ItemStack item) {
        if (entity != null && item != null && item.func_77973_b() instanceof BasicEquip) {
            float[] itemStat = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            if (item.func_77973_b() == ModItems.EquipDrum) {
                itemStat[0] = 1.0f;
            } else if (item.func_77973_b() == ModItems.EquipCompass) {
                itemStat[1] = 1.0f;
            } else if (item.func_77973_b() == ModItems.EquipFlare && entity.getEquipType() != 3) {
                itemStat[2] = 1.0f;
            } else if (item.func_77973_b() == ModItems.EquipSearchlight) {
                itemStat[3] = 1.0f;
            }
            return itemStat;
        }
        return null;
    }

    public static int rollEquipType(int type, int[] matAmount) {
        List<int[]> eqlistOrg = null;
        int totalMats = matAmount[0] + matAmount[1] + matAmount[2] + matAmount[3];
        float te = 4000.0f;
        if (type == 0) {
            eqlistOrg = EquipSmall;
            te = 256.0f;
        } else {
            eqlistOrg = EquipLarge;
        }
        HashMap<Integer, Float> probList = new HashMap<Integer, Float>();
        int meanNew = 0;
        int meanDist = 0;
        float prob = 0.0f;
        for (int[] i : eqlistOrg) {
            meanNew = i[2] >= 0 && i[2] <= 3 ? i[1] - matAmount[i[2]] : i[1];
            meanDist = MathHelper.func_76130_a((int)(totalMats - meanNew));
            if (type == 0) {
                meanDist = (int)((float)meanDist * 15.625f);
            }
            prob = CalcHelper.getNormDist(meanDist);
            probList.put(i[0], Float.valueOf(prob));
            LogHelper.info("DEBUG: roll equip type: prob list: ID " + i[0] + " MEAN(ORG) " + i[1] + " MEAN(NEW) " + meanNew + " MEAN(P) " + (float)meanNew / te + " MD " + meanDist + " PR " + prob);
        }
        float random = rand.nextFloat();
        float totalProb = 0.0f;
        float sumProb = 0.0125f;
        int rollresult = -1;
        for (Map.Entry entry : probList.entrySet()) {
            totalProb += ((Float)entry.getValue()).floatValue();
        }
        random *= totalProb;
        for (Map.Entry entry : probList.entrySet()) {
            LogHelper.info("DEBUG: roll equip type: random: " + random + " sum.pr " + (sumProb += ((Float)entry.getValue()).floatValue()) + " total.pr " + totalProb);
            if (!(sumProb > random)) continue;
            rollresult = (Integer)entry.getKey();
            LogHelper.info("DEBUG: roll item: get type:" + rollresult);
            break;
        }
        return rollresult;
    }

    public static ItemStack rollEquipsOfTheType(int type, int totalMatParam, int buildType) {
        if (type == -1) {
            return null;
        }
        HashMap<Integer, Float> equipList = new HashMap<Integer, Float>();
        for (Map.Entry<Integer, float[]> entry : Values.EquipMap.entrySet()) {
            int eid = entry.getKey();
            float[] val = entry.getValue();
            if (val[16] != (float)type) continue;
            float prob = 0.0f;
            int n = 0;
            int meanDist = 0;
            float te = 4000.0f;
            if (buildType == 0) {
                n = (int)((float)totalMatParam * 15.625f);
                te = 256.0f;
            }
            meanDist = MathHelper.func_76130_a((int)(n - (int)val[17]));
            prob = CalcHelper.getNormDist(meanDist);
            equipList.put(eid, Float.valueOf(prob));
            LogHelper.info("DEBUG: calc equip: prob list: ID " + eid + " MEAN " + val[17] + " MEAN(P) " + val[17] / te + " MD " + meanDist + " PR " + prob);
        }
        float random = rand.nextFloat();
        float totalProb = 0.0f;
        float sumProb = 0.0125f;
        int rollResult = -1;
        for (Map.Entry<Integer, Object> entry : equipList.entrySet()) {
            totalProb += ((Float)entry.getValue()).floatValue();
        }
        random *= totalProb;
        for (Map.Entry<Integer, Object> entry : equipList.entrySet()) {
            LogHelper.info("DEBUG: roll equip: type: " + type + " random: " + random + " sum.pr " + (sumProb += ((Float)entry.getValue()).floatValue()) + " total.pr " + totalProb);
            if (!(sumProb > random)) continue;
            rollResult = entry.getKey();
            LogHelper.info("DEBUG: roll item: get item:" + rollResult);
            break;
        }
        return EquipCalc.getItemStackFromId(rollResult);
    }

    private static ItemStack getItemStackFromId(int itemID) {
        ItemStack item = null;
        int itemType = itemID % 100;
        int itemSubType = itemID / 100;
        switch (itemType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                item = new ItemStack((Item)ModItems.EquipCannon);
                break;
            }
            case 20: 
            case 21: {
                item = new ItemStack((Item)ModItems.EquipMachinegun);
                break;
            }
            case 4: 
            case 5: {
                item = new ItemStack((Item)ModItems.EquipTorpedo);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                item = new ItemStack((Item)ModItems.EquipAirplane);
                break;
            }
            case 14: 
            case 15: {
                item = new ItemStack((Item)ModItems.EquipRadar);
                break;
            }
            case 16: 
            case 17: {
                item = new ItemStack((Item)ModItems.EquipTurbine);
                break;
            }
            case 18: 
            case 19: {
                item = new ItemStack((Item)ModItems.EquipArmor);
                break;
            }
            case 22: 
            case 23: {
                item = new ItemStack((Item)ModItems.EquipCatapult);
                break;
            }
            case 24: {
                item = new ItemStack((Item)ModItems.EquipDrum);
                break;
            }
            case 25: {
                item = new ItemStack((Item)ModItems.EquipCompass);
                break;
            }
            case 26: {
                item = new ItemStack((Item)ModItems.EquipFlare);
                break;
            }
            case 27: {
                item = new ItemStack((Item)ModItems.EquipSearchlight);
                break;
            }
            default: {
                item = null;
            }
        }
        if (item != null) {
            item.func_77964_b(itemSubType);
        }
        LogHelper.info("DEBUG : equip calc: get itemstack: " + itemType + " " + itemSubType + " " + item);
        return item;
    }

    static {
        EquipSmall.add(new int[]{18, 80, 1});
        EquipSmall.add(new int[]{26, 80, 2});
        EquipSmall.add(new int[]{27, 80, 0});
        EquipSmall.add(new int[]{25, 90, 0});
        EquipSmall.add(new int[]{20, 100, 2});
        EquipSmall.add(new int[]{24, 120, 1});
        EquipSmall.add(new int[]{0, 128, 2});
        EquipSmall.add(new int[]{4, 160, 2});
        EquipSmall.add(new int[]{14, 200, 0});
        EquipSmall.add(new int[]{12, 256, 3});
        EquipSmall.add(new int[]{1, 320, 2});
        EquipLarge.add(new int[]{19, 500, 1});
        EquipLarge.add(new int[]{21, 800, 2});
        EquipLarge.add(new int[]{13, 1000, 3});
        EquipLarge.add(new int[]{5, 1200, 2});
        EquipLarge.add(new int[]{16, 1400, 0});
        EquipLarge.add(new int[]{2, 1600, 2});
        EquipLarge.add(new int[]{15, 2000, 0});
        EquipLarge.add(new int[]{6, 2400, 3});
        EquipLarge.add(new int[]{8, 2400, 3});
        EquipLarge.add(new int[]{10, 2400, 3});
        EquipLarge.add(new int[]{22, 2800, 3});
        EquipLarge.add(new int[]{17, 3200, 0});
        EquipLarge.add(new int[]{7, 3800, 3});
        EquipLarge.add(new int[]{9, 3800, 3});
        EquipLarge.add(new int[]{11, 3800, 3});
        EquipLarge.add(new int[]{3, 4400, 2});
        EquipLarge.add(new int[]{23, 5000, 3});
    }
}

