/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.command;

import com.lulan.shincolle.command.BasicShipCommand;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipOwner;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ShipCmdUpdateOwnerUID
extends BasicShipCommand {
    private static final List Aliases = new ArrayList(){
        {
            this.add("shipupdateowneruid");
        }
    };

    @Override
    public String func_71517_b() {
        return "shipupdateowneruid";
    }

    @Override
    public List func_71514_a() {
        return Aliases;
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/shipupdateowneruid [player name (OP only)]";
    }

    @Override
    public boolean func_71519_b(ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    @Override
    public List func_71516_a(ICommandSender sender, String[] cmd) {
        return ShipCmdUpdateOwnerUID.getListOfStringsMatchingLastWord(cmd, MinecraftServer.func_71276_C().func_71213_z());
    }

    @Override
    public boolean func_82358_a(String[] cmd, int index) {
        return cmd.length > 0 && index == 0;
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] cmd) {
        World world = sender.func_130014_f_();
        EntityPlayer player = null;
        Object uuid = null;
        int pid = -1;
        boolean isOP = false;
        if (!world.field_72995_K && sender instanceof EntityPlayer) {
            player = (EntityPlayer)sender;
            isOP = EntityHelper.checkOP(player);
            if (cmd.length == 0) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipUpdateOwnerUID: get player " + EnumChatFormatting.AQUA + player));
                this.updateShipOwner(player);
            } else if (isOP) {
                player = EntityHelper.getEntityPlayerByName(cmd[0]);
                if (player != null) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipUpdateOwnerUID: get player " + EnumChatFormatting.AQUA + player));
                    this.updateShipOwner(player);
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipUpdateOwnerUID: this command is OP only!"));
                return;
            }
        }
    }

    private void updateShipOwner(EntityPlayer player) {
        String uuid = player.func_110124_au().toString();
        int pid = EntityHelper.getPlayerUID((Entity)player);
        player.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipUpdateOwnerUID: owner: " + EnumChatFormatting.AQUA + pid + " " + EnumChatFormatting.LIGHT_PURPLE + uuid));
        if (uuid != null && uuid.length() > 3) {
            WorldServer[] worlds = ServerProxy.getServerWorld();
            try {
                for (WorldServer w : worlds) {
                    for (Object obj : w.field_72996_f) {
                        BasicEntityShip ship;
                        if (!(obj instanceof BasicEntityShip) || !EntityHelper.getPetPlayerUUID(ship = (BasicEntityShip)obj).equals(uuid)) continue;
                        EntityHelper.setPetPlayerUID(pid, (IShipOwner)ship);
                        player.func_145747_a((IChatComponent)new ChatComponentText("get ship: " + EnumChatFormatting.GOLD + ship));
                        ship.sendSyncPacketAllValue();
                    }
                }
            }
            catch (Exception e) {
                LogHelper.info("DEBUG : Command: ShipUpdateOwnerUID: change ship's owner fail: " + e);
            }
        }
    }
}

