/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.client.render;

import com.lulan.shincolle.entity.IShipEmotion;
import com.lulan.shincolle.reference.Values;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BasicShipRenderer
extends RenderLiving {
    private static final ResourceLocation AP_Wa = new ResourceLocation("shincolle:textures/entity/EntityTransportWa.png");
    private static final ResourceLocation BB_Re = new ResourceLocation("shincolle:textures/entity/EntityBattleshipRe.png");
    private static final ResourceLocation BB_Ta = new ResourceLocation("shincolle:textures/entity/EntityBattleshipTa.png");
    private static final ResourceLocation CA_Ri = new ResourceLocation("shincolle:textures/entity/EntityHeavyCruiserRi.png");
    private static final ResourceLocation CA_Ne = new ResourceLocation("shincolle:textures/entity/EntityHeavyCruiserNe.png");
    private static final ResourceLocation CV_Wo = new ResourceLocation("shincolle:textures/entity/EntityCarrierWo.png");
    private static final ResourceLocation DD_I = new ResourceLocation("shincolle:textures/entity/EntityDestroyerI.png");
    private static final ResourceLocation DD_Ro = new ResourceLocation("shincolle:textures/entity/EntityDestroyerRo.png");
    private static final ResourceLocation DD_Ha = new ResourceLocation("shincolle:textures/entity/EntityDestroyerHa.png");
    private static final ResourceLocation DD_Ni = new ResourceLocation("shincolle:textures/entity/EntityDestroyerNi.png");
    private static final ResourceLocation Hime_Airfield = new ResourceLocation("shincolle:textures/entity/EntityAirfieldHime.png");
    private static final ResourceLocation Hime_Battleship = new ResourceLocation("shincolle:textures/entity/EntityBattleshipHime.png");
    private static final ResourceLocation Hime_Carrier = new ResourceLocation("shincolle:textures/entity/EntityCarrierHime.png");
    private static final ResourceLocation Hime_Harbour = new ResourceLocation("shincolle:textures/entity/EntityHarbourHime.png");
    private static final ResourceLocation Hime_Northern = new ResourceLocation("shincolle:textures/entity/EntityNorthernHime.png");
    private static final ResourceLocation SS_Ka = new ResourceLocation("shincolle:textures/entity/EntitySubmKa.png");
    private static final ResourceLocation SS_Yo = new ResourceLocation("shincolle:textures/entity/EntitySubmYo.png");
    private static final ResourceLocation SS_So = new ResourceLocation("shincolle:textures/entity/EntitySubmSo.png");
    private static final ResourceLocation WD_Carrier = new ResourceLocation("shincolle:textures/entity/EntityCarrierWDemon.png");
    private static final ResourceLocation BB_Nagato = new ResourceLocation("shincolle:textures/entity/EntityBattleshipNagato.png");
    private static final ResourceLocation BB_Yamato = new ResourceLocation("shincolle:textures/entity/EntityBattleshipYamato.png");
    private static final ResourceLocation CV_Akagi = new ResourceLocation("shincolle:textures/entity/EntityCarrierAkagi.png");
    private static final ResourceLocation CV_Kaga = new ResourceLocation("shincolle:textures/entity/EntityCarrierKaga.png");
    private static final ResourceLocation DD_Akatsuki = new ResourceLocation("shincolle:textures/entity/EntityDestroyerAkatsuki.png");
    private static final ResourceLocation DD_Hibiki = new ResourceLocation("shincolle:textures/entity/EntityDestroyerHibiki.png");
    private static final ResourceLocation DD_Ikazuchi = new ResourceLocation("shincolle:textures/entity/EntityDestroyerIkazuchi.png");
    private static final ResourceLocation DD_Inazuma = new ResourceLocation("shincolle:textures/entity/EntityDestroyerInazuma.png");
    private static final ResourceLocation DD_Shimakaze = new ResourceLocation("shincolle:textures/entity/EntityDestroyerShimakaze.png");
    private static final ResourceLocation SS_Ro500 = new ResourceLocation("shincolle:textures/entity/EntitySubmRo500.png");
    private static final ResourceLocation SS_U511 = new ResourceLocation("shincolle:textures/entity/EntitySubmU511.png");
    protected int shipClass;

    public BasicShipRenderer(ModelBase model, float scale) {
        super(model, scale);
    }

    public BasicShipRenderer(ModelBase model, float scale, int shipClass) {
        super(model, scale);
        this.shipClass = shipClass;
    }

    protected ResourceLocation func_110775_a(Entity host) {
        return this.getShipTexture(this.shipClass);
    }

    private ResourceLocation getShipTexture(int id) {
        switch (id) {
            case 16: {
                return AP_Wa;
            }
            case 14: {
                return BB_Ta;
            }
            case 15: {
                return BB_Re;
            }
            case 9: {
                return CA_Ri;
            }
            case 10: {
                return CA_Ne;
            }
            case 12: {
                return CV_Wo;
            }
            case 0: {
                return DD_I;
            }
            case 1: {
                return DD_Ro;
            }
            case 2: {
                return DD_Ha;
            }
            case 3: {
                return DD_Ni;
            }
            case 21: {
                return Hime_Airfield;
            }
            case 26: {
                return Hime_Battleship;
            }
            case 20: {
                return Hime_Carrier;
            }
            case 28: {
                return Hime_Harbour;
            }
            case 31: {
                return Hime_Northern;
            }
            case 17: {
                return SS_Ka;
            }
            case 19: {
                return SS_So;
            }
            case 18: {
                return SS_Yo;
            }
            case 33: {
                return WD_Carrier;
            }
            case 37: {
                return BB_Nagato;
            }
            case 46: {
                return BB_Yamato;
            }
            case 48: {
                return CV_Akagi;
            }
            case 47: {
                return CV_Kaga;
            }
            case 51: {
                return DD_Akatsuki;
            }
            case 52: {
                return DD_Hibiki;
            }
            case 53: {
                return DD_Ikazuchi;
            }
            case 54: {
                return DD_Inazuma;
            }
            case 36: {
                return DD_Shimakaze;
            }
            case 39: {
                return SS_Ro500;
            }
            case 38: {
                return SS_U511;
            }
        }
        return null;
    }

    protected float[] getLeashHeight() {
        return Values.ShipLeashHeight.get((short)this.shipClass);
    }

    protected void func_110827_b(EntityLiving host, double d, double d1, double d2, float f, float f1) {
        Entity entity = host.func_110166_bE();
        float[] leashHeight = this.getLeashHeight();
        if (entity != null) {
            float f2;
            int i;
            IShipEmotion host1 = (IShipEmotion)host;
            d1 = host1.getIsRiding() ? (host1.getIsSitting() ? (d1 -= (1.6 - (double)host.field_70131_O) * 0.5 + (double)leashHeight[2]) : (d1 -= (1.6 - (double)host.field_70131_O) * 0.5 + (double)leashHeight[1])) : (host1.getIsSitting() ? (d1 -= (1.6 - (double)host.field_70131_O) * 0.5 + (double)leashHeight[3]) : (d1 -= (1.6 - (double)host.field_70131_O) * 0.5 + (double)leashHeight[4]));
            Tessellator tessellator = Tessellator.field_78398_a;
            double d3 = this.interp(entity.field_70126_B, entity.field_70177_z, f1 * 0.5f) * 0.01745329238474369;
            double d4 = this.interp(entity.field_70127_C, entity.field_70125_A, f1 * 0.5f) * 0.01745329238474369;
            double d5 = Math.cos(d3);
            double d6 = Math.sin(d3);
            double d7 = Math.sin(d4);
            if (entity instanceof EntityHanging) {
                d5 = 0.0;
                d6 = 0.0;
                d7 = -1.0;
            }
            double d8 = Math.cos(d4);
            double d9 = this.interp(entity.field_70169_q, entity.field_70165_t, f1) - d5 * 0.7 - d6 * 0.5 * d8;
            double d10 = this.interp(entity.field_70167_r + (double)entity.func_70047_e() * 0.7, entity.field_70163_u + (double)entity.func_70047_e() * 0.7, f1) - d7 * 0.5 - 0.25;
            double d11 = this.interp(entity.field_70166_s, entity.field_70161_v, f1) - d6 * 0.7 + d5 * 0.5 * d8;
            double d12 = this.interp(host.field_70760_ar, host.field_70761_aq, f1) * 0.01745329238474369 + 1.5707963267948966;
            d5 = Math.cos(d12) * (double)host.field_70130_N * (double)leashHeight[0];
            d6 = Math.sin(d12) * (double)host.field_70130_N * (double)leashHeight[0];
            double d13 = this.interp(host.field_70169_q, host.field_70165_t, f1) + d5;
            double d14 = this.interp(host.field_70167_r, host.field_70163_u, f1);
            double d15 = this.interp(host.field_70166_s, host.field_70161_v, f1) + d6;
            d += d5;
            d2 += d6;
            double d16 = (float)(d9 - d13);
            double d17 = (float)(d10 - d14);
            double d18 = (float)(d11 - d15);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            boolean flag = true;
            double d19 = 0.025;
            tessellator.func_78371_b(5);
            for (i = 0; i <= 24; ++i) {
                if (i % 2 == 0) {
                    tessellator.func_78369_a(0.5f, 0.4f, 0.3f, 1.0f);
                } else {
                    tessellator.func_78369_a(0.35f, 0.28f, 0.21000001f, 1.0f);
                }
                f2 = (float)i / 24.0f;
                tessellator.func_78377_a(d + d16 * (double)f2 + 0.0, d1 + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f), d2 + d18 * (double)f2);
                tessellator.func_78377_a(d + d16 * (double)f2 + 0.025, d1 + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f) + 0.025, d2 + d18 * (double)f2);
            }
            tessellator.func_78381_a();
            tessellator.func_78371_b(5);
            for (i = 0; i <= 24; ++i) {
                if (i % 2 == 0) {
                    tessellator.func_78369_a(0.5f, 0.4f, 0.3f, 1.0f);
                } else {
                    tessellator.func_78369_a(0.35f, 0.28f, 0.21000001f, 1.0f);
                }
                f2 = (float)i / 24.0f;
                tessellator.func_78377_a(d + d16 * (double)f2 + 0.0, d1 + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f) + 0.025, d2 + d18 * (double)f2);
                tessellator.func_78377_a(d + d16 * (double)f2 + 0.025, d1 + d17 * (double)(f2 * f2 + f2) * 0.5 + (double)((24.0f - (float)i) / 18.0f + 0.125f), d2 + d18 * (double)f2 + 0.025);
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2884);
        }
    }

    private double interp(double par1, double par2, double par3) {
        return par1 + (par2 - par1) * par3;
    }
}

