/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai.path;

import net.minecraft.util.MathHelper;

public class ShipPathPoint {
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    private final int hash;
    public int index = -1;
    public float totalPathDistance;
    public float distanceToNext;
    public float distanceToTarget;
    public ShipPathPoint previous;
    public boolean isFirst;

    public ShipPathPoint(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.hash = ShipPathPoint.makeHash(x, y, z);
    }

    public static int makeHash(int x, int y, int z) {
        return y & 0xFF | (x & Short.MAX_VALUE) << 8 | (z & Short.MAX_VALUE) << 24 | (x < 0 ? Integer.MIN_VALUE : 0) | (z < 0 ? 32768 : 0);
    }

    public float distanceTo(ShipPathPoint point) {
        float f = point.xCoord - this.xCoord;
        float f1 = point.yCoord - this.yCoord;
        float f2 = point.zCoord - this.zCoord;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public float distanceToSquared(ShipPathPoint point) {
        float f = point.xCoord - this.xCoord;
        float f1 = point.yCoord - this.yCoord;
        float f2 = point.zCoord - this.zCoord;
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShipPathPoint)) {
            return false;
        }
        ShipPathPoint pathpoint = (ShipPathPoint)obj;
        return this.hash == pathpoint.hash && this.xCoord == pathpoint.xCoord && this.yCoord == pathpoint.yCoord && this.zCoord == pathpoint.zCoord;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAssigned() {
        return this.index >= 0;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord;
    }
}

