/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai;

import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipEmotion;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.utility.TargetHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;

public class EntityAIShipPickItem
extends EntityAIBase {
    protected TargetHelper.Sorter targetSorter;
    private IShipEmotion host;
    private BasicEntityShip hostShip;
    private BasicEntityMount hostMount;
    private EntityLivingBase hostLiving;
    private Entity entItem;
    private int pickDelay;
    private int pickDelayMax;
    private float pickRange;
    private float pickRangeBase;

    public EntityAIShipPickItem(IShipEmotion entity, float pickRangeBase) {
        this.func_75248_a(7);
        this.host = entity;
        this.hostLiving = (EntityLivingBase)entity;
        this.pickRangeBase = pickRangeBase;
        this.pickDelay = 0;
        if (entity instanceof BasicEntityShip) {
            this.hostShip = (BasicEntityShip)entity;
            this.targetSorter = new TargetHelper.Sorter((Entity)this.hostShip);
        } else if (entity instanceof BasicEntityMount) {
            this.hostMount = (BasicEntityMount)entity;
            this.hostShip = (BasicEntityShip)this.hostMount.getHostEntity();
            this.targetSorter = new TargetHelper.Sorter((Entity)this.hostMount);
        }
        this.updateShipParms();
    }

    public boolean func_75250_a() {
        if (this.hostShip != null) {
            if (this.hostShip.func_70115_ae() || this.hostShip.func_70906_o() || !this.hostShip.getStateFlag(23) || this.hostShip.getStateMinor(43) > 0 || this.hostShip.getStateFlag(2)) {
                return false;
            }
            if (this.hostShip.getExtProps().getFirstSlotForItem() > 0) {
                return true;
            }
        } else if (this.hostMount != null && this.hostShip != null) {
            if (this.hostShip.func_70906_o() || !this.hostShip.getStateFlag(23) || this.hostShip.getStateMinor(43) > 0 || this.hostShip.getStateFlag(2)) {
                return false;
            }
            if (this.hostShip.getExtProps().getFirstSlotForItem() > 0) {
                return true;
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.hostShip != null) {
            --this.pickDelay;
            if (this.hostShip.field_70173_aa % 16 == 0) {
                this.updateShipParms();
                this.entItem = this.getNearbyEntityItem();
                if (this.entItem != null && this.entItem.func_70089_S()) {
                    if (this.hostMount != null) {
                        this.hostMount.getShipNavigate().tryMoveToEntityLiving(this.entItem, 1.0);
                    } else if (this.hostShip != null) {
                        this.hostShip.getShipNavigate().tryMoveToEntityLiving(this.entItem, 1.0);
                    }
                }
            }
            if (this.pickDelay <= 0 && this.entItem != null) {
                this.pickDelay = this.pickDelayMax;
                if (this.hostMount != null && this.hostMount.func_70068_e(this.entItem) < 9.0 || this.hostShip != null && this.hostShip.func_70068_e(this.entItem) < 9.0) {
                    EntityItem entitem = (EntityItem)this.entItem;
                    ItemStack itemstack = entitem.func_92059_d();
                    int i = itemstack.field_77994_a;
                    if (entitem.field_145804_b <= 0 && this.hostShip.getExtProps().addItemStackToInventory(itemstack)) {
                        this.hostShip.field_70170_p.func_72956_a((Entity)this.hostShip, "random.pop", ConfigHandler.volumeShip, ((this.hostShip.func_70681_au().nextFloat() - this.hostShip.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        if (this.hostShip.soundCD <= 0 && this.hostShip.func_70681_au().nextInt(2) == 0) {
                            this.hostShip.soundCD = 40 + this.hostShip.func_70681_au().nextInt(10);
                            this.hostShip.field_70170_p.func_72956_a((Entity)this.hostShip, this.hostShip.getSoundString(7), ConfigHandler.volumeShip, 1.0f);
                        }
                        this.hostShip.func_71001_a((Entity)entitem, i);
                        this.hostShip.applyParticleAtAttacker(0, null, null);
                        this.hostShip.addShipExp(ConfigHandler.expGain[6]);
                        if (itemstack.field_77994_a <= 0) {
                            entitem.func_70106_y();
                            this.entItem = null;
                        }
                    }
                    this.hostShip.getShipNavigate().clearPathEntity();
                    if (this.hostMount != null) {
                        this.hostMount.getShipNavigate().clearPathEntity();
                    }
                }
            }
        }
    }

    private Entity getNearbyEntityItem() {
        Entity getitem = null;
        List getlist = null;
        getlist = this.hostShip.field_70170_p.func_72872_a(EntityItem.class, this.hostShip.field_70121_D.func_72314_b((double)this.pickRange, (double)(this.pickRange * 0.5f + 1.0f), (double)this.pickRange));
        if (getlist != null && !getlist.isEmpty()) {
            Collections.sort(getlist, this.targetSorter);
            getitem = (Entity)getlist.get(0);
        }
        return getitem;
    }

    private void updateShipParms() {
        float speed = this.hostShip.getAttackSpeed();
        if (speed < 1.0f) {
            speed = 1.0f;
        }
        this.pickDelayMax = (int)(10.0f / speed);
        float tempran = this.pickRangeBase + (float)this.hostShip.getStateMinor(11);
        this.pickRange = this.pickRangeBase + this.hostShip.getAttackRange() * 0.5f;
        this.pickRange = Math.min(tempran, this.pickRange);
    }
}

