/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai;

import com.lulan.shincolle.ai.path.ShipPathNavigate;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipAircraftAttack;
import com.lulan.shincolle.entity.IShipCannonAttack;
import com.lulan.shincolle.entity.IShipGuardian;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.FormationHelper;
import com.lulan.shincolle.utility.LogHelper;
import com.lulan.shincolle.utility.TargetHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class EntityAIShipGuarding
extends EntityAIBase {
    private IShipGuardian host;
    private EntityLiving host2;
    private EntityPlayer owner;
    private Entity guarded;
    private ShipPathNavigate ShipNavigator;
    private final TargetHelper.Sorter targetSorter;
    private final TargetHelper.Selector targetSelector;
    private int checkTP_T;
    private int checkTP_D;
    private int findCooldown;
    private double maxDistSq;
    private double minDistSq;
    private double distSq;
    private double distX;
    private double distY;
    private double distZ;
    private double[] pos;
    private double[] guardPosOld;
    private IShipCannonAttack ship;
    private IShipAircraftAttack ship2;
    private EntityLivingBase target;
    private int[] delayTime;
    private int[] maxDelayTime;
    private int onSightTime;
    private int aimTime;
    private float range;
    private float rangeSq;
    private boolean launchType;
    private boolean isMoving;
    private double tarDist;
    private double tarDistSqrt;
    private double tarDistX;
    private double tarDistY;
    private double tarDistZ;

    public EntityAIShipGuarding(IShipGuardian entity) {
        this.host = entity;
        this.host2 = (EntityLiving)entity;
        this.ShipNavigator = entity.getShipNavigate();
        this.targetSorter = new TargetHelper.Sorter((Entity)this.host2);
        this.targetSelector = new TargetHelper.Selector((Entity)this.host2);
        this.distSq = 1.0;
        this.isMoving = false;
        this.func_75248_a(7);
        if (entity instanceof IShipCannonAttack) {
            this.ship = (IShipCannonAttack)((Object)entity);
            if (entity instanceof IShipAircraftAttack) {
                this.ship2 = (IShipAircraftAttack)((Object)entity);
            }
        }
        if (entity instanceof BasicEntityShip || entity instanceof BasicEntityMount) {
            this.owner = EntityHelper.getEntityPlayerByUID(entity.getPlayerUID());
        }
        this.pos = new double[]{-1.0, -1.0, -1.0};
        this.guardPosOld = new double[]{-1.0, -100.0, -1.0};
        this.delayTime = new int[]{20, 20, 20};
        this.maxDelayTime = new int[]{20, 40, 40};
        this.onSightTime = 0;
        this.aimTime = 20;
        this.range = 1.0f;
        this.rangeSq = 1.0f;
    }

    public boolean func_75250_a() {
        if (!(this.host == null || this.host.getIsRiding() || this.host.getIsSitting() || this.host.getStateFlag(11) || this.host.getStateMinor(43) >= 1)) {
            return this.checkGuardTarget();
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.host != null) {
            if (!(this.host.getIsRiding() || this.host.getIsSitting() || this.host.getStateFlag(11) || this.host.getStateMinor(43) >= 1)) {
                if (this.distSq > this.minDistSq) {
                    return true;
                }
                return !this.ShipNavigator.noPath() || this.func_75250_a();
            }
            this.func_75251_c();
            return false;
        }
        return false;
    }

    public void func_75249_e() {
        this.findCooldown = 10;
        this.checkTP_T = 0;
        this.checkTP_D = 0;
    }

    public void func_75251_c() {
        this.guarded = null;
        this.isMoving = false;
        this.findCooldown = 10;
        this.ShipNavigator.clearPathEntity();
    }

    public void func_75246_d() {
        if (this.isMoving && this.ship != null && !this.ship.getStateFlag(21) && this.ship.getStateMinor(24) > 0) {
            if (this.host2.field_70173_aa % 64 == 0) {
                this.updateAttackParms();
            }
            this.delayTime[0] = this.delayTime[0] - 1;
            this.delayTime[1] = this.delayTime[1] - 1;
            this.delayTime[2] = this.delayTime[2] - 1;
            if (this.host2.field_70173_aa % 32 == 0) {
                this.findTarget();
                if (this.target != null && !this.target.func_70089_S()) {
                    this.target = null;
                }
            }
            if (this.target != null && this.host2.func_70635_at().func_75522_a((Entity)this.target)) {
                ++this.onSightTime;
                this.tarDistX = this.target.field_70165_t - this.host2.field_70165_t;
                this.tarDistY = this.target.field_70163_u - this.host2.field_70163_u;
                this.tarDistZ = this.target.field_70161_v - this.host2.field_70161_v;
                this.tarDistSqrt = this.tarDistX * this.tarDistX + this.tarDistY * this.tarDistY + this.tarDistZ * this.tarDistZ;
                if (this.tarDistSqrt <= (double)this.rangeSq && this.onSightTime >= this.aimTime) {
                    this.attackTarget();
                }
            } else {
                this.onSightTime = 0;
            }
        }
        if (this.host != null) {
            --this.findCooldown;
            if (this.host2.field_70159_w * this.host2.field_70159_w < 3.0E-4 && this.host2.field_70179_y * this.host2.field_70179_y < 3.0E-4) {
                ++this.checkTP_T;
            }
            if (this.host2.field_70173_aa % 8 == 0 && !this.checkGuardTarget()) {
                return;
            }
            if (this.distSq <= this.minDistSq) {
                this.isMoving = false;
                this.ShipNavigator.clearPathEntity();
            }
            if (this.findCooldown <= 0) {
                this.findCooldown = 20;
                this.isMoving = this.ShipNavigator.tryMoveToXYZ(this.pos[0], this.pos[1], this.pos[2], 1.0);
            }
            this.host2.func_70671_ap().func_75650_a(this.pos[0], this.pos[1], this.pos[2], 30.0f, (float)this.host2.func_70646_bf());
            if (this.host2.field_71093_bK == this.host.getGuardedPos(3)) {
                if (this.distSq > (double)ConfigHandler.shipTeleport[1]) {
                    ++this.checkTP_D;
                    if (this.checkTP_D > ConfigHandler.shipTeleport[0]) {
                        this.checkTP_D = 0;
                        if (this.host2 != null && this.owner != null) {
                            LogHelper.info("DEBUG : guard AI: distSQ > " + ConfigHandler.shipTeleport[1] + " , teleport to target. dim: " + this.host2.field_71093_bK + " " + this.owner.field_71093_bK);
                        }
                        this.applyTeleport();
                        return;
                    }
                }
                if (this.checkTP_T > ConfigHandler.shipTeleport[0]) {
                    this.checkTP_T = 0;
                    if (this.host2 != null && this.owner != null) {
                        LogHelper.info("DEBUG : guard AI: teleport entity: dimension check: " + this.host2.field_71093_bK + " " + this.owner.field_71093_bK);
                    }
                    this.applyTeleport();
                    return;
                }
            } else {
                this.host.setGuardedPos(-1, -1, -1, 0, 0);
                this.host.setGuardedEntity(null);
                this.host.setStateFlag(11, true);
            }
        }
    }

    private void applyTeleport() {
        if (this.host2 instanceof BasicEntityMount) {
            BasicEntityShip ship = (BasicEntityShip)((BasicEntityMount)this.host2).getHostEntity();
            EntityHelper.clearMountSeat(this.host2);
            EntityHelper.clearMountSeat((EntityLiving)ship);
            this.ShipNavigator.clearPathEntity();
            ship.func_70107_b(this.pos[0], this.pos[1] + 0.5, this.pos[2]);
            this.host2.func_70107_b(this.pos[0], this.pos[1] + 0.5, this.pos[2]);
            this.sendSyncPacket((Entity)ship);
        } else {
            EntityHelper.clearMountSeat(this.host2);
            this.ShipNavigator.clearPathEntity();
            this.host2.func_70107_b(this.pos[0], this.pos[1] + 0.5, this.pos[2]);
            this.sendSyncPacket((Entity)this.host2);
        }
    }

    private void sendSyncPacket(Entity ent) {
        if (ent == null) {
            return;
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(ent.field_71093_bK, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 64.0);
        CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(ent, 0, 9), point);
    }

    private void updateAttackParms() {
        if (this.ship != null) {
            this.range = (int)this.ship.getAttackRange();
            if (this.range < 1.0f) {
                this.range = 1.0f;
            }
            this.rangeSq = this.range * this.range;
            this.maxDelayTime[0] = (int)((float)ConfigHandler.baseAttackSpeed[1] / this.ship.getAttackSpeed()) + ConfigHandler.fixedAttackDelay[1];
            this.maxDelayTime[1] = (int)((float)ConfigHandler.baseAttackSpeed[2] / this.ship.getAttackSpeed()) + ConfigHandler.fixedAttackDelay[2];
            this.maxDelayTime[2] = (int)((float)ConfigHandler.baseAttackSpeed[3] / this.ship.getAttackSpeed()) + ConfigHandler.fixedAttackDelay[3];
            this.aimTime = (int)(20.0f * (float)(150 - this.host.getLevel()) / 150.0f) + 10;
        }
    }

    private void findTarget() {
        List list1 = this.host2.field_70170_p.func_82733_a(EntityLivingBase.class, this.host2.field_70121_D.func_72314_b((double)this.range, (double)this.range * 0.6, (double)this.range), (IEntitySelector)this.targetSelector);
        Collections.sort(list1, this.targetSorter);
        if (list1.size() > 2) {
            this.target = (EntityLivingBase)list1.get(this.host2.field_70170_p.field_73012_v.nextInt(3));
        } else if (!list1.isEmpty()) {
            this.target = (EntityLivingBase)list1.get(0);
        }
    }

    private void attackTarget() {
        if (this.ship.getStateFlag(13) && this.delayTime[0] <= 0 && this.ship.useAmmoLight() && this.ship.hasAmmoLight()) {
            this.ship.attackEntityWithAmmo((Entity)this.target);
            this.delayTime[0] = this.maxDelayTime[0];
        }
        if (this.ship.getStateFlag(14) && this.delayTime[1] <= 0 && this.ship.useAmmoHeavy() && this.ship.hasAmmoHeavy()) {
            this.ship.attackEntityWithHeavyAmmo((Entity)this.target);
            this.delayTime[1] = this.maxDelayTime[1];
        }
        if (this.ship2 != null && (this.ship2.getStateFlag(6) || this.ship2.getStateFlag(7)) && this.delayTime[2] <= 0) {
            if (!this.ship2.getStateFlag(6)) {
                this.launchType = false;
            }
            if (!this.ship2.getStateFlag(7)) {
                this.launchType = true;
            }
            if (this.launchType && this.ship2.hasAmmoLight() && this.ship2.hasAirLight()) {
                this.ship2.attackEntityWithAircraft((Entity)this.target);
                this.delayTime[2] = this.maxDelayTime[2];
            }
            if (!this.launchType && this.ship2.hasAmmoHeavy() && this.ship2.hasAirHeavy()) {
                this.ship2.attackEntityWithHeavyAircraft((Entity)this.target);
                this.delayTime[2] = this.maxDelayTime[2];
            }
            this.launchType = !this.launchType;
        }
    }

    private boolean checkGuardTarget() {
        this.guarded = this.host.getGuardedEntity();
        if (this.guarded != null) {
            if (!this.guarded.func_70089_S() || this.guarded.field_70170_p.field_73011_w.field_76574_g != this.host2.field_70170_p.field_73011_w.field_76574_g) {
                this.host.setGuardedPos(-1, -1, -1, 0, 0);
                this.host.setGuardedEntity(null);
                this.host.setStateFlag(11, true);
                this.func_75251_c();
                return false;
            }
            if (this.host.getStateMinor(26) > 0) {
                double dx = this.guardPosOld[0] - this.guarded.field_70165_t;
                double dy = this.guardPosOld[1] - this.guarded.field_70163_u;
                double dz = this.guardPosOld[2] - this.guarded.field_70161_v;
                double dsq = dx * dx + dy * dy + dz * dz;
                if (dsq > 6.0) {
                    this.pos = FormationHelper.getFormationGuardingPos(this.host, this.guarded, this.guardPosOld[0], this.guardPosOld[2]);
                    this.guardPosOld[0] = this.guarded.field_70165_t;
                    this.guardPosOld[1] = this.guarded.field_70163_u;
                    this.guardPosOld[2] = this.guarded.field_70161_v;
                    if ((ConfigHandler.alwaysShowTeamParticle || EntityHelper.checkInUsePointer(this.owner)) && this.owner != null && this.owner.field_71093_bK == this.host.getGuardedPos(3)) {
                        CommonProxy.channelP.sendTo((IMessage)new S2CSpawnParticle(25, this.pos[0], this.pos[1], this.pos[2], 0.3, 4.0, 0.0), (EntityPlayerMP)this.owner);
                    }
                }
                if (this.host2.field_70173_aa % 16 == 0 && (ConfigHandler.alwaysShowTeamParticle || EntityHelper.checkInUsePointer(this.owner)) && this.owner != null && this.owner.field_71093_bK == this.host.getGuardedPos(3)) {
                    CommonProxy.channelP.sendTo((IMessage)new S2CSpawnParticle(25, this.pos[0], this.pos[1], this.pos[2], 0.3, 6.0, 0.0), (EntityPlayerMP)this.owner);
                }
            } else {
                this.pos[0] = this.guarded.field_70165_t;
                this.pos[1] = this.guarded.field_70163_u;
                this.pos[2] = this.guarded.field_70161_v;
            }
        } else {
            this.pos[0] = (double)this.host.getStateMinor(14) + 0.5;
            this.pos[1] = (double)this.host.getStateMinor(15) + 0.5;
            this.pos[2] = (double)this.host.getStateMinor(16) + 0.5;
        }
        if (this.pos[1] <= 0.0 || this.host2.field_71093_bK != this.host.getGuardedPos(3)) {
            this.host.setGuardedPos(-1, -1, -1, 0, 0);
            this.host.setGuardedEntity(null);
            this.host.setStateFlag(11, true);
            this.func_75251_c();
            return false;
        }
        if (this.ship != null && this.ship.getStateMinor(26) > 0) {
            if (this.ship.getStateMinor(24) == 2) {
                this.minDistSq = 5.0;
                this.maxDistSq = 9.0;
            } else {
                this.minDistSq = 4.0;
                this.maxDistSq = 7.0;
            }
            if (this.host.getStateFlag(23)) {
                this.maxDistSq = 64.0;
            }
        } else {
            float fMin = (float)this.host.getStateMinor(10) + this.host2.field_70130_N * 0.75f;
            float fMax = (float)this.host.getStateMinor(11) + this.host2.field_70130_N * 0.75f;
            if (this.host.getStateFlag(23)) {
                fMax = (float)((double)fMax + 5.0);
            }
            this.minDistSq = fMin * fMin;
            this.maxDistSq = fMax * fMax;
        }
        this.distX = this.pos[0] - this.host2.field_70165_t;
        this.distY = this.pos[1] - this.host2.field_70163_u;
        this.distZ = this.pos[2] - this.host2.field_70161_v;
        this.distSq = this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ;
        return this.distSq > this.maxDistSq && this.host2.field_71093_bK == this.host.getStateMinor(17);
    }
}

