/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai;

import com.lulan.shincolle.ai.path.ShipPathNavigate;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.FormationHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class EntityAIShipFollowOwner
extends EntityAIBase {
    private IShipAttackBase host;
    private EntityLiving host2;
    private EntityLivingBase owner;
    private EntityPlayer player;
    private int checkTP_T;
    private int checkTP_D;
    private int findCooldown;
    private ShipPathNavigate ShipNavigator;
    private double maxDistSq;
    private double minDistSq;
    private double distSq;
    private double distX;
    private double distY;
    private double distZ;
    private double[] pos;
    private double[] ownerPosOld;

    public EntityAIShipFollowOwner(IShipAttackBase entity) {
        this.host = entity;
        this.host2 = (EntityLiving)entity;
        this.ShipNavigator = entity.getShipNavigate();
        this.distSq = 1.0;
        this.func_75248_a(7);
        this.pos = new double[]{this.host2.field_70165_t, this.host2.field_70163_u, this.host2.field_70161_v};
        this.ownerPosOld = new double[]{this.host2.field_70165_t, this.host2.field_70163_u, this.host2.field_70161_v};
        if (entity instanceof BasicEntityShip || entity instanceof BasicEntityMount) {
            this.player = EntityHelper.getEntityPlayerByUID(entity.getPlayerUID());
        }
    }

    public boolean func_75250_a() {
        EntityPlayer OwnerEntity;
        if (!this.host.getIsSitting() && !this.host.getIsRiding() && !this.host.getIsLeashed() && this.host.getStateFlag(11) && this.host.getStateMinor(43) < 1 && (OwnerEntity = EntityHelper.getEntityPlayerByUID(this.host.getPlayerUID())) != null) {
            this.owner = OwnerEntity;
            if (this.owner.field_71093_bK != this.host2.field_71093_bK) {
                return false;
            }
            this.updateDistance();
            if (this.distSq > this.maxDistSq) {
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.host != null && this.owner != null) {
            if (!this.host.getIsSitting() && !this.host.getIsRiding() && !this.host.getIsLeashed() && this.host.getStateFlag(11) && this.host.getStateMinor(43) < 1) {
                if (this.distSq > this.minDistSq) {
                    return true;
                }
                return !this.ShipNavigator.noPath() || this.func_75250_a();
            }
            this.func_75251_c();
            return false;
        }
        return false;
    }

    public void func_75249_e() {
        this.findCooldown = 10;
        this.checkTP_T = 0;
        this.checkTP_D = 0;
    }

    public void func_75251_c() {
        this.owner = null;
        this.ShipNavigator.clearPathEntity();
    }

    public void func_75246_d() {
        if (this.host != null) {
            --this.findCooldown;
            ++this.checkTP_T;
            if (this.host2.field_70173_aa % 32 == 0) {
                EntityPlayer OwnerEntity = EntityHelper.getEntityPlayerByUID(this.host.getPlayerUID());
                if (OwnerEntity != null) {
                    this.owner = OwnerEntity;
                    if (this.owner.field_71093_bK != this.host2.field_71093_bK) {
                        this.func_75251_c();
                        return;
                    }
                    this.updateDistance();
                } else {
                    this.func_75251_c();
                    return;
                }
            }
            if (this.distSq <= this.minDistSq) {
                this.ShipNavigator.clearPathEntity();
            }
            if (this.findCooldown <= 0) {
                this.findCooldown = 32;
                this.ShipNavigator.tryMoveToXYZ(this.pos[0], this.pos[1], this.pos[2], 1.0);
            }
            this.host2.func_70671_ap().func_75651_a((Entity)this.owner, 20.0f, 40.0f);
            if (this.host2.field_71093_bK == this.owner.field_71093_bK) {
                if (this.distSq > (double)ConfigHandler.shipTeleport[1]) {
                    ++this.checkTP_D;
                    if (this.checkTP_D > ConfigHandler.shipTeleport[0]) {
                        this.checkTP_D = 0;
                        LogHelper.info("DEBUG : follow AI: distSQ > " + ConfigHandler.shipTeleport[1] + " , teleport to target. dim: " + this.host2.field_71093_bK + " " + this.owner.field_71093_bK);
                        this.applyTeleport();
                        return;
                    }
                }
                if (this.checkTP_T > ConfigHandler.shipTeleport[0]) {
                    this.checkTP_T = 0;
                    LogHelper.info("DEBUG : follow AI: teleport entity: dimension check: " + this.host2.field_71093_bK + " " + this.owner.field_71093_bK);
                    this.applyTeleport();
                    return;
                }
            }
        }
    }

    private void applyTeleport() {
        if (this.host2 instanceof BasicEntityMount) {
            BasicEntityShip ship = (BasicEntityShip)((BasicEntityMount)this.host2).getHostEntity();
            EntityHelper.clearMountSeat(this.host2);
            EntityHelper.clearMountSeat((EntityLiving)ship);
            this.ShipNavigator.clearPathEntity();
            ship.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + 1.0, this.owner.field_70161_v);
            this.host2.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + 1.0, this.owner.field_70161_v);
            this.sendSyncPacket((Entity)ship);
        } else {
            EntityHelper.clearMountSeat(this.host2);
            this.ShipNavigator.clearPathEntity();
            this.host2.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + 1.0, this.owner.field_70161_v);
            this.sendSyncPacket((Entity)this.host2);
        }
    }

    private void sendSyncPacket(Entity ent) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(ent.field_71093_bK, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 48.0);
        CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(ent, 0, 9), point);
    }

    private void updateDistance() {
        if (this.host.getStateMinor(26) > 0) {
            this.minDistSq = 4.0;
            this.maxDistSq = 7.0;
            double dx = this.ownerPosOld[0] - this.owner.field_70165_t;
            double dy = this.ownerPosOld[1] - this.owner.field_70163_u;
            double dz = this.ownerPosOld[2] - this.owner.field_70161_v;
            double dsq = dx * dx + dy * dy + dz * dz;
            if (dsq > 7.0) {
                this.pos = FormationHelper.getFormationGuardingPos(this.host, (Entity)this.owner, this.ownerPosOld[0], this.ownerPosOld[2]);
                this.ownerPosOld[0] = this.owner.field_70165_t;
                this.ownerPosOld[1] = this.owner.field_70163_u;
                this.ownerPosOld[2] = this.owner.field_70161_v;
                if ((ConfigHandler.alwaysShowTeamParticle || EntityHelper.checkInUsePointer(this.player)) && this.player != null) {
                    CommonProxy.channelP.sendTo((IMessage)new S2CSpawnParticle(25, this.pos[0], this.pos[1], this.pos[2], 0.3, 4.0, 0.0), (EntityPlayerMP)this.player);
                }
            }
            if (this.host2.field_70173_aa % 16 == 0 && (ConfigHandler.alwaysShowTeamParticle || EntityHelper.checkInUsePointer(this.player)) && this.player != null) {
                CommonProxy.channelP.sendTo((IMessage)new S2CSpawnParticle(25, this.pos[0], this.pos[1], this.pos[2], 0.3, 6.0, 0.0), (EntityPlayerMP)this.player);
            }
            if (this.host.getStateFlag(23)) {
                this.maxDistSq = 64.0;
            }
        } else {
            float fMin = (float)this.host.getStateMinor(10) + this.host2.field_70130_N * 0.75f;
            float fMax = (float)this.host.getStateMinor(11) + this.host2.field_70130_N * 0.75f;
            if (this.host.getStateFlag(23)) {
                fMax = (float)((double)fMax + 5.0);
            }
            this.minDistSq = fMin * fMin;
            this.maxDistSq = fMax * fMax;
            this.pos[0] = this.owner.field_70165_t;
            this.pos[1] = this.owner.field_70163_u;
            this.pos[2] = this.owner.field_70161_v;
        }
        this.distX = this.pos[0] - this.host2.field_70165_t;
        this.distY = this.pos[1] - this.host2.field_70163_u;
        this.distZ = this.pos[2] - this.host2.field_70161_v;
        this.distSq = this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ;
    }
}

