/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai;

import com.lulan.shincolle.entity.BasicEntityAirplane;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.utility.BlockHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAIShipAircraftAttack
extends EntityAIBase {
    private Random rand = new Random();
    private BasicEntityAirplane host;
    private Entity target;
    private int atkDelay = 0;
    private int maxDelay = 0;
    private float attackRange = 4.0f;
    private float rangeSq;
    private double[] randPos = new double[3];
    private double distSq;
    private double distX;
    private double distY;
    private double distZ;
    private double motX;
    private double motY;
    private double motZ;
    private double distRanSqrt;
    private double distRanX;
    private double distRanY;
    private double distRanZ;
    private double ranX;
    private double ranY;
    private double ranZ;

    public EntityAIShipAircraftAttack(BasicEntityAirplane host) {
        if (!(host instanceof BasicEntityAirplane)) {
            throw new IllegalArgumentException("AircraftAttack AI requires BasicEntityAirplane");
        }
        this.host = host;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        Entity target = this.host.getEntityTarget();
        if (!this.host.canFindTarget()) {
            return false;
        }
        if (this.host.field_70173_aa > 20 && target != null && target.func_70089_S() && (this.host.useAmmoLight() && this.host.hasAmmoLight() || this.host.useAmmoHeavy() && this.host.hasAmmoHeavy())) {
            this.target = target;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.maxDelay = (int)((float)ConfigHandler.baseAttackSpeed[4] / this.host.getAttackSpeed()) + ConfigHandler.fixedAttackDelay[4];
        this.attackRange = 7.5f;
        this.rangeSq = this.attackRange * this.attackRange;
        this.motZ = 0.0;
        this.motY = 0.0;
        this.motX = 0.0;
        this.distZ = 0.0;
        this.distY = 0.0;
        this.distX = 0.0;
        this.distSq = 0.0;
        this.randPos[0] = this.target.field_70165_t;
        this.randPos[1] = this.target.field_70165_t;
        this.randPos[2] = this.target.field_70165_t;
    }

    public boolean func_75253_b() {
        if (!this.host.canFindTarget()) {
            return false;
        }
        return this.func_75250_a() || this.target != null && this.target.func_70089_S() && !this.host.getShipNavigate().noPath();
    }

    public void func_75251_c() {
        this.target = null;
        this.randPos = BlockHelper.findRandomPosition((Entity)this.host, (Entity)this.host, 4.0, 2.0, 2);
        this.host.getShipNavigate().tryMoveToXYZ(this.randPos[0], this.randPos[1], this.randPos[2], 1.0);
    }

    public void func_75246_d() {
        boolean onSight = false;
        if (this.target != null) {
            onSight = this.host.func_70635_at().func_75522_a(this.target);
            this.distX = this.target.field_70165_t - this.host.field_70165_t;
            this.distY = this.target.field_70163_u + 2.0 - this.host.field_70163_u;
            this.distZ = this.target.field_70161_v - this.host.field_70161_v;
            this.distSq = this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ;
            if (this.host.field_70173_aa % 16 == 0) {
                this.randPos = BlockHelper.findRandomPosition((Entity)this.host, this.target, 3.0, 3.0, 1);
                if (this.distSq > (double)this.rangeSq) {
                    this.host.getShipNavigate().tryMoveToXYZ(this.randPos[0], this.randPos[1], this.randPos[2], 1.0);
                } else {
                    this.host.getShipNavigate().tryMoveToXYZ(this.randPos[0], this.randPos[1], this.randPos[2], 0.4);
                }
            }
            --this.atkDelay;
            onSight = this.host.func_70635_at().func_75522_a(this.target);
            if (this.atkDelay <= 0 && onSight) {
                if (this.distSq < (double)this.rangeSq && this.host.hasAmmoLight() && this.host.useAmmoLight()) {
                    this.host.attackEntityWithAmmo(this.target);
                    this.atkDelay = this.maxDelay;
                }
                if (this.distSq < (double)this.rangeSq && this.host.hasAmmoHeavy() && this.host.useAmmoHeavy()) {
                    this.host.attackEntityWithHeavyAmmo(this.target);
                    this.atkDelay = this.maxDelay;
                }
            }
        }
    }
}

