/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle;

import com.lulan.shincolle.handler.ChunkLoaderHandler;
import com.lulan.shincolle.handler.CommandHandler;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.handler.GuiHandler;
import com.lulan.shincolle.init.ModBlocks;
import com.lulan.shincolle.init.ModEntity;
import com.lulan.shincolle.init.ModEvents;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.init.ModOres;
import com.lulan.shincolle.init.ModRecipes;
import com.lulan.shincolle.init.ModTileEntity;
import com.lulan.shincolle.init.ModWorldGen;
import com.lulan.shincolle.intermod.forestry.ShinBees;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.proxy.IProxy;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraftforge.common.ForgeChunkManager;

@Mod(modid="shincolle", name="Shinkeiseikan Collection", version="1.7.10.rv26.2", dependencies="required-after:Forge@[10.13.4.1614,)")
public class ShinColle {
    @Mod.Instance(value="shincolle")
    public static ShinColle instance;
    @SidedProxy(clientSide="com.lulan.shincolle.proxy.ClientProxy", serverSide="com.lulan.shincolle.proxy.ServerProxy")
    public static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        ModItems.init();
        ModBlocks.init();
        ModEntity.init();
        proxy.registerRender();
        proxy.registerChannel();
        LogHelper.info("DEBUG : preInit complete.");
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ModOres.oreDictRegister();
        ModEvents.init();
        ModRecipes.init();
        ModTileEntity.init();
        LogHelper.info("DEBUG : Init complete.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModWorldGen.init();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new ChunkLoaderHandler());
        if (Loader.isModLoaded((String)"Forestry") && ConfigHandler.enableForestry) {
            ShinBees.init();
        }
        LogHelper.info("DEBUG : postInit complete.");
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        LogHelper.info("DEBUG : server starting event: is MP server? " + event.getSide().isServer());
        CommandHandler.init(event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerAboutToStartEvent event) {
        LogHelper.info("DEBUG : server about to start: is MP server? " + event.getSide().isServer());
        ServerProxy.initServerFile = false;
        CommonProxy.isMultiplayer = event.getSide().isServer();
    }
}

