/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.ironchain.integration;

import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class IntegrationBC {
    public static ArrayList<ForgeDirection> getPipeConected(World world, int X, int Y, int Z, ForgeDirection from) {
        ArrayList<ForgeDirection> possiblePipe = new ArrayList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (from != ForgeDirection.UNKNOWN && from != dir.getOpposite()) continue;
            Position pos = new Position((double)X, (double)Y, (double)Z, dir);
            pos.moveForwards(1.0);
            TileEntity pipeTile = world.func_147438_o((int)pos.x, (int)pos.y, (int)pos.z);
            if (!(pipeTile instanceof IPipeTile)) continue;
            IPipeTile pipe = (IPipeTile)pipeTile;
            if (from != ForgeDirection.UNKNOWN && pipeTile instanceof IPipeConnection) {
                if (((IPipeConnection)pipeTile).overridePipeConnection(IPipeTile.PipeType.ITEM, dir) == IPipeConnection.ConnectOverride.DISCONNECT) continue;
                possiblePipe.add(dir);
                continue;
            }
            if (pipe.getPipeType() != IPipeTile.PipeType.ITEM || !pipe.isPipeConnected(dir.getOpposite())) continue;
            possiblePipe.add(dir);
        }
        return possiblePipe;
    }

    public static boolean dropIntoPipe(TileEntity tile, ArrayList<ForgeDirection> pipes, ItemStack itemstack) {
        if (itemstack != null && itemstack.field_77994_a > 0 && pipes.size() > 0) {
            int choice = tile.func_145831_w().field_73012_v.nextInt(pipes.size());
            Position itemPos = new Position((double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, pipes.get(choice));
            itemPos.x += 0.5;
            itemPos.y += 0.25;
            itemPos.z += 0.5;
            itemPos.moveForwards(0.5);
            Position pipePos = new Position((double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, pipes.get(choice));
            pipePos.moveForwards(1.0);
            IPipeTile pipe = (IPipeTile)tile.func_145831_w().func_147438_o((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
            ItemStack drop = itemstack.func_77946_l();
            if (pipe == null) {
                return false;
            }
            if (pipe.injectItem(drop, true, pipePos.orientation.getOpposite()) > 0) {
                return true;
            }
            pipes.remove(choice);
            return false;
        }
        return false;
    }
}

