/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.ironchain.block.tileentity;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import defeatedcrow.ironchain.DCsIronChain;
import defeatedcrow.ironchain.IronChainLog;
import defeatedcrow.ironchain.block.BlockRHopper;
import defeatedcrow.ironchain.block.tileentity.IReversalHopper;
import defeatedcrow.ironchain.integration.IntegrationBC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.transport.IPipeConnection", modid="BuildCraft|Core")})
public class TileEntityRHopper
extends TileEntity
implements IHopper,
IReversalHopper,
IPipeConnection {
    protected int transferCooldown = -1;
    public ItemStack[] hopperItems = new ItemStack[this.getHopperSize()];

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.hopperItems = new ItemStack[this.func_70302_i_()];
        this.transferCooldown = par1NBTTagCompound.func_74762_e("TransferCooldown");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.hopperItems.length) continue;
            this.hopperItems[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.hopperItems.length; ++i) {
            if (this.hopperItems[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.hopperItems[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        par1NBTTagCompound.func_74768_a("TransferCooldown", this.transferCooldown);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void setTransferCooldown(int par1) {
        this.transferCooldown = par1;
    }

    public boolean isCoolingDown() {
        return this.transferCooldown > 0;
    }

    public void setItems(ItemStack[] _items) {
        if (_items != null) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.hopperItems[i] = _items[i] != null ? _items[i].func_77946_l() : null;
            }
        }
    }

    public ItemStack[] getItems() {
        return this.hopperItems;
    }

    public int getCoolTime() {
        return this.transferCooldown;
    }

    public void func_145845_h() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            if (!this.isCoolingDown()) {
                this.setTransferCooldown(0);
                this.updateHopper();
            }
        }
    }

    public boolean updateHopper() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isCoolingDown() && BlockRHopper.getIsBlockNotPoweredFromMetadata(this.func_145832_p())) {
                boolean flag = TileEntityRHopper.suckItemsIntoHopper(this);
                boolean bl = flag = this.insertItemToInventory() || flag;
                if (flag) {
                    this.setTransferCooldown(4);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean insertItemToInventory() {
        IInventory iinventory;
        boolean tryInsert = false;
        if (DCsIronChain.getLoadBC) {
            ArrayList<ForgeDirection> dir;
            ForgeDirection from = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
            if (this.isReversal() && from == ForgeDirection.UP) {
                from = ForgeDirection.DOWN;
            }
            if (!this.isReversal() && from == ForgeDirection.DOWN) {
                from = ForgeDirection.UP;
            }
            if ((dir = IntegrationBC.getPipeConected(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, from)).size() > 0) {
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    if (this.func_70301_a(i) == null) continue;
                    ItemStack current = this.func_70301_a(i);
                    IronChainLog.debugTrace("Current size: " + current.field_77994_a);
                    ItemStack[] itemstack = this.extractItem(true, from, this.getExtractLimitSize());
                    for (int l = 0; l < itemstack.length; ++l) {
                        IronChainLog.debugTrace("Extracted Item: " + itemstack[l].field_77994_a + " : " + itemstack[l].func_82833_r());
                        if (!IntegrationBC.dropIntoPipe(this, dir, itemstack[l])) continue;
                        IronChainLog.debugTrace("Current size after: " + current.field_77994_a);
                        tryInsert = true;
                        break;
                    }
                    this.func_70296_d();
                    return true;
                }
            }
        }
        if ((iinventory = this.getOutputInventory()) == null || tryInsert) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            int side = ForgeDirection.OPPOSITES[BlockRHopper.getDirectionFromMetadata(this.func_145832_p())];
            int extract = TileEntityRHopper.canInsertSize(iinventory, itemstack, this.getExtractLimitSize(), 1);
            if (extract <= 0) continue;
            ItemStack insert = this.func_70298_a(i, extract);
            TileEntityRHopper.insertStack(iinventory, insert, 1);
            iinventory.func_70296_d();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public static boolean suckItemsIntoHopper(IHopper par0Hopper) {
        IInventory iinventory = TileEntityRHopper.getInventoryAboveHopper(par0Hopper);
        TileEntityRHopper rhopper = null;
        if (par0Hopper instanceof TileEntityRHopper) {
            rhopper = (TileEntityRHopper)par0Hopper;
        }
        if (iinventory != null) {
            int b0 = 0;
            if (iinventory instanceof ISidedInventory) {
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                int[] aint = isidedinventory.func_94128_d(b0);
                for (int i = 0; i < aint.length; ++i) {
                    if (!TileEntityRHopper.insertStackFromInventory(par0Hopper, iinventory, aint[i], b0)) continue;
                    return true;
                }
            } else {
                int j = iinventory.func_70302_i_();
                for (int k = 0; k < j; ++k) {
                    if (!TileEntityRHopper.insertStackFromInventory(par0Hopper, iinventory, k, b0)) continue;
                    return true;
                }
            }
        } else {
            EntityItem entityitem = TileEntityRHopper.getEntityAbove(par0Hopper.func_145831_w(), par0Hopper, par0Hopper.func_96107_aA(), par0Hopper.func_96109_aB(), par0Hopper.func_96108_aC());
            if (entityitem != null) {
                return TileEntityRHopper.insertStackFromEntity((IInventory)par0Hopper, entityitem);
            }
        }
        return false;
    }

    protected static boolean insertStackFromInventory(IHopper par0Hopper, IInventory par1IInventory, int par2, int par3) {
        ItemStack itemstack = par1IInventory.func_70301_a(par2);
        int extract = 1;
        if (itemstack != null && par0Hopper instanceof TileEntityRHopper) {
            TileEntityRHopper cfr_ignored_0 = (TileEntityRHopper)par0Hopper;
            extract = TileEntityRHopper.canInsertSize((IInventory)par0Hopper, itemstack, ((TileEntityRHopper)par0Hopper).getExtractLimitSize(), par3);
        }
        if (itemstack != null && TileEntityRHopper.canExtractItemFromInventory(par1IInventory, itemstack, par2, par3)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = TileEntityRHopper.insertStack((IInventory)par0Hopper, par1IInventory.func_70298_a(par2, extract), -1);
            if (itemstack2 == null || itemstack2.field_77994_a <= 0) {
                par1IInventory.func_70296_d();
                par0Hopper.func_70296_d();
                return true;
            }
            par1IInventory.func_70299_a(par2, itemstack1);
        }
        return false;
    }

    public static boolean insertStackFromEntity(IInventory par0IInventory, EntityItem par1EntityItem) {
        boolean flag = false;
        if (par1EntityItem == null) {
            return false;
        }
        ItemStack itemstack = par1EntityItem.func_92059_d().func_77946_l();
        ItemStack itemstack1 = TileEntityRHopper.insertStack(par0IInventory, itemstack, -1);
        if (itemstack1 != null && itemstack1.field_77994_a != 0) {
            par1EntityItem.func_92058_a(itemstack1);
        } else {
            flag = true;
            par1EntityItem.func_70106_y();
        }
        return flag;
    }

    public static ItemStack insertStack(IInventory par0IInventory, ItemStack par1ItemStack, int side) {
        if (par0IInventory instanceof ISidedInventory && side > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)par0IInventory;
            int[] aint = isidedinventory.func_94128_d(side);
            for (int j = 0; j < aint.length && par1ItemStack != null && par1ItemStack.field_77994_a > 0; ++j) {
                par1ItemStack = TileEntityRHopper.insertItemstack(par0IInventory, par1ItemStack, aint[j], side);
            }
        } else {
            int k = par0IInventory.func_70302_i_();
            for (int l = 0; l < k && par1ItemStack != null && par1ItemStack.field_77994_a > 0; ++l) {
                par1ItemStack = TileEntityRHopper.insertItemstack(par0IInventory, par1ItemStack, l, side);
            }
        }
        if (par1ItemStack != null && par1ItemStack.field_77994_a == 0) {
            par1ItemStack = null;
        }
        return par1ItemStack;
    }

    public static int canInsertSize(IInventory inv, ItemStack item, int maxCount, int side) {
        if (inv == null || item == null) {
            return 0;
        }
        int ret = Math.min(maxCount, item.field_77994_a);
        int check = 0;
        if (inv instanceof ISidedInventory && side > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)inv;
            int[] aint = isidedinventory.func_94128_d(side);
            for (int j = 0; j < aint.length; ++j) {
                ItemStack checkItem = isidedinventory.func_70301_a(j);
                if (!TileEntityRHopper.canInsertItemToInventory(inv, checkItem, j, side)) continue;
                if (checkItem == null) {
                    check = isidedinventory.func_70297_j_();
                } else if (!TileEntityRHopper.areItemStacksEqualItem(item, checkItem) || (check = isidedinventory.func_70297_j_() - checkItem.field_77994_a) <= 0) {
                    continue;
                }
                break;
            }
        } else {
            int k = inv.func_70302_i_();
            for (int l = 0; l < k; ++l) {
                ItemStack checkItem = inv.func_70301_a(l);
                if (!TileEntityRHopper.canInsertItemToInventory(inv, checkItem, l, side)) continue;
                if (checkItem == null) {
                    check = inv.func_70297_j_();
                } else if (!TileEntityRHopper.areItemStacksEqualItem(item, checkItem) || (check = inv.func_70297_j_() - checkItem.field_77994_a) <= 0) {
                    continue;
                }
                break;
            }
        }
        ret = Math.min(ret, check);
        return ret;
    }

    protected static boolean canInsertItemToInventory(IInventory par0IInventory, ItemStack par1ItemStack, int par2, int par3) {
        return !par0IInventory.func_94041_b(par2, par1ItemStack) ? false : !(par0IInventory instanceof ISidedInventory) || ((ISidedInventory)par0IInventory).func_102007_a(par2, par1ItemStack, par3);
    }

    protected static boolean canExtractItemFromInventory(IInventory par0IInventory, ItemStack par1ItemStack, int par2, int par3) {
        if (par0IInventory instanceof ISidedInventory) {
            return ((ISidedInventory)par0IInventory).func_102008_b(par2, par1ItemStack, par3);
        }
        if (par0IInventory instanceof TileEntityRHopper) {
            return false;
        }
        return !(par0IInventory instanceof TileEntityHopper);
    }

    private static ItemStack insertItemstack(IInventory par0IInventory, ItemStack par1ItemStack, int par2, int par3) {
        ItemStack itemstack1 = par0IInventory.func_70301_a(par2);
        if (TileEntityRHopper.canInsertItemToInventory(par0IInventory, par1ItemStack, par2, par3)) {
            boolean flag = false;
            if (itemstack1 == null) {
                par0IInventory.func_70299_a(par2, par1ItemStack);
                par1ItemStack = null;
                flag = true;
            } else if (TileEntityRHopper.areItemStacksEqualItem(itemstack1, par1ItemStack)) {
                int k = par1ItemStack.func_77976_d() - itemstack1.field_77994_a;
                int l = Math.min(par1ItemStack.field_77994_a, k);
                par1ItemStack.field_77994_a -= l;
                itemstack1.field_77994_a += l;
                boolean bl = flag = l > 0;
            }
            if (flag) {
                if (par0IInventory instanceof TileEntityRHopper) {
                    ((TileEntityRHopper)par0IInventory).setTransferCooldown(4);
                    par0IInventory.func_70296_d();
                }
                par0IInventory.func_70296_d();
            }
        }
        return par1ItemStack;
    }

    protected IInventory getOutputInventory() {
        int i = BlockRHopper.getDirectionFromMetadata(this.func_145832_p());
        IInventory iinventory = TileEntityRHopper.getInventoryAtLocation(this.func_145831_w(), this.field_145851_c + Facing.field_71586_b[i], this.field_145848_d + Facing.field_71587_c[i], this.field_145849_e + Facing.field_71585_d[i]);
        return iinventory;
    }

    public static IInventory getInventoryAboveHopper(IHopper par0Hopper) {
        double ajust = 1.0;
        if (par0Hopper instanceof TileEntityRHopper) {
            ajust = ((TileEntityRHopper)par0Hopper).isReversal() ? -1.0 : 1.0;
        }
        return TileEntityRHopper.getInventoryAtLocation(par0Hopper.func_145831_w(), par0Hopper.func_96107_aA(), par0Hopper.func_96109_aB() + ajust, par0Hopper.func_96108_aC());
    }

    public static EntityItem getEntityAbove(World par0World, IHopper hopper, double par1, double par3, double par5) {
        List list;
        double range = 1.0;
        int height = 1;
        AxisAlignedBB AABB = null;
        if (hopper instanceof TileEntityRHopper) {
            range = ((TileEntityRHopper)hopper).getSuctionRange();
            height = MathHelper.func_76123_f((float)((float)range + 1.0f));
            if (height < 1) {
                height = 1;
            }
            AABB = ((TileEntityRHopper)hopper).isReversal() ? AxisAlignedBB.func_72330_a((double)(par1 - range), (double)(par3 - (double)height), (double)(par5 - range), (double)(par1 + range + 1.0), (double)par3, (double)(par5 + range + 1.0)) : AxisAlignedBB.func_72330_a((double)(par1 - range), (double)(par3 + 1.0), (double)(par5 - range), (double)(par1 + range + 1.0), (double)(par3 + (double)height + 1.0), (double)(par5 + range + 1.0));
        }
        if (AABB != null) {
            // empty if block
        }
        return (list = par0World.func_82733_a(EntityItem.class, AABB, IEntitySelector.field_94557_a)).size() > 0 ? (EntityItem)list.get(0) : null;
    }

    public static IInventory getInventoryAtLocation(World par0World, double par1, double par3, double par5) {
        List list;
        Block block;
        int k;
        int j;
        IInventory iinventory = null;
        int i = MathHelper.func_76128_c((double)par1);
        TileEntity tileentity = par0World.func_147438_o(i, j = MathHelper.func_76128_c((double)par3), k = MathHelper.func_76128_c((double)par5));
        if (tileentity != null && tileentity instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof TileEntityChest && (block = par0World.func_147439_a(i, j, k)) instanceof BlockChest) {
            iinventory = ((BlockChest)block).func_149951_m(par0World, i, j, k);
        }
        if (iinventory == null && (list = par0World.func_94576_a((Entity)null, AxisAlignedBB.func_72330_a((double)par1, (double)par3, (double)par5, (double)(par1 + 1.0), (double)(par3 - 2.0), (double)(par5 + 1.0)), IEntitySelector.field_96566_b)) != null && list.size() > 0) {
            iinventory = (IInventory)list.get(par0World.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    protected static boolean areItemStacksEqualItem(ItemStack stack, ItemStack target) {
        if (stack != null && target != null && stack.func_77973_b() != null && stack.func_77973_b() != null) {
            boolean n;
            boolean i = stack.func_77973_b() == target.func_77973_b();
            boolean m = stack.func_77960_j() == target.func_77960_j();
            boolean bl = n = !stack.func_77942_o() && !target.func_77942_o();
            if (stack.func_77942_o() && target.func_77942_o() && stack.field_77990_d.equals((Object)target.field_77990_d)) {
                n = true;
            }
            return i && m && n;
        }
        return stack == null && target == null;
    }

    public int func_70302_i_() {
        return this.hopperItems.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.func_70302_i_()) {
            return this.hopperItems[i];
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.hopperItems[i] != null) {
            if (this.hopperItems[i].field_77994_a <= j) {
                ItemStack itemstack = this.hopperItems[i].func_77946_l();
                this.hopperItems[i].field_77994_a = 0;
                this.hopperItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.hopperItems[i].func_77979_a(j);
            if (this.hopperItems[i].field_77994_a == 0) {
                this.hopperItems[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.hopperItems[i] != null) {
            ItemStack itemstack = this.hopperItems[i];
            this.hopperItems[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i < 5) {
            this.hopperItems[i] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_145825_b() {
        return "Reversal Hopper";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public double func_96107_aA() {
        return this.field_145851_c;
    }

    public double func_96109_aB() {
        return this.field_145848_d;
    }

    public double func_96108_aC() {
        return this.field_145849_e;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxCount) {
        TileEntityRHopper inv = this;
        ItemStack extract = null;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            ItemStack stack = inv.func_70301_a(i);
            int count = Math.min(maxCount, stack.field_77994_a);
            if (doRemove) {
                extract = inv.func_70298_a(i, count);
                break;
            }
            extract = stack.func_77946_l();
            break;
        }
        if (extract != null) {
            return new ItemStack[]{extract};
        }
        return null;
    }

    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        boolean sameDir;
        int l = this.func_70302_i_();
        int removeItemstack = 0;
        boolean bl = sameDir = from == ForgeDirection.getOrientation((int)this.func_145832_p());
        if (!sameDir) {
            for (int i = 0; i < 5 && stack != null && stack.field_77994_a > 0; ++i) {
                ItemStack current = this.func_70301_a(i);
                if (!this.func_94041_b(i, stack)) continue;
                boolean flag = false;
                if (current == null || current.field_77994_a <= 0) {
                    this.func_70299_a(i, stack.func_77946_l());
                    removeItemstack = stack.field_77994_a;
                    stack.field_77994_a = 0;
                    stack = null;
                    flag = true;
                } else if (TileEntityRHopper.areItemStacksEqualItem(current, stack)) {
                    int k = stack.func_77976_d() - current.field_77994_a;
                    int j = Math.min(stack.field_77994_a, k);
                    stack.field_77994_a -= j;
                    current.field_77994_a += j;
                    removeItemstack = j;
                    boolean bl2 = flag = j > 0;
                }
                if (!flag) continue;
                this.func_70296_d();
            }
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
            return 0;
        }
        return removeItemstack;
    }

    @Override
    public int getHopperSize() {
        return 5;
    }

    @Override
    public int getExtractLimitSize() {
        return 1;
    }

    @Override
    public int getSuctionRange() {
        return 1;
    }

    @Override
    public boolean isReversal() {
        return true;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.ITEM) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }
}

