/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.ironchain.block;

import net.minecraftforge.common.util.ForgeDirection;

public enum PlaneDir {
    NORTH(0, -1),
    SOUTH(0, 1),
    WEST(-1, 0),
    EAST(1, 0),
    UNKNOWN(0, 0);

    public final int offsetX;
    public final int offsetZ;
    public final int flag;
    public static final PlaneDir[] DIRECTIONS;
    public static final ForgeDirection[] FORGE_DIRECTIONS;
    public static final int[] OPPOSITES;

    private PlaneDir(int x, int z) {
        this.offsetX = x;
        this.offsetZ = z;
        this.flag = 1 << this.ordinal();
    }

    public static PlaneDir getDir(int id) {
        if (id >= 0 && id < DIRECTIONS.length) {
            return DIRECTIONS[id];
        }
        return UNKNOWN;
    }

    public static ForgeDirection getForgeDir(int id) {
        if (id >= 0 && id < DIRECTIONS.length) {
            return FORGE_DIRECTIONS[id];
        }
        return ForgeDirection.UNKNOWN;
    }

    public PlaneDir getOpposite() {
        return PlaneDir.getDir(OPPOSITES[this.ordinal()]);
    }

    public static PlaneDir getPlayerDir(int i) {
        int r = i & 3;
        return NORTH;
    }

    static {
        DIRECTIONS = new PlaneDir[]{NORTH, SOUTH, WEST, EAST};
        FORGE_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
        OPPOSITES = new int[]{1, 0, 3, 2};
    }
}

