/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import java.lang.reflect.Method;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import stanhebben.zenscript.compiler.EnvironmentClass;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.symbols.SymbolArgument;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ExpressionJavaLambda
extends Expression {
    private final Class interfaceClass;
    private final List<ParsedFunctionArgument> arguments;
    private final List<Statement> statements;
    private final ZenType type;

    public ExpressionJavaLambda(ZenPosition position, Class interfaceClass, List<ParsedFunctionArgument> arguments, List<Statement> statements, ZenType type) {
        super(position);
        this.interfaceClass = interfaceClass;
        this.arguments = arguments;
        this.statements = statements;
        this.type = type;
    }

    @Override
    public ZenType getType() {
        return this.type;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        if (!result) {
            return;
        }
        Method method = this.interfaceClass.getMethods()[0];
        String clsName = environment.makeClassName();
        ClassWriter cw = new ClassWriter(2);
        cw.visit(50, 1, clsName, null, "java/lang/Object", new String[]{ZenTypeUtil.internal(this.interfaceClass)});
        MethodOutput constructor = new MethodOutput((ClassVisitor)cw, 1, "<init>", "()V", null, null);
        constructor.start();
        constructor.loadObject(0);
        constructor.invokeSpecial("java/lang/Object", "<init>", "()V");
        constructor.ret();
        constructor.end();
        MethodOutput output = new MethodOutput((ClassVisitor)cw, 1, method.getName(), ZenTypeUtil.descriptor(method), null, null);
        EnvironmentClass environmentClass = new EnvironmentClass((ClassVisitor)cw, environment);
        EnvironmentMethod environmentMethod = new EnvironmentMethod(output, environmentClass);
        for (int i = 0; i < this.arguments.size(); ++i) {
            environmentMethod.putValue(this.arguments.get(i).getName(), new SymbolArgument(i + 1, environment.getType(method.getGenericParameterTypes()[i])), this.getPosition());
        }
        output.start();
        for (Statement statement : this.statements) {
            statement.compile(environmentMethod);
        }
        output.end();
        environment.putClass(clsName, cw.toByteArray());
        environment.getOutput().newObject(clsName);
        environment.getOutput().dup();
        environment.getOutput().construct(clsName, new String[0]);
    }
}

