/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.mc1710.util.MineTweakerPlatformUtils;
import net.minecraft.entity.EntityLivingBase;
import powercrystals.minefactoryreloaded.MFRRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.SafariNet")
@ModOnly(value={"MineFactoryReloaded"})
public class SafariNet {
    @ZenMethod
    public static void addBlacklist(String entityClassName) {
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        MineTweakerAPI.apply(new AddBlacklistAction(entityClass));
    }

    @ZenMethod
    public static void removeBlacklist(String entityClassName) {
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        if (!MFRRegistry.getSafariNetBlacklist().contains(entityClass)) {
            MineTweakerAPI.logWarning(entityClassName + " is not in the safari net blacklist");
        } else {
            MineTweakerAPI.apply(new RemoveBlacklistAction(entityClass));
        }
    }

    private static class RemoveBlacklistAction
    implements IUndoableAction {
        private final Class<? extends EntityLivingBase> entityClass;

        public RemoveBlacklistAction(Class<? extends EntityLivingBase> entityClass) {
            this.entityClass = entityClass;
        }

        @Override
        public void apply() {
            MFRRegistry.getSafariNetBlacklist().remove(this.entityClass);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getSafariNetBlacklist().add(this.entityClass);
        }

        @Override
        public String describe() {
            return "Removing " + this.entityClass.getName() + " from the safari net blacklist";
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.entityClass.getName() + " to the safari net blacklist";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddBlacklistAction
    implements IUndoableAction {
        private final Class<? extends EntityLivingBase> entityClass;

        public AddBlacklistAction(Class<? extends EntityLivingBase> entityClass) {
            this.entityClass = entityClass;
        }

        @Override
        public void apply() {
            MFRRegistry.registerSafariNetBlacklist(this.entityClass);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getSafariNetBlacklist().remove(this.entityClass);
        }

        @Override
        public String describe() {
            return "Blacklisting " + this.entityClass.getName() + " in the safari net";
        }

        @Override
        public String describeUndo() {
            return "Removing " + this.entityClass.getName() + " from the safari net blacklist";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

