/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import java.util.Random;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.mfr.FertilizableType;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.Fertilizer")
@ModOnly(value={"MineFactoryReloaded"})
public class Fertilizer {
    @ZenMethod
    public static void addFertilizable(IItemStack block, String fertilizeType, @Optional String method, @Optional IItemStack replacement) {
        FertilizerType fertilizer;
        if (fertilizeType.equals("any")) {
            fertilizer = null;
        } else if (fertilizeType.equals("normal")) {
            fertilizer = FertilizerType.GrowPlant;
        } else if (fertilizeType.equals("grass")) {
            fertilizer = FertilizerType.Grass;
        } else if (fertilizeType.equals("magic")) {
            fertilizer = FertilizerType.GrowMagicalCrop;
        } else {
            throw new IllegalArgumentException("Unknown fertilizer type: " + fertilizeType);
        }
        FertilizableType type = FertilizableType.BONEMEAL;
        if (method == null || method.equals("bonemeal")) {
            type = FertilizableType.BONEMEAL;
        } else if (method.equals("replace")) {
            type = FertilizableType.REPLACE;
            if (replacement == null) {
                throw new IllegalArgumentException("replace method requires a replacement block");
            }
        } else {
            throw new IllegalArgumentException("Unknown fertilization method: " + method);
        }
        MineTweakerAPI.apply(new FertilizerAddFertilizableAction(block, replacement, fertilizer, type));
    }

    @ZenMethod
    public static void removeFertilizable(IItemStack item) {
        MineTweakerAPI.apply(new FertilizerRemoveFertilizableAction(item));
    }

    @ZenMethod
    public static void addFertilizer(IItemStack item, String type) {
        FertilizerType fertilizerType;
        if (type.equals("grass")) {
            fertilizerType = FertilizerType.Grass;
        } else if (type.equals("normal")) {
            fertilizerType = FertilizerType.GrowPlant;
        } else if (type.equals("magic")) {
            fertilizerType = FertilizerType.GrowMagicalCrop;
        } else {
            throw new IllegalArgumentException("Unknown fertilizer type: " + type);
        }
        MineTweakerAPI.apply(new FertilizerAddFertilizerAction(item, fertilizerType));
    }

    @ZenMethod
    public static void removeFertilizer(IItemStack item) {
        MineTweakerAPI.apply(new FertilizerRemoveFertilizerAction(item));
    }

    private static class SimpleFertilizer
    implements IFactoryFertilizer {
        private final ItemStack item;
        private final FertilizerType type;

        public SimpleFertilizer(ItemStack item, FertilizerType type) {
            this.item = item;
            this.type = type;
        }

        public Item getFertilizer() {
            return this.item.func_77973_b();
        }

        public FertilizerType getFertilizerType(ItemStack is) {
            return this.type;
        }

        public void consume(ItemStack fertilizer) {
            --fertilizer.field_77994_a;
        }
    }

    private static class SimpleFertilizable
    implements IFactoryFertilizable {
        private final IItemStack block;
        private final IItemStack plant;
        private final FertilizerType type;

        public SimpleFertilizable(IItemStack block, IItemStack plant, FertilizerType type) {
            this.block = block;
            this.plant = plant;
            this.type = type;
        }

        public Block getPlant() {
            return MineTweakerMC.getBlock(this.block);
        }

        public boolean canFertilize(World world, int x, int y, int z, FertilizerType fertilizerType) {
            if (this.type != null && this.type != fertilizerType) {
                return false;
            }
            IItemStack blockAt = MineTweakerMC.getIItemStack(new ItemStack(world.func_147439_a(x, y, z), 1, world.func_72805_g(x, y, z)));
            return this.block.matches(blockAt);
        }

        public boolean fertilize(World world, Random rand, int x, int y, int z, FertilizerType fertilizerType) {
            if (this.plant == null) {
                return ItemDye.applyBonemeal((ItemStack)new ItemStack((Item)Item.field_150901_e.func_82594_a("minecraft:dyePowder"), 1, 15), (World)world, (int)x, (int)y, (int)z, null);
            }
            ItemStack istack = MineTweakerMC.getItemStack(this.plant);
            world.func_147465_d(x, y, z, Block.func_149634_a((Item)istack.func_77973_b()), this.plant.getDamage(), 0);
            return true;
        }
    }

    public static class FertilizerRemoveFertilizerAction
    implements IUndoableAction {
        private final IItemStack item;
        private final IFactoryFertilizer old;

        public FertilizerRemoveFertilizerAction(IItemStack item) {
            this.item = item;
            this.old = (IFactoryFertilizer)MFRRegistry.getFertilizers().get(MineTweakerMC.getItemStack(item).func_77973_b());
        }

        @Override
        public void apply() {
            MFRRegistry.getFertilizers().remove(MineTweakerMC.getItemStack(this.item).func_77973_b());
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.registerFertilizer((IFactoryFertilizer)this.old);
        }

        @Override
        public String describe() {
            return "Removing fertilizer " + this.item.getDisplayName();
        }

        @Override
        public String describeUndo() {
            return "Restoring fertilizer " + this.item.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class FertilizerRemoveFertilizableAction
    implements IUndoableAction {
        private final IItemStack item;
        private final IFactoryFertilizable old;

        public FertilizerRemoveFertilizableAction(IItemStack item) {
            this.item = item;
            this.old = (IFactoryFertilizable)MFRRegistry.getFertilizables().get(MineTweakerMC.getBlock(item));
        }

        @Override
        public void apply() {
            MFRRegistry.getFertilizables().remove(MineTweakerMC.getBlock(this.item));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.registerFertilizable((IFactoryFertilizable)this.old);
        }

        @Override
        public String describe() {
            return "Removing fertilizable " + this.item.getDisplayName();
        }

        @Override
        public String describeUndo() {
            return "Restoring fertilizable " + this.item.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class FertilizerAddFertilizerAction
    implements IUndoableAction {
        private final IItemStack item;
        private final FertilizerType type;
        private final IFactoryFertilizer old;

        public FertilizerAddFertilizerAction(IItemStack item, FertilizerType type) {
            this.item = item;
            this.type = type;
            this.old = (IFactoryFertilizer)MFRRegistry.getFertilizers().get(MineTweakerMC.getItemStack(item).func_77973_b());
        }

        @Override
        public void apply() {
            MFRRegistry.registerFertilizer((IFactoryFertilizer)new SimpleFertilizer(MineTweakerMC.getItemStack(this.item), this.type));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (this.old == null) {
                MFRRegistry.getFertilizers().remove(MineTweakerMC.getItemStack(this.item).func_77973_b());
            } else {
                MFRRegistry.registerFertilizer((IFactoryFertilizer)this.old);
            }
        }

        @Override
        public String describe() {
            return "Adding fertilizer " + this.item.getDisplayName();
        }

        @Override
        public String describeUndo() {
            if (this.old == null) {
                return "Removing fertilizer " + this.item.getDisplayName();
            }
            return "Restoring fertilizer " + this.item.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class FertilizerAddFertilizableAction
    implements IUndoableAction {
        private final IItemStack block;
        private final IItemStack plant;
        private final FertilizerType type;
        private final FertilizableType method;
        private final IFactoryFertilizable old;

        public FertilizerAddFertilizableAction(IItemStack block, IItemStack plant, FertilizerType type, FertilizableType method) {
            this.block = block;
            this.plant = plant;
            this.type = type;
            this.method = method;
            this.old = (IFactoryFertilizable)MFRRegistry.getFertilizables().get(MineTweakerMC.getBlock(block));
        }

        @Override
        public void apply() {
            MFRRegistry.registerFertilizable((IFactoryFertilizable)new SimpleFertilizable(this.block, this.plant, this.type));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (this.old == null) {
                MFRRegistry.getFertilizables().remove(MineTweakerMC.getBlock(this.block));
            } else {
                MFRRegistry.registerFertilizable((IFactoryFertilizable)this.old);
            }
        }

        @Override
        public String describe() {
            return "Making " + this.block.getDisplayName() + " fertilizable";
        }

        @Override
        public String describeUndo() {
            if (this.old == null) {
                return "Removing fertilizable " + this.block.getDisplayName();
            }
            return "Restoring fertilizable " + this.block.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

