/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.data;

import java.util.List;
import java.util.Map;
import minetweaker.api.data.IData;
import minetweaker.api.data.IDataConverter;
import minetweaker.api.data.IllegalDataException;

public class DataByte
implements IData {
    private final byte value;

    public DataByte(byte value) {
        this.value = value;
    }

    @Override
    public boolean asBool() {
        throw new IllegalDataException("Cannot cast a byte to a bool");
    }

    @Override
    public byte asByte() {
        return this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public String asString() {
        return Byte.toString(this.value);
    }

    @Override
    public List<IData> asList() {
        return null;
    }

    @Override
    public Map<String, IData> asMap() {
        return null;
    }

    @Override
    public byte[] asByteArray() {
        return null;
    }

    @Override
    public int[] asIntArray() {
        return null;
    }

    @Override
    public IData getAt(int i) {
        throw new UnsupportedOperationException("A byte is not indexable");
    }

    @Override
    public void setAt(int i, IData value) {
        throw new UnsupportedOperationException("A byte is not indexable");
    }

    @Override
    public IData memberGet(String name) {
        throw new UnsupportedOperationException("A byte is not indexable");
    }

    @Override
    public void memberSet(String name, IData data) {
        throw new UnsupportedOperationException("A byte is not indexable");
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public boolean contains(IData data) {
        return data.asByte() == this.value;
    }

    @Override
    public boolean equals(IData data) {
        return this.value == data.asByte();
    }

    @Override
    public int compareTo(IData data) {
        return Byte.compare(this.value, data.asByte());
    }

    @Override
    public IData immutable() {
        return this;
    }

    @Override
    public IData update(IData data) {
        return data;
    }

    @Override
    public <T> T convert(IDataConverter<T> converter) {
        return converter.fromByte(this.value);
    }

    @Override
    public IData add(IData other) {
        return new DataByte((byte)(this.value + other.asByte()));
    }

    @Override
    public IData sub(IData other) {
        return new DataByte((byte)(this.value - other.asByte()));
    }

    @Override
    public IData mul(IData other) {
        return new DataByte((byte)(this.value * other.asByte()));
    }

    @Override
    public IData div(IData other) {
        return new DataByte((byte)(this.value / other.asByte()));
    }

    @Override
    public IData mod(IData other) {
        return new DataByte((byte)(this.value % other.asByte()));
    }

    @Override
    public IData and(IData other) {
        return new DataByte((byte)(this.value & other.asByte()));
    }

    @Override
    public IData or(IData other) {
        return new DataByte((byte)(this.value | other.asByte()));
    }

    @Override
    public IData xor(IData other) {
        return new DataByte((byte)(this.value ^ other.asByte()));
    }

    @Override
    public IData neg() {
        return new DataByte(-this.value);
    }

    @Override
    public IData not() {
        return new DataByte(~this.value);
    }

    @Override
    public String toString() {
        return this.asString() + " as byte";
    }
}

