package thKaguyaMod.item;

import java.util.List;

import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thKaguyaMod.THKaguyaCore;
import thKaguyaMod.THKaguyaLib;
import thKaguyaMod.entity.spellcard.THSpellCard;
import thKaguyaMod.init.THKaguyaItems;
import thKaguyaMod.registry.SpellCardRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemTHSpellCard extends Item
{
	
	//スペルカード
	
	//@SideOnly(Side.CLIENT)
    private IIcon[] icon = new IIcon[1024];
	
	public ItemTHSpellCard()
	{
		super();
		this.setTextureName("thkaguyamod:spellCard/MusouFuuin");//テクスチャの指定
		//setHasSubtypes(true);
		//setMaxDamage(0);
		maxStackSize = 1;
		setCreativeTab(THKaguyaCore.tabSpellCard);//クリエイティブのスペルカードタブに登録
	}
	
	@Override
	public String getUnlocalizedName(ItemStack itemStack)
    {
		//int i = MathHelper.clamp_int(itemStack.getItemDamage(), 0, SpellCardRegistry.getNumberOfSpellCard());
    	return super.getUnlocalizedName() + "." + itemStack.getItemDamage();
    }
	
	//ダメージ値によってアイテムアイコンを変える
	@Override
	@SideOnly(Side.CLIENT)
    public IIcon getIconFromDamage(int damage)
    {

		return icon[damage];
    }
	
	//アイテムアイコンを登録する
	@Override
	@SideOnly(Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister)
    {

		THSpellCard spell;
		int spellcardID;
		int i = 0;
		for(String name : SpellCardRegistry.spellcardClass.keySet())
		{
			spellcardID = i;
			i++;
			//icon[(int)id] = iconRegister.registerIcon("thkaguyamod:spellCard/" + (int)id);
			try {
				spell = (THSpellCard)SpellCardRegistry.spellcardClass.get(name).newInstance();
				
				icon[SpellCardRegistry.getSpellCardNumber(name)] = iconRegister.registerIcon(SpellCardRegistry.getSpellCardModDomain(name) + ":spellCard/" + name);// + spell.getIconName());
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
			//icon[] = iconRegister.registerIcon("thkaguyamod:spellCard/" + "0");// + spell.getIconName());
		}

    }
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player)
    {	
		//スペルカードを宣言する
    	THKaguyaLib.checkSpellCardDeclaration(world, itemStack, player, itemStack.getItemDamage(), 2, true);
    	
    	return itemStack;
   	}
	
	//インベントリにある限り常時呼び出されるメソッド
	@Override
	public void onUpdate(ItemStack itemStack, World world, Entity entity, int i, boolean flag)
	{
		int miracleTime = 0;
		NBTTagCompound nbt = itemStack.getTagCompound();
		if(nbt != null)
		{
			miracleTime = nbt.getInteger("Charge");
			if(miracleTime > 1)
			{
				nbt.setInteger("Charge", miracleTime - 1);
			}
			else
			{
				nbt.removeTag("Charge");
			}
		}
	}
	
	 //アイテムの表示情報付加
    @Override
	public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean bool)
	{
		super.addInformation(itemStack, player, list, bool);
		
		int needLevel = 1;
		Class<?> spellcard;// = THSpellCard_0.class;
		THSpellCard useSpellCard;// = spellcard.newInstance();
		
		if((spellcard = SpellCardRegistry.getSpellCardClass(itemStack.getItemDamage())) != null)
		{
			try {
				useSpellCard = (THSpellCard)spellcard.newInstance();

				needLevel = useSpellCard.getNeedLevel();
				
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}
		
		list.add("Lv." + needLevel + " Spell Card");
		
		int miracleTime = 0;
		NBTTagCompound nbt = itemStack.getTagCompound();
		if(nbt != null)
		{
			miracleTime = nbt.getInteger("Charge");
		}
		if(itemStack.getItemDamage() >= 14 && itemStack.getItemDamage() <= 18)
		{
			int level = 20 - ((14 - itemStack.getItemDamage()) * 5) ;
			list.add(StatCollector.translateToLocal("thKaguya.msg.sneSc1") + level + StatCollector.translateToLocal("thKaguya.msg.sneSc2")+ (itemStack.getItemDamage() - 13) + StatCollector.translateToLocal("thKaguya.msg.sneSc3"));
			list.add(StatCollector.translateToLocal("thKaguya.msg.sneSc4") + miracleTime / 10 + "%");
		}

	}
    
	//アイテムを発光させる。 trueなら発光
	@Override
	@SideOnly(Side.CLIENT)
	public boolean hasEffect(ItemStack itemStack, int pass)
	{   
		//早苗のスペルカードがアクティブ状態なら光らせる
		if(itemStack.getItemDamage() >= 14 && itemStack.getItemDamage() <= 18)
		{
			NBTTagCompound nbt = itemStack.getTagCompound();
			if(nbt != null)
			{
				if(nbt.getInteger("Charge") > 0)
				{
					return true;
				}
			}
		}
		return false;
	}
	
	//クリエイトモードのアイテム欄に、ダメージ値の違うアイテムも表示できるようにする
	@SideOnly(Side.CLIENT)
	public void getSubItems(Item item, CreativeTabs creativeTabs, List list)
    {
		List<String> sortList = SpellCardRegistry.sortSpellCard();
		
		for(int i = 0; i < sortList.size(); i++)
		{
			list.add(new ItemStack(THKaguyaItems.spell_card, 1, SpellCardRegistry.spellcardID.get(sortList.get(i))));
		}
    }
	
}