package thKaguyaMod.item;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thKaguyaMod.entity.item.EntitySakuyaWatch;

public class ItemSakuyaWatch extends Item
{

	public ItemSakuyaWatch()
	{
		super();
		this.setTextureName("thkaguyamod:sakuyaWatch");//テクスチャの指定
		maxStackSize = 1;//最大スタック
		setCreativeTab(CreativeTabs.tabMisc);//クリエイティブのその他タブに登録
	}
	
	/** 右クリックを押した瞬間の処理
	 *  @param itemStack : 右クリックを押したItemStack
	 *  @param world     : ワールド
	 *  @param player    : 右クリックを押したプレイヤー
	 *  @return 右クリックを押したItemStackを返す
	 */
	@Override
   	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player)
    {
        /*ArrowNockEvent event = new ArrowNockEvent(player, itemStack);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled())
        {
            return event.result;
        }*/
		if(player.capabilities.isCreativeMode)
		{
			onEaten(itemStack, world, player);
		}
		
		player.setItemInUse(itemStack, getMaxItemUseDuration(itemStack));
       	return itemStack;
    }
	
	/**
	 * 右クリックを終了したときの処理
	 * @param itemStack
	 * @param world
	 * @param player
	 * @param usedTime
	 */
	@Override
	//public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int usedTime)
	public ItemStack onEaten(ItemStack itemStack, World world, EntityPlayer player)
	{
		int usedTime = 24;
		//usedTime = getMaxItemUseDuration(itemStack) - usedTime;
		
        /*ArrowLooseEvent event = new ArrowLooseEvent(player, itemStack, usedTime);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled())
        {
            return;
        }
        usedTime = event.charge;*/
        
		//空腹でないか、クリエイティブなら使用可能
    	if(player.getFoodStats().getFoodLevel() > 0 || player.capabilities.isCreativeMode)
    	{
    		int mode;
    		if(player.capabilities.isCreativeMode)
    		{
	    		mode = EntitySakuyaWatch.TIME_STOP;
	    		if(player.isSneaking())//スニークなら低速モード　　通常は停止モード
	    		{
	    			mode = EntitySakuyaWatch.TIME_HALF;
	    		}
    		}
    		else if(usedTime >= 24)
    		{
	    		mode = EntitySakuyaWatch.TIME_STOP_WITH_LIMIT;
	    		if(player.isSneaking())//スニークなら低速モード　　通常は停止モード
	    		{
	    			mode = EntitySakuyaWatch.TIME_HALF_WITH_LIMIT;
	    		}
    		}
    		else
    		{
    			return itemStack;
    		}
    		
    		//周囲のEntityを取得
    		List<?> list = world.getEntitiesWithinAABBExcludingEntity(player, player.boundingBox.addCoord(0.0D, 0.0D, 0.0D).expand(20.0D, 20.0D, 20.0D));
    		for(int k = 0; k < list.size(); k++)
    		{
    			Entity entity = (Entity)list.get(k);
    			if(entity instanceof EntitySakuyaWatch)//懐中時計があるなら
    			{
    				return itemStack;
    				/*EntityPrivateSquare entityPrivateSquare = (EntityPrivateSquare)entity;
    				if(entityPrivateSquare.userEntity == player)//その懐中時計の持ち主がこの時計の持ち主と同じなら
    				{
						return;// itemStack;//時計は出せない
    				}*/
    			}
    		}

   			world.playSoundAtEntity(player, "random.click", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));

    		EntitySakuyaWatch entityPrivateSquare = new EntitySakuyaWatch(world, player, mode);
       		if(!world.isRemote)
       		{
         		world.spawnEntityInWorld(entityPrivateSquare);//時間停止空間を生み出す
       		}
       		if(! player.capabilities.isCreativeMode)
       		{
       			itemStack.stackSize--;
       		}
    	}
    	return itemStack;
	}
	
	/*@Override
    public ItemStack onEaten(ItemStack itemStack, World world, EntityPlayer player)
    {
        return itemStack;
    }*/
    
    @Override
    public int getMaxItemUseDuration(ItemStack itemStack)
    {
        return 24;
    }
	
	//アイテムを使ったときのアクションを指定
	@Override
	public EnumAction getItemUseAction(ItemStack itemStack)
	{
		return EnumAction.bow;
	}
}