/*
 * BedrockLayer
 *
 * Copyright (c) 2014 kegare
 * https://github.com/kegare
 *
 * This mod is distributed under the terms of the Minecraft Mod Public License Japanese Translation, or MMPL_J.
 */

package com.kegare.bedrocklayer.core;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.StatCollector;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

import com.google.common.base.Objects;
import com.google.common.base.Strings;

public class FlattenEntry
{
	public int dim;
	public int minHeight;
	public int maxHeight;
	public Block filler;
	public int fillerMeta;

	public String configName;
	public boolean configDefault;

	public FlattenEntry(int dim, int min, int max, Block filler, int fillerMeta)
	{
		this.dim = dim;
		this.minHeight = min;
		this.maxHeight = max;
		this.filler = filler;
		this.fillerMeta = fillerMeta;
	}

	@Override
	public int hashCode()
	{
		return Objects.hashCode(dim, minHeight, maxHeight, filler, fillerMeta);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof FlattenEntry)
		{
			FlattenEntry entry = (FlattenEntry)obj;

			return dim == entry.dim && minHeight == entry.minHeight && maxHeight == entry.maxHeight && filler == entry.filler && fillerMeta == entry.fillerMeta;
		}

		return false;
	}

	public FlattenEntry setConfig(String name, boolean defaultValue)
	{
		configName = name;
		configDefault = defaultValue;

		return this;
	}

	public Property getConfigProperty(Configuration config)
	{
		if (Strings.isNullOrEmpty(configName))
		{
			return null;
		}

		Property prop = config.get("bedrocklayer", configName, configDefault);
		prop.setLanguageKey(BedrockLayer.CONFIG_LANG + prop.getName());
		prop.comment = StatCollector.translateToLocal(prop.getLanguageKey() + ".tooltip");
		prop.comment += " [default: " + prop.getDefault() + "]";

		return prop;
	}

	public boolean flatten(Chunk chunk)
	{
		if (chunk.worldObj.provider.dimensionId != dim)
		{
			return false;
		}

		for (int x = 0; x < 16; ++x)
		{
			for (int z = 0; z < 16; ++z)
			{
				for (int y = minHeight; y < maxHeight; ++y)
				{
					if (chunk.getBlock(x, y, z) == Blocks.bedrock)
					{
						chunk.func_150807_a(x, y, z, filler, fillerMeta);
					}
				}
			}
		}

		return true;
	}
}