/*
 * BedrockLayer
 *
 * Copyright (c) 2014 kegare
 * https://github.com/kegare
 *
 * This mod is distributed under the terms of the Minecraft Mod Public License Japanese Translation, or MMPL_J.
 */

package com.kegare.bedrocklayer.core;

import static com.kegare.bedrocklayer.core.BedrockLayer.*;

import java.io.File;
import java.util.Map;

import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

import com.kegare.bedrocklayer.api.BedrockLayerAPI;
import com.kegare.bedrocklayer.handler.BedrockEventHooks;
import com.kegare.bedrocklayer.handler.BedrockLayerAPIHandler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;

@Mod
(
	modid = MODID,
	guiFactory = MOD_PACKAGE + ".client.config.BedrockGuiFactory"
)
public class BedrockLayer
{
	public static final String
	MODID = "kegare.bedrocklayer",
	MOD_PACKAGE = "com.kegare.bedrocklayer",
	CONFIG_LANG = "bedrocklayer.config.";

	@SidedProxy(modId = MODID, clientSide = MOD_PACKAGE + ".client.ClientProxy", serverSide = MOD_PACKAGE + ".core.CommonProxy")
	public static CommonProxy proxy;

	@EventHandler
	public void construct(FMLConstructionEvent event)
	{
		BedrockLayerAPI.instance = new BedrockLayerAPIHandler();
	}

	@EventHandler
	public void preInit(FMLPreInitializationEvent event)
	{
		proxy.initializeConfigEntries();

		Config.syncConfig();

		BedrockLayerAPI.registerFlatten(0, 1, 5, Blocks.stone, 0, "overworld", true);
		BedrockLayerAPI.registerFlatten(-1, 1, 5, Blocks.netherrack, 0, "netherLower", true);
		BedrockLayerAPI.registerFlatten(-1, 122, 127, Blocks.netherrack, 0, "netherUpper", true);
	}

	@EventHandler
	public void init(FMLInitializationEvent event)
	{
		FMLCommonHandler.instance().bus().register(BedrockEventHooks.instance);

		MinecraftForge.EVENT_BUS.register(BedrockEventHooks.instance);
	}

	@EventHandler
	public void postInit(FMLPostInitializationEvent event)
	{
		if (Loader.isModLoaded("TwilightForest"))
		{
			File file = new File(Loader.instance().getConfigDir(), "TwilightForest.cfg");

			if (file.exists() && file.canRead())
			{
				Property prop = new Configuration(file).getCategory("dimension").get("dimensionID");

				if (prop != null && prop.isIntValue())
				{
					BedrockLayerAPI.registerFlatten(prop.getInt(), 1, 5, Blocks.stone, 0, "twilightforest", false);
				}
			}
		}
	}

	@EventHandler
	public void loaded(FMLLoadCompleteEvent event)
	{
		Config.syncConfig();
	}

	@EventHandler
	public void onServerStarting(FMLServerStartingEvent event)
	{
		BedrockEventHooks.layeredChunks.clear();
	}

	@NetworkCheckHandler
	public boolean netCheckHandler(Map<String, String> mods, Side side)
	{
		return true;
	}
}