package com.kegare.bedrocklayer.api;

import net.minecraft.block.Block;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.config.Configuration;

/**
 * NOTE: Do NOT access to this class fields.
 * You should use API from this class methods.
 */
public final class BedrockLayerAPI
{
	public static IBedrockLayerAPI instance;

	private BedrockLayerAPI() {}

	public static Configuration getConfig()
	{
		return instance == null ? null : instance.getConfig();
	}

	public static void registerFlatten(int dim, int min, int max, Block filler, int fillerMeta)
	{
		if (instance != null)
		{
			instance.registerFlatten(dim, min, max, filler, fillerMeta);
		}
	}

	public static void registerFlatten(int dim, int min, int max, Block filler, int fillerMeta, String configName, boolean configDefault)
	{
		if (instance != null)
		{
			instance.registerFlatten(dim, min, max, filler, fillerMeta, configName, configDefault);
		}
	}

	public static boolean unregisterFlatten(int dim)
	{
		return instance != null && instance.unregisterFlatten(dim);
	}

	public static void flatten(Chunk chunk)
	{
		if (instance != null)
		{
			instance.flatten(chunk);
		}
	}
}