/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import reifnsk.minimap.GuiTeleport;
import reifnsk.minimap.GuiWaypointEditorScreen;
import reifnsk.minimap.GuiWaypointScreen;
import reifnsk.minimap.ReiMinimap;
import reifnsk.minimap.Waypoint;

class GuiWaypoint
extends GuiButton {
    private static final int[] COLOR1 = new int[]{-1, -65536};
    private static final int[] COLOR2 = new int[]{-4144960, -4194304};
    private static final int COLOR_SIZE = 9;
    private static final int BUTTON_SIZE = 30;
    private static final int ADD_SPACE = 2;
    protected static final int SIZE = 45;
    private GuiWaypointScreen gws;
    private Waypoint waypoint;
    private int number;
    private String name;
    private int top;
    private int bottom;
    private int left;
    private int right;
    private int ctop;
    private int cbottom;
    private int cleft;
    private int cright;
    private int btop;
    private int bbottom;
    private int bleft;
    private int bright;
    private long clickTime = System.nanoTime();

    protected GuiWaypoint(int i, GuiWaypointScreen gws) {
        super(i, 0, 0, 0, 0, (String)null);
        this.gws = gws;
    }

    protected void setWaypoint(int num, Waypoint pt) {
        this.number = num;
        this.waypoint = pt;
        this.name = null;
    }

    public void func_146112_a(Minecraft minecraft, int i, int j) {
        if (this.waypoint != null) {
            String text;
            boolean hover;
            FontRenderer fontRenderer = minecraft.field_71466_p;
            if (this.name == null) {
                this.name = this.number + ") " + this.waypoint.name;
                while (fontRenderer.func_78256_a(this.name) > 160) {
                    this.name = this.name.substring(0, this.name.length() - 1);
                }
            }
            this.func_73731_b(fontRenderer, this.name, this.field_146128_h + 1, this.field_146129_i + 1, ((hover = this.mouseIn(i, j)) ? COLOR1 : COLOR2)[this.waypoint.type]);
            boolean tooltip = hover && i < this.cleft;
            int r = (int)(this.waypoint.red * 255.0f) & 0xFF;
            int g = (int)(this.waypoint.green * 255.0f) & 0xFF;
            int b = (int)(this.waypoint.blue * 255.0f) & 0xFF;
            int color = 0xFF000000 | r << 16 | g << 8 | b;
            GuiWaypoint.func_73734_a((int)this.cleft, (int)this.ctop, (int)this.cright, (int)this.cbottom, (int)color);
            hover = this.buttonIn(i, j);
            String string = this.gws.getRemoveMode() ? (this.gws.isRemove(this.waypoint) ? "X" : "KEEP") : (text = this.waypoint.enable ? "ON" : "OFF");
            color = hover ? -2130706433 : (text == "X" ? -1593901056 : (text == "KEEP" ? -1610547456 : (this.waypoint.enable ? -1610547456 : -1593901056)));
            GuiWaypoint.func_73734_a((int)this.bleft, (int)this.btop, (int)this.bright, (int)this.bbottom, (int)color);
            this.func_73732_a(minecraft.field_71466_p, text, this.bleft + this.bright >> 1, this.btop + 1, -1);
            if (tooltip) {
                String tooltipText = String.format("%+d, %+d", this.waypoint.x, this.waypoint.z);
                int width = fontRenderer.func_78256_a(tooltipText);
                int drawLeft = i - width / 2 - 2;
                int drawRight = drawLeft + width + 3;
                GuiWaypoint.func_73734_a((int)drawLeft, (int)(j - 17), (int)drawRight, (int)(j + 4), (int)-1610612736);
                this.func_73732_a(fontRenderer, tooltipText, i, j - 15, -1);
                this.func_73732_a(fontRenderer, String.format("%d", this.waypoint.y), i, j - 5, -1);
            }
        }
    }

    public boolean func_146116_c(Minecraft minecraft, int i, int j) {
        if (this.waypoint == null) {
            return false;
        }
        if (this.mouseIn(i, j)) {
            if (this.colorIn(i, j) && this.canTeleport(minecraft) && this.waypoint.y > 0) {
                minecraft.func_147108_a((GuiScreen)new GuiTeleport(this.gws, this.waypoint));
                return true;
            }
            if (this.buttonIn(i, j)) {
                if (this.gws.getRemoveMode()) {
                    this.gws.removeWaypoint(this.waypoint);
                } else {
                    this.waypoint.enable = !this.waypoint.enable;
                    this.gws.updateWaypoint(this.waypoint);
                }
                return true;
            }
            long time = System.nanoTime();
            if (!this.gws.getRemoveMode() && time < this.clickTime + 300000000L) {
                minecraft.func_147108_a((GuiScreen)new GuiWaypointEditorScreen(this.gws, this.waypoint));
                return true;
            }
            this.clickTime = time;
        }
        return false;
    }

    protected void bounds(int x, int y, int w, int h) {
        this.field_146128_h = x;
        this.field_146129_i = y;
        this.field_146120_f = w;
        this.field_146121_g = h;
        this.top = y;
        this.bottom = y + h;
        this.left = x;
        this.right = x + w;
        this.ctop = this.top;
        this.cbottom = this.bottom;
        this.cright = this.right - 2 - 30 - 2;
        this.cleft = this.cright - 9;
        this.btop = this.top;
        this.bbottom = this.bottom;
        this.bright = this.right - 2;
        this.bleft = this.bright - 30;
    }

    private boolean mouseIn(int x, int y) {
        return y >= this.top && y < this.bottom && x >= this.left && x < this.right;
    }

    private boolean colorIn(int x, int y) {
        return y >= this.ctop && y < this.cbottom && x >= this.cleft && x < this.cright;
    }

    private boolean buttonIn(int x, int y) {
        return y >= this.btop && y < this.bbottom && x >= this.bleft && x < this.bright;
    }

    private boolean canTeleport(Minecraft minecraft) {
        return minecraft.func_71387_A() ? minecraft.func_71401_C().field_71305_c[0].func_72912_H().func_76086_u() && minecraft.field_71439_g.field_71093_bK == ReiMinimap.instance.getWaypointDimension() : minecraft.field_71439_g.field_71093_bK == ReiMinimap.instance.getWaypointDimension();
    }
}

