/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class GuiScrollbar
extends GuiButton {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private long repeatStart = 500000000L;
    private long repeatInterval = 40000000L;
    protected int orientation;
    private float value = 0.0f;
    private float extent = 0.0f;
    private float min = 0.0f;
    private float max = 0.0f;
    private float unitIncrement = 1.0f;
    private float blockIncrement = 9.0f;
    private int draggingPos;
    private float draggingValue;
    private int dragging;
    private long draggingTimer;
    private int minBarSize = 6;

    public GuiScrollbar(int id, int x, int y, int w, int h) {
        super(id, x, y, w, h, "");
    }

    public void func_146112_a(Minecraft mc, int i, int j) {
        if (this.value > this.max - this.extent) {
            this.value = this.max - this.extent;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        if (this.orientation == 0) {
            this.drawVertical(mc, i, j);
        } else if (this.orientation == 1) {
            this.drawHorizontal(mc, i, j);
        }
    }

    private void drawVertical(Minecraft mc, int mx, int my) {
        boolean bx;
        if (this.dragging != 0) {
            this.func_146119_b(mc, mx, my);
        }
        double centerX = (double)this.field_146128_h + (double)this.field_146120_f * 0.5;
        int top = this.field_146129_i;
        int bottom = this.field_146129_i + this.field_146121_g;
        Tessellator tesse = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        boolean bl = bx = (double)mx >= centerX - 4.0 && (double)mx <= centerX + 4.0;
        if (bx && my >= top && my <= top + 8 && (this.dragging == 0 || this.dragging == 1)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        }
        tesse.func_78382_b();
        tesse.func_78377_a(centerX, (double)top, 0.0);
        tesse.func_78377_a(centerX, (double)top, 0.0);
        tesse.func_78377_a(centerX - 4.0, (double)(top + 8), 0.0);
        tesse.func_78377_a(centerX + 4.0, (double)(top + 8), 0.0);
        tesse.func_78381_a();
        if (this.min < this.max - this.extent) {
            double maxY = this.extent / (this.max - this.min);
            double minY = this.field_146121_g - 20;
            if (maxY * minY < (double)this.minBarSize) {
                maxY = (double)this.minBarSize / minY;
            }
            double minY1 = (double)(this.value / (this.max - this.min - this.extent)) * (1.0 - maxY);
            double maxY1 = minY1 + maxY;
            minY1 = (double)top + minY1 * minY + 10.0;
            maxY1 = (double)top + maxY1 * minY + 10.0;
            if (this.dragging != 5 && (!bx || (double)my < minY1 || (double)my > maxY1 || this.dragging != 0)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            }
            tesse.func_78382_b();
            tesse.func_78377_a(centerX + 4.0, minY1, 0.0);
            tesse.func_78377_a(centerX - 4.0, minY1, 0.0);
            tesse.func_78377_a(centerX - 4.0, maxY1, 0.0);
            tesse.func_78377_a(centerX + 4.0, maxY1, 0.0);
            tesse.func_78381_a();
        } else {
            double minY = top + 10;
            double maxY = bottom - 10;
            if (this.dragging != 5 && (!bx || (double)my < minY || (double)my > maxY || this.dragging != 0)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            }
            tesse.func_78382_b();
            tesse.func_78377_a(centerX + 4.0, minY, 0.0);
            tesse.func_78377_a(centerX - 4.0, minY, 0.0);
            tesse.func_78377_a(centerX - 4.0, maxY, 0.0);
            tesse.func_78377_a(centerX + 4.0, maxY, 0.0);
            tesse.func_78381_a();
        }
        if (bx && my >= bottom - 8 && my <= bottom && (this.dragging == 0 || this.dragging == 2)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        }
        tesse.func_78382_b();
        tesse.func_78377_a(centerX, (double)bottom, 0.0);
        tesse.func_78377_a(centerX, (double)bottom, 0.0);
        tesse.func_78377_a(centerX + 4.0, (double)(bottom - 8), 0.0);
        tesse.func_78377_a(centerX - 4.0, (double)(bottom - 8), 0.0);
        tesse.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void drawHorizontal(Minecraft mc, int mx, int my) {
        boolean by;
        if (this.dragging != 0) {
            this.func_146119_b(mc, mx, my);
        }
        double centerY = (double)this.field_146129_i + (double)this.field_146121_g * 0.5;
        int left = this.field_146128_h;
        int right = this.field_146128_h + this.field_146120_f;
        Tessellator tesse = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        boolean bl = by = (double)my >= centerY - 4.0 && (double)my <= centerY + 4.0;
        if (by && mx >= left && mx <= left + 8 && (this.dragging == 0 || this.dragging == 1)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        }
        tesse.func_78382_b();
        tesse.func_78377_a((double)left, centerY, 0.0);
        tesse.func_78377_a((double)left, centerY, 0.0);
        tesse.func_78377_a((double)(left + 8), centerY + 4.0, 0.0);
        tesse.func_78377_a((double)(left + 8), centerY - 4.0, 0.0);
        tesse.func_78381_a();
        if (this.min < this.max - this.extent) {
            double maxX = this.extent / (this.max - this.min);
            double minX = this.field_146120_f - 20;
            if (maxX * minX < (double)this.minBarSize) {
                maxX = (double)this.minBarSize / minX;
            }
            double minX1 = (double)(this.value / (this.max - this.min - this.extent)) * (1.0 - maxX);
            double maxX1 = minX1 + maxX;
            minX1 = (double)left + minX1 * minX + 10.0;
            maxX1 = (double)left + maxX1 * minX + 10.0;
            if (this.dragging != 6 && (!by || (double)mx < minX1 || (double)mx > maxX1 || this.dragging != 0)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            }
            tesse.func_78382_b();
            tesse.func_78377_a(minX1, centerY - 4.0, 0.0);
            tesse.func_78377_a(minX1, centerY + 4.0, 0.0);
            tesse.func_78377_a(maxX1, centerY + 4.0, 0.0);
            tesse.func_78377_a(maxX1, centerY - 4.0, 0.0);
            tesse.func_78381_a();
        } else {
            double minX = left + 10;
            double maxX = right - 10;
            if (this.dragging != 6 && (!by || (double)mx < minX || (double)mx > maxX || this.dragging != 0)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            }
            tesse.func_78382_b();
            tesse.func_78377_a(minX, centerY - 4.0, 0.0);
            tesse.func_78377_a(minX, centerY + 4.0, 0.0);
            tesse.func_78377_a(maxX, centerY + 4.0, 0.0);
            tesse.func_78377_a(maxX, centerY - 4.0, 0.0);
            tesse.func_78381_a();
        }
        if (by && mx >= right - 8 && mx <= right && (this.dragging == 0 || this.dragging == 2)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        }
        tesse.func_78382_b();
        tesse.func_78377_a((double)right, centerY, 0.0);
        tesse.func_78377_a((double)right, centerY, 0.0);
        tesse.func_78377_a((double)(right - 8), centerY - 4.0, 0.0);
        tesse.func_78377_a((double)(right - 8), centerY + 4.0, 0.0);
        tesse.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        return super.func_146116_c(mc, mx, my) ? (this.orientation == 0 ? this.mousePressedVertical(mc, mx, my) : (this.orientation == 1 ? this.mousePressedHorizontal(mc, mx, my) : false)) : false;
    }

    private boolean mousePressedVertical(Minecraft mc, int mx, int my) {
        double centerX = (double)this.field_146128_h + (double)this.field_146120_f * 0.5;
        int top = this.field_146129_i;
        int bottom = this.field_146129_i + this.field_146121_g;
        if ((double)mx >= centerX - 4.0 && (double)mx <= centerX + 4.0) {
            if (this.max == this.min) {
                return true;
            }
            if (this.dragging == 0) {
                this.draggingTimer = System.nanoTime() + this.repeatStart;
            }
            if (my >= top && my <= top + 8 && (this.dragging == 0 || this.dragging == 1)) {
                this.dragging = 1;
                this.unitDecrement();
                return true;
            }
            if (my >= bottom - 8 && my <= bottom && (this.dragging == 0 || this.dragging == 2)) {
                this.dragging = 2;
                this.unitIncrement();
                return true;
            }
            double barsize = this.extent / (this.max - this.min);
            double boxsize = this.field_146121_g - 20;
            if (barsize * boxsize < (double)this.minBarSize) {
                barsize = (double)this.minBarSize / boxsize;
            }
            double minY = (double)(this.value / (this.max - this.min - this.extent)) * (1.0 - barsize);
            double maxY = minY + barsize;
            minY = (double)top + minY * boxsize + 10.0;
            maxY = (double)top + maxY * boxsize + 10.0;
            if ((double)my < minY && (this.dragging == 0 || this.dragging == 3)) {
                this.dragging = 3;
                this.blockDecrement();
                return true;
            }
            if ((double)my > maxY && (this.dragging == 0 || this.dragging == 4)) {
                this.dragging = 4;
                this.blockIncrement();
                return true;
            }
            if (this.dragging == 0) {
                this.dragging = 5;
                this.draggingPos = my;
                this.draggingValue = this.value;
            }
            return true;
        }
        return false;
    }

    private boolean mousePressedHorizontal(Minecraft mc, int mx, int my) {
        double centerY = (double)this.field_146129_i + (double)this.field_146121_g * 0.5;
        int left = this.field_146128_h;
        int right = this.field_146128_h + this.field_146120_f;
        if ((double)my >= centerY - 4.0 && (double)my <= centerY + 4.0) {
            if (this.max == this.min) {
                return true;
            }
            if (this.dragging == 0) {
                this.draggingTimer = System.nanoTime() + this.repeatStart;
            }
            if (mx >= left && mx <= left + 8 && (this.dragging == 0 || this.dragging == 1)) {
                this.dragging = 1;
                this.unitDecrement();
                return true;
            }
            if (mx >= right - 8 && mx <= right && (this.dragging == 0 || this.dragging == 2)) {
                this.dragging = 2;
                this.unitIncrement();
                return true;
            }
            double barsize = this.extent / (this.max - this.min);
            double boxsize = this.field_146120_f - 20;
            if (barsize * boxsize < (double)this.minBarSize) {
                barsize = (double)this.minBarSize / boxsize;
            }
            double minX = (double)(this.value / (this.max - this.min - this.extent)) * (1.0 - barsize);
            double maxX = minX + barsize;
            minX = (double)left + minX * boxsize + 10.0;
            maxX = (double)left + maxX * boxsize + 10.0;
            if ((double)mx < minX && (this.dragging == 0 || this.dragging == 3)) {
                this.dragging = 3;
                this.blockDecrement();
                return true;
            }
            if ((double)mx > maxX && (this.dragging == 0 || this.dragging == 4)) {
                this.dragging = 4;
                this.blockIncrement();
                return true;
            }
            if (this.dragging == 0) {
                this.dragging = 6;
                this.draggingPos = mx;
                this.draggingValue = this.value;
            }
            return true;
        }
        return false;
    }

    protected void func_146119_b(Minecraft minecraft, int mx, int my) {
        long time1;
        float newValue;
        float time;
        float barsize;
        if (this.dragging == 5) {
            barsize = this.extent / (this.max - this.min);
            time = this.field_146121_g - 20;
            if (barsize * time < (float)this.minBarSize) {
                barsize = (float)this.minBarSize / time;
            }
            newValue = this.draggingValue + (this.max - this.min - this.extent) / (1.0f - barsize) * (float)(my - this.draggingPos) / time;
            this.value = Math.max(this.min, Math.min(this.max - this.extent, newValue));
        }
        if (this.dragging == 6) {
            barsize = this.extent / (this.max - this.min);
            time = this.field_146120_f - 20;
            if (barsize * time < (float)this.minBarSize) {
                barsize = (float)this.minBarSize / time;
            }
            newValue = this.draggingValue + (this.max - this.min - this.extent) / (1.0f - barsize) * (float)(mx - this.draggingPos) / time;
            this.value = Math.max(this.min, Math.min(this.max - this.extent, newValue));
        }
        if (this.draggingTimer < (time1 = System.nanoTime())) {
            this.func_146116_c(minecraft, mx, my);
            this.draggingTimer = time1 + this.repeatInterval;
        }
    }

    public void func_146118_a(int i, int j) {
        this.dragging = 0;
    }

    public void setValue(float value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max - this.extent) {
            value = this.max - this.extent;
        }
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    public void setMaximum(float max) {
        if (this.min > max) {
            throw new IllegalArgumentException("min > max");
        }
        this.max = max;
        this.value = Math.min(this.value, this.max);
    }

    public float getMaximum() {
        return this.max;
    }

    public void setMinimum(float min) {
        if (min > this.max) {
            throw new IllegalArgumentException("min > max");
        }
        this.min = min;
        this.value = Math.max(this.value, this.min);
    }

    public float getMinimum() {
        return this.min;
    }

    public void setVisibleAmount(float extent) {
        if (this.max - this.min < extent) {
            throw new IllegalArgumentException("max - min < extent");
        }
        this.extent = Math.min(this.max - this.min, extent);
    }

    public float getVisibleAmount() {
        return this.extent;
    }

    public void unitIncrement() {
        this.value = Math.min(this.max - this.extent, this.value + this.unitIncrement);
    }

    public void unitDecrement() {
        this.value = Math.max(this.min, this.value - this.unitIncrement);
    }

    public void blockIncrement() {
        this.value = Math.min(this.max - this.extent, this.value + this.blockIncrement);
    }

    public void blockDecrement() {
        this.value = Math.max(this.min, this.value - this.blockIncrement);
    }

    public void setMinimumBarSize(int size) {
        this.minBarSize = size;
    }

    public int getMinimumBarSize() {
        return this.minBarSize;
    }

    public void setUnitIncrement(float inc) {
        this.unitIncrement = inc;
    }

    public void setBlockIncrement(float inc) {
        this.blockIncrement = inc;
    }

    public float getUnitIncrement() {
        return this.unitIncrement;
    }

    public float getBlockIncrement() {
        return this.blockIncrement;
    }
}

