/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import reifnsk.minimap.BlockAccess;
import reifnsk.minimap.BlockColor;
import reifnsk.minimap.BlockData;
import reifnsk.minimap.BlockType;
import reifnsk.minimap.ReiMinimap;

public class BlockDataPack {
    private static final int renderStandardBlock = 0;
    private static final int renderCrossedSquares = 1;
    private static final int renderBlockTorch = 2;
    private static final int renderBlockFire = 3;
    private static final int renderBlockFluids = 4;
    private static final int renderBlockRedstoneWire = 5;
    private static final int renderBlockCrops = 6;
    private static final int renderBlockDoor = 7;
    private static final int renderBlockLadder = 8;
    private static final int renderBlockMinecartTrack = 9;
    private static final int renderBlockStairs = 10;
    private static final int renderBlockFence = 11;
    private static final int renderBlockLever = 12;
    private static final int renderBlockCactus = 13;
    private static final int renderBlockBed = 14;
    private static final int renderBlockRepeater = 15;
    private static final int renderPistonBase = 16;
    private static final int renderPistonExtension = 17;
    private static final int renderBlockPane = 18;
    private static final int renderBlockStem = 19;
    private static final int renderBlockVine = 20;
    private static final int renderBlockFenceGate = 21;
    private static final int renderBlockChest = 22;
    private static final int renderBlockLilyPad = 23;
    private static final int renderBlockCauldron = 24;
    private static final int renderBlockBrewingStand = 25;
    private static final int renderBlockEndPortalFrame = 26;
    private static final int renderBlockDragonEgg = 27;
    private static final int renderBlockCocoa = 28;
    private static final int renderBlockTripWireSource = 29;
    private static final int renderBlockTripWire = 30;
    private static final int renderBlockLog = 31;
    private static final int renderBlockWall = 32;
    private static final int renderBlockFlowerpot = 33;
    private static final int renderBlockBeacon = 34;
    private static final int renderBlockAnvil = 35;
    private static final int renderBlockRepeater2 = 36;
    private static final int renderBlockComparator = 37;
    private static final int renderBlockHopper = 38;
    private static final int renderBlockModLoader = -1;
    protected static final int BLOCK_NUM = 4096;
    protected static final int BLOCK_META_BITS = 4;
    protected static final int BLOCK_META = 16;
    protected static final int BLOCK_META_MASK = 15;
    protected static final int BLOCK_COLOR_NUM = 65536;
    protected static BlockData[] blockData;
    protected static float[] height;
    protected static BlockData[] blockColorData;
    public static BlockColor[] defaultBlockColor;
    private static AtomicReference<Thread> referenceThread;

    protected static synchronized void calcTexture() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                defaultBlockColor = BlockDataPack.calcTextureColor();
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        referenceThread.set(thread);
        thread.start();
    }

    private static BlockColor[] calcTextureColor() {
        int i;
        BlockDynamicLiquid waterMoving = (BlockDynamicLiquid)Block.func_149684_b((String)"flowing_water");
        BlockStaticLiquid waterStill = (BlockStaticLiquid)Block.func_149684_b((String)"water");
        Thread currentThread = Thread.currentThread();
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        BlockColor[] result = defaultBlockColor != null ? Arrays.copyOf(defaultBlockColor, 65536) : new BlockColor[65536];
        boolean skipTexture = false;
        String textureName = null;
        BufferedImage image = null;
        int[] splitImage = null;
        int w = 0;
        int h = 0;
        int sw = 0;
        int sh = 0;
        HashMap<BlockData, BlockColor> map = new HashMap<BlockData, BlockColor>();
        BlockData[] arr = blockData;
        int len = arr.length;
        for (i = 0; i < len; ++i) {
            BlockData bd;
            block42: {
                bd = arr[i];
                if (referenceThread.get() != currentThread) break;
                if (!bd.textureName.equals(textureName)) {
                    textureName = bd.textureName;
                    String texturePath = BlockDataPack.fixDomain("textures/blocks/", textureName) + ".png";
                    try {
                        ResourceLocation tempImage = new ResourceLocation(texturePath);
                        IResource resource = rm.func_110536_a(tempImage);
                        image = ImageIO.read(resource.func_110527_b());
                        skipTexture = false;
                        w = image.getWidth();
                        h = image.getHeight();
                        sw = w;
                        sh = w;
                        splitImage = BlockDataPack.calcColorArrays(image, bd.renderPass, null);
                        break block42;
                    }
                    catch (IOException e) {
                        skipTexture = true;
                        continue;
                    }
                }
                if (skipTexture) continue;
            }
            BlockColor bc = null;
            switch (bd.renderType) {
                default: {
                    BlockType blockType = bd.extend instanceof BlockType ? (BlockType)((Object)bd.extend) : BlockType.NORMAL;
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    bc = new BlockColor(rgb, blockType);
                    break;
                }
                case 1: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.max(rgb >>> 24, 48) << 24;
                    rgb = rgb & 0xFFFFFF | alpha;
                    bc = new BlockColor(rgb, bd.extend instanceof BlockType ? (BlockType)((Object)bd.extend) : BlockType.NORMAL);
                    break;
                }
                case 2: {
                    int b;
                    int g;
                    int r;
                    int rgb1 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.4375f, 0.4375f, 0.5625f, 0.5625f);
                    int rgb2 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.375f, 0.375f, 0.625f, 0.625f);
                    int alpha1 = rgb1 >> 24 & 0xFF;
                    int alpha2 = rgb2 >> 24 & 0xFF;
                    int alpha = alpha1 + alpha2;
                    if (alpha != 0) {
                        r = (rgb1 * alpha1 + (rgb2 >> 16 & 0xFF) * alpha2) / alpha;
                        g = ((rgb1 >> 8 & 0xFF) * alpha1 + (rgb2 >> 8 & 0xFF) * alpha2) / alpha;
                        b = ((rgb1 >> 0 & 0xFF) * alpha1 + (rgb2 >> 0 & 0xFF) * alpha2) / alpha;
                        bc = new BlockColor(Integer.MIN_VALUE | r << 16 | g << 8 | b, BlockType.NORMAL);
                        break;
                    }
                    rgb1 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.25f, 0.25f, 0.75f, 0.75f);
                    alpha1 = rgb1 >> 24 & 0xFF;
                    alpha = alpha1 + (alpha2 = (rgb2 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.0f, 0.0f, 1.0f, 1.0f)) >> 24 & 0xFF);
                    if (alpha == 0) break;
                    r = ((rgb1 >> 16 & 0xFF) * alpha1 + (rgb2 >> 16 & 0xFF) * alpha2) / alpha;
                    g = ((rgb1 >> 8 & 0xFF) * alpha1 + (rgb2 >> 8 & 0xFF) * alpha2) / alpha;
                    b = ((rgb1 >> 0 & 0xFF) * alpha1 + (rgb2 >> 0 & 0xFF) * alpha2) / alpha;
                    bc = new BlockColor(Integer.MIN_VALUE | r << 16 | g << 8 | b, BlockType.NORMAL);
                    break;
                }
                case 3: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 4: {
                    BlockType blockType = bd.extend != waterStill && bd.extend != waterMoving ? BlockType.NORMAL : BlockType.WATER;
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), blockType);
                    break;
                }
                case 5: {
                    int meta = bd.extend instanceof Integer ? (Integer)bd.extend : 0;
                    float f = (float)meta / 15.0f;
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.max(rgb >> 24 & 0xFF, 108);
                    int r = (int)((float)(rgb >> 16 & 0xFF) * Math.max(0.3f, f * 0.6f + 0.4f));
                    int g = (int)((float)(rgb >> 8 & 0xFF) * Math.max(0.0f, f * f * 0.7f - 0.5f));
                    bc = new BlockColor(alpha << 24 | r << 16 | g << 8, BlockType.NORMAL);
                    break;
                }
                case 6: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.max(rgb >>> 24, 32) << 24;
                    bc = new BlockColor(rgb & 0xFFFFFF | alpha, BlockType.NORMAL);
                    break;
                }
                case 7: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 8: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.min(rgb >>> 24, 40) << 24;
                    bc = new BlockColor(rgb & 0xFFFFFF | alpha, BlockType.NORMAL);
                    break;
                }
                case 9: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 10: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 11: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.min(rgb >>> 24, 96) << 24;
                    bc = new BlockColor(rgb & 0xFFFFFF | alpha, BlockType.NORMAL);
                    break;
                }
                case 12: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 13: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 14: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 15: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 16: {
                    int meta;
                    if (bd.extend instanceof Integer && (meta = ((Integer)bd.extend).intValue()) >= 10 && meta <= 13) {
                        bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, 0.0f, 0.25f, 1.0f, 1.0f), BlockType.NORMAL);
                        break;
                    }
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 17: {
                    int meta;
                    if (bd.extend instanceof Integer && (((meta = ((Integer)bd.extend).intValue()) & 7) == 0 || (meta & 7) == 1)) {
                        bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                        break;
                    }
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, 0.0f, 0.0f, 1.0f, 0.25f) & 0xFFFFFF | Integer.MIN_VALUE, BlockType.NORMAL);
                    break;
                }
                case 18: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if ((rgb & 0xFF000000) == 0) break;
                    int base1 = Math.min(rgb >>> 24, 40) << 24;
                    bc = new BlockColor(rgb & 0xFFFFFF | base1, BlockType.NORMAL);
                    break;
                }
                case 19: {
                    int meta = bd.extend instanceof Integer ? (Integer)bd.extend : 0;
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.0f, 0.0f, 1.0f, bd.maxY);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.max(48, rgb >> 24 & 0xFF);
                    int r = (rgb >> 16 & 0xFF) * meta * 32 / 255;
                    int g = (rgb >> 8 & 0xFF) * (255 - meta * 8) / 255;
                    int b = (rgb >> 0 & 0xFF) * meta * 4 / 255;
                    bc = new BlockColor(alpha << 24 | r << 16 | g << 8 | b << 0, BlockType.NORMAL);
                    break;
                }
                case 20: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.0f, 0.0f, 1.0f, 1.0f);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.min(rgb >>> 24, 32) << 24;
                    bc = new BlockColor(rgb & 0xFFFFFF | alpha, BlockType.SIMPLE_FOLIAGE);
                    break;
                }
                case 21: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.0f, 0.0f, 1.0f, 1.0f);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = Math.min(rgb >>> 24, 128) << 24;
                    bc = new BlockColor(rgb & 0xFFFFFF | alpha, BlockType.NORMAL);
                    break;
                }
                case 22: {
                    bc = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ), BlockType.NORMAL);
                    break;
                }
                case 23: {
                    int rgb = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if ((rgb & 0xFF000000) == 0) break;
                    int alpha = rgb & 0xFF000000;
                    int r = (rgb >> 16 & 0xFF) * 32 / 255;
                    int g = (rgb >> 8 & 0xFF) * 128 / 255;
                    int b = (rgb >> 0 & 0xFF) * 48 / 255;
                    bc = new BlockColor(alpha | r << 16 | g << 8 | b << 0, BlockType.NORMAL);
                    break;
                }
                case 24: {
                    int meta;
                    int b;
                    int g;
                    int r;
                    int bottom = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    int top = BlockDataPack.calcColorInt(splitImage, sw, sh, bd.minX, bd.minZ, bd.maxX, bd.maxZ);
                    if (bd.extend instanceof Integer && (meta = ((Integer)bd.extend).intValue()) > 0) {
                        r = ((bottom >> 16 & 0xFF) * 102 + 5508) / 255;
                        g = ((bottom >> 8 & 0xFF) * 102 + 9027) / 255;
                        b = ((bottom >> 0 & 0xFF) * 102 + 39015) / 255;
                        bottom = 0xFF000000 | r << 16 | g << 8 | b << 0;
                    }
                    int alpha = top >> 24;
                    int a = 255 - alpha;
                    r = ((bottom >> 16 & 0xFF) * a + (top >> 16 & 0xFF) * alpha) / 255;
                    g = ((bottom >> 8 & 0xFF) * a + (top >> 8 & 0xFF) * alpha) / 255;
                    b = ((bottom >> 0 & 0xFF) * a + (top >> 0 & 0xFF) * alpha) / 255;
                    bc = new BlockColor(0xFF000000 | r << 16 | g << 8 | b << 0, BlockType.NORMAL);
                    break;
                }
                case 25: {
                    int base1 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.5625f, 0.3125f, 0.9375f, 0.6875f);
                    int base2 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.125f, 0.0625f, 0.5f, 0.4375f);
                    int base3 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.125f, 0.5625f, 0.5f, 0.9375f);
                    int r = (base1 >> 16 & 0xFF) + (base2 >> 16 & 0xFF) + (base3 >> 16 & 0xFF);
                    int g = (base1 >> 8 & 0xFF) + (base2 >> 8 & 0xFF) + (base3 >> 8 & 0xFF);
                    int b = (base1 >> 0 & 0xFF) + (base2 >> 0 & 0xFF) + (base3 >> 0 & 0xFF);
                    int meta = bd.extend instanceof Integer ? (Integer)bd.extend : 0;
                    int stand1 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.5f, 0.0f, 1.0f, 1.0f);
                    int stand2 = BlockDataPack.calcColorInt(splitImage, sw, sh, 0.0f, 0.0f, 0.5f, 1.0f);
                    switch (meta) {
                        case 0: {
                            r += (stand1 >> 16 & 0xFF) * 3;
                            g += (stand1 >> 8 & 0xFF) * 3;
                            b += (stand1 >> 0 & 0xFF) * 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            r += (stand1 >> 16 & 0xFF) * 2 + (stand2 >> 16 & 0xFF);
                            g += (stand1 >> 8 & 0xFF) * 2 + (stand2 >> 8 & 0xFF);
                            b += (stand1 >> 0 & 0xFF) * 2 + (stand2 >> 0 & 0xFF);
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: {
                            r += (stand1 >> 16 & 0xFF) + (stand2 >> 16 & 0xFF) * 2;
                            g += (stand1 >> 8 & 0xFF) + (stand2 >> 8 & 0xFF) * 2;
                            b += (stand1 >> 0 & 0xFF) + (stand2 >> 0 & 0xFF) * 2;
                            break;
                        }
                        case 7: {
                            r += (stand2 >> 16 & 0xFF) * 3;
                            g += (stand2 >> 8 & 0xFF) * 3;
                            b += (stand2 >> 0 & 0xFF) * 3;
                        }
                    }
                    bc = new BlockColor(Integer.MIN_VALUE | (r /= 6) << 16 | (g /= 6) << 8 | (b /= 6) << 0, BlockType.NORMAL);
                }
            }
            map.put(bd, bc);
        }
        for (i = 0; i < 65536; ++i) {
            result[i] = (BlockColor)map.get(blockColorData[i]);
        }
        referenceThread.compareAndSet(currentThread, null);
        ReiMinimap.instance.updateTexture = true;
        return result;
    }

    private static int[] calcColorArrays(BufferedImage image, int renderPass, List<Integer> list) {
        boolean alpha = renderPass == 1;
        int w = image.getWidth();
        int h = image.getHeight();
        int sz = w * w;
        int[] result = new int[sz];
        if (w == h) {
            image.getRGB(0, 0, w, h, result, 0, w);
            return result;
        }
        int[] rgbArray = image.getRGB(0, 0, w, h, new int[w * h], 0, w);
        int[] factor = new int[h / w];
        int num = 0;
        if (list == null) {
            Arrays.fill(factor, 1);
            num = factor.length;
        } else {
            for (Integer i : list) {
                if (i == null) continue;
                int i2 = i;
                int j = i2 >>> 16;
                int k = i2 & 0xFFFF;
                if (j >= factor.length) continue;
                int n = j;
                factor[n] = factor[n] + k;
                num += k;
            }
        }
        for (int i = 0; i < sz; ++i) {
            int rSum = 0;
            int gSum = 0;
            int bSum = 0;
            int aSum = 0;
            for (int j = 0; j < factor.length; ++j) {
                int rgb = rgbArray[j * sz + i];
                rSum += (rgb >> 16 & 0xFF) * factor[j];
                gSum += (rgb >> 8 & 0xFF) * factor[j];
                bSum += (rgb >> 0 & 0xFF) * factor[j];
                aSum += (rgb >> 24 & 0xFF) * factor[j];
            }
            int r = BlockDataPack.clamp(rSum / num, 0, 255);
            int g = BlockDataPack.clamp(gSum / num, 0, 255);
            int b = BlockDataPack.clamp(bSum / num, 0, 255);
            int a = BlockDataPack.clamp(aSum / num, 0, 255);
            if (!alpha) {
                a = a <= 25 ? 0 : 255;
            }
            result[i] = a << 24 | r << 16 | g << 8 | b << 0;
        }
        return result;
    }

    private static int clamp(int i, int min, int max) {
        return i < min ? min : (i > max ? max : i);
    }

    private static int calcColorInt(int[] image, int w, int h, float minX, float minZ, float maxX, float maxZ) {
        if (minX != maxX && minZ != maxZ) {
            int startX = (int)Math.floor((float)w * Math.max(0.0f, minX < maxX ? minX : maxX));
            int startY = (int)Math.floor((float)h * Math.max(0.0f, minZ < maxZ ? minZ : maxZ));
            int endX = (int)Math.floor((float)w * Math.min(1.0f, minX < maxX ? maxX : minX));
            int endY = (int)Math.floor((float)h * Math.min(1.0f, minZ < maxZ ? maxZ : minZ));
            long a = 0L;
            long r = 0L;
            long g = 0L;
            long b = 0L;
            for (int y = startY; y < endY; ++y) {
                for (int x = startX; x < endX; ++x) {
                    int argb = image[y * w + x];
                    int _a = argb >> 24 & 0xFF;
                    a += (long)_a;
                    r += (long)((argb >> 16 & 0xFF) * _a);
                    g += (long)((argb >> 8 & 0xFF) * _a);
                    b += (long)((argb >> 0 & 0xFF) * _a);
                }
            }
            if (a == 0L) {
                return 0xFF00FF;
            }
            double d = 1.0 / (double)a;
            r = Math.min(255, Math.max(0, (int)((double)r * d)));
            g = Math.min(255, Math.max(0, (int)((double)g * d)));
            b = Math.min(255, Math.max(0, (int)((double)b * d)));
            return (int)((a /= (long)image.length) << 24 | r << 16 | g << 8 | b);
        }
        return 0xFF00FF;
    }

    private static String getBlockTexture(Block block) {
        for (Class<?> clazz = block.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getMethods()) {
                if (m.getReturnType() != String.class || m.getParameterTypes().length != 0 || !m.getName().equals("getTextureFile")) continue;
                try {
                    return (String)m.invoke((Object)block, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    protected static final int calcPointer(int id, int meta) {
        assert (id >= 0 && id < 4096);
        assert (meta >= 0 && meta < 16);
        return id << 4 | meta;
    }

    private static boolean isPlasmaCraftFluidBlock(Block block) {
        assert (block != null);
        String className = block.getClass().getName();
        return className.equals("Plasmacraft.BlockCausticStationary") || className.equals("Plasmacraft.BlockCausticFlowing");
    }

    private static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ':' + base + name;
        }
        return base + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        height = new float[65536];
        blockColorData = new BlockData[65536];
        defaultBlockColor = null;
        referenceThread = new AtomicReference();
        HashMap<BlockData, BlockData> blockDataMap = new HashMap<BlockData, BlockData>();
        BlockAccess blockAccess = new BlockAccess();
        BlockAir air = (BlockAir)Block.func_149684_b((String)"air");
        BlockLeaves leaves = (BlockLeaves)Block.func_149684_b((String)"leaves");
        BlockPistonExtension pistonExtension = (BlockPistonExtension)Block.func_149684_b((String)"piston_head");
        BlockCrops crops = (BlockCrops)Block.func_149684_b((String)"wheat");
        BlockGrass grass = (BlockGrass)Block.func_149684_b((String)"grass");
        BlockTallGrass tallGrass = (BlockTallGrass)Block.func_149684_b((String)"tallgrass");
        BlockIce ice = (BlockIce)Block.func_149684_b((String)"ice");
        leaves.func_150122_b(true);
        boolean var1 = false;
        try {
            var1 = true;
            for (int id = 0; id < 4096; ++id) {
                Block block = Block.func_149729_e((int)id);
                if (block == null || block == air) continue;
                blockAccess.block = block;
                int renderType = block.func_149645_b();
                int renderPass = block.func_149701_w();
                try {
                    for (int meta = 0; meta < 16; ++meta) {
                        String textureName;
                        int ptr;
                        Object extend = null;
                        int exmeta = meta;
                        if (block == pistonExtension) {
                            int n = exmeta = (meta & 7) >= 6 ? 108 : meta;
                        }
                        if (block == crops && meta >= 8) {
                            ptr = BlockDataPack.calcPointer(id, meta);
                            BlockDataPack.blockColorData[ptr] = blockColorData[ptr & 0xFFFFFFFF];
                            continue;
                        }
                        blockAccess.blockMetadata = meta;
                        ptr = BlockDataPack.calcPointer(id, meta);
                        try {
                            block.func_149719_a((IBlockAccess)blockAccess, 0, 0, 0);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        BlockDataPack.height[ptr] = (float)block.func_149669_A();
                        boolean redstoneTorch = block instanceof BlockRedstoneTorch;
                        IIcon icon = null;
                        try {
                            icon = block.func_149735_b(redstoneTorch ? 0 : 1, exmeta);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (block instanceof BlockRedstoneWire) {
                            icon = BlockRedstoneWire.func_150173_e((String)"redstoneDust_cross");
                        } else if (block instanceof BlockDoor) {
                            icon = block.func_149673_e((IBlockAccess)blockAccess, 0, 0, 0, 0);
                        }
                        if (icon == null || (textureName = icon.func_94215_i()) == null) continue;
                        if (block == grass) {
                            extend = BlockType.GRASS;
                        } else if (block == leaves) {
                            switch (meta & 3) {
                                default: {
                                    extend = BlockType.FOLIAGE;
                                    break;
                                }
                                case 1: {
                                    extend = BlockType.FOLIAGE_PINE;
                                    break;
                                }
                                case 2: {
                                    extend = BlockType.FOLIAGE_BIRCH;
                                    break;
                                }
                            }
                        } else if (block == tallGrass && meta != 0) {
                            extend = BlockType.SIMPLE_GRASS;
                        } else if (block == ice) {
                            extend = BlockType.ICE;
                        }
                        float minX = (float)block.func_149704_x();
                        float minY = (float)block.func_149665_z();
                        float minZ = (float)block.func_149706_B();
                        float maxX = (float)block.func_149753_y();
                        float maxY = (float)block.func_149669_A();
                        float maxZ = (float)block.func_149693_C();
                        switch (renderType) {
                            case -1: {
                                extend = block;
                            }
                            default: {
                                break;
                            }
                            case 4: {
                                BlockDataPack.height[ptr] = Math.max(0.0f, 1.0f - (float)(meta + 1) / 9.0f);
                                extend = block;
                                break;
                            }
                            case 5: {
                                extend = meta;
                                break;
                            }
                            case 10: {
                                BlockDataPack.height[ptr] = (meta & 4) == 0 ? 0.75f : 1.0f;
                                break;
                            }
                            case 16: {
                                extend = meta;
                                break;
                            }
                            case 17: {
                                extend = meta;
                                break;
                            }
                            case 19: {
                                extend = Math.min(7, meta);
                                break;
                            }
                            case 24: {
                                BlockDataPack.height[ptr] = (float)(2656 + 432 * Math.min(3, meta)) / 256.0f;
                                extend = Math.min(3, meta);
                                break;
                            }
                            case 25: {
                                BlockDataPack.height[ptr] = 0.2f;
                                extend = meta & 7;
                                break;
                            }
                            case 26: {
                                boolean temp = BlockEndPortalFrame.func_150020_b((int)meta);
                                if (temp) {
                                    BlockDataPack.height[ptr] = 0.859375f;
                                }
                                extend = temp;
                            }
                        }
                        BlockData var54 = new BlockData(renderType, renderPass, textureName, minX, minY, minZ, maxX, maxY, maxZ, extend);
                        BlockData bd = (BlockData)blockDataMap.get(var54);
                        if (bd == null) {
                            bd = var54;
                            blockDataMap.put(bd, bd);
                        }
                        BlockDataPack.blockColorData[ptr] = bd;
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    continue;
                }
            }
            var1 = false;
        }
        finally {
            if (var1) {
                try {
                    BlockLeaves bl = (BlockLeaves)Block.func_149684_b((String)"leaves");
                    bl.func_150122_b(Minecraft.func_71410_x().field_71474_y.field_74347_j);
                }
                catch (Exception e) {}
            }
        }
        try {
            BlockLeaves bl = (BlockLeaves)Block.func_149684_b((String)"leaves");
            bl.func_150122_b(Minecraft.func_71410_x().field_71474_y.field_74347_j);
        }
        catch (Exception e) {
            // empty catch block
        }
        blockData = blockDataMap.keySet().toArray(new BlockData[blockDataMap.size()]);
        Arrays.sort(blockData);
    }
}

