/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.util.HashMap;

public class BiomeData {
    public static final HashMap<String, BiomeData> biomeMap = new HashMap();
    public static final int[] sortedBiomes = new int[]{0, 24, 10, 7, 11, 16, 26, 25, 1, 129, 4, 18, 132, 27, 28, 29, 5, 19, 32, 33, 160, 161, 30, 31, 12, 13, 3, 20, 34, 162, 6, 134, 21, 22, 23, 35, 36, 2, 17, 37, 38, 39, 167, 166, 165, 14, 15};
    public static final BiomeData[] biomes = new BiomeData[256];
    public static final BiomeData ocean = new BiomeData("Ocean", 0, new int[]{0, 0, 112});
    public static final BiomeData plains = new BiomeData("Plains", 1, new int[]{121, 179, 96});
    public static final BiomeData desert = new BiomeData("Desert", 2, new int[]{247, 233, 163});
    public static final BiomeData extremeHills = new BiomeData("Extreme Hills", 3, new int[]{120, 142, 120});
    public static final BiomeData forest = new BiomeData("Forest", 4, new int[]{5, 102, 32});
    public static final BiomeData taiga = new BiomeData("Taiga", 5, new int[]{42, 107, 79});
    public static final BiomeData swampland = new BiomeData("Swampland", 6, new int[]{50, 141, 129});
    public static final BiomeData river = new BiomeData("River", 7, new int[]{0, 0, 255});
    public static final BiomeData hell = new BiomeData("Hell", 8, new int[]{128, 0, 0});
    public static final BiomeData sky = new BiomeData("Sky", 9, new int[]{128, 128, 192});
    public static final BiomeData frozenOcean = new BiomeData("Frozen Ocean", 10, new int[]{144, 144, 160});
    public static final BiomeData frozenRiver = new BiomeData("Frozen River", 11, new int[]{160, 160, 255});
    public static final BiomeData icePlains = new BiomeData("Ice Plains", 12, new int[]{255, 255, 255});
    public static final BiomeData iceMountains = new BiomeData("Ice Mountains", 13, new int[]{220, 220, 220});
    public static final BiomeData mushroomIsland = new BiomeData("Mushroom Island", 14, new int[]{120, 90, 150});
    public static final BiomeData mushroomIslandShore = new BiomeData("Mushroom Island Shore", 15, new int[]{105, 78, 130});
    public static final BiomeData beach = new BiomeData("Beach", 16, new int[]{250, 222, 85});
    public static final BiomeData desertHills = new BiomeData("Desert Hills", 17, new int[]{214, 199, 141});
    public static final BiomeData forestHills = new BiomeData("Forest Hills", 18, new int[]{4, 84, 28});
    public static final BiomeData taigaHills = new BiomeData("Taiga Hills", 19, new int[]{33, 84, 62});
    public static final BiomeData extremeHillsEdge = new BiomeData("Extreme Hills Edge", 20, new int[]{120, 132, 120});
    public static final BiomeData jungle = new BiomeData("Jungle", 21, new int[]{121, 178, 14});
    public static final BiomeData jungleHills = new BiomeData("Jungle Hills", 22, new int[]{105, 155, 12});
    public static final BiomeData jungleEdge = new BiomeData("Jungle Edge", 23, new int[]{98, 140, 24});
    public static final BiomeData deepOcean = new BiomeData("Deep Ocean", 24, new int[]{0, 0, 78});
    public static final BiomeData stoneBeach = new BiomeData("Stone Beach", 25, new int[]{162, 162, 132});
    public static final BiomeData coldBeach = new BiomeData("Cold Beach", 26, new int[]{250, 240, 192});
    public static final BiomeData birchForest = new BiomeData("Birch Forest", 27, new int[]{74, 125, 70});
    public static final BiomeData birchForestHills = new BiomeData("Birch Forest Hills", 28, new int[]{60, 99, 56});
    public static final BiomeData roofedForest = new BiomeData("Roofed Forest", 29, new int[]{64, 94, 26});
    public static final BiomeData coldTaiga = new BiomeData("Cold Taiga", 30, new int[]{88, 102, 80});
    public static final BiomeData coldTaigaHills = new BiomeData("Cold Taiga Hills", 31, new int[]{69, 79, 62});
    public static final BiomeData megaTaiga = new BiomeData("Mega Taiga", 32, new int[]{49, 85, 74});
    public static final BiomeData megaTaigaHills = new BiomeData("Mega Taiga Hills", 33, new int[]{36, 63, 54});
    public static final BiomeData extremeHillsPlus = new BiomeData("Extreme Hills+", 34, new int[]{136, 156, 136});
    public static final BiomeData savanna = new BiomeData("Savanna", 35, new int[]{178, 190, 95});
    public static final BiomeData savannaPlateau = new BiomeData("Savanna Plateau", 36, new int[]{157, 167, 84});
    public static final BiomeData mesa = new BiomeData("Mesa", 37, new int[]{185, 99, 44});
    public static final BiomeData mesaPlateauF = new BiomeData("Mesa Plateau F", 38, new int[]{135, 94, 36});
    public static final BiomeData mesaPlateau = new BiomeData("Mesa Plateau", 39, new int[]{170, 90, 41});
    public static final BiomeData sunflowerPlains = new BiomeData("Sunflower Plains", 129, new int[]{142, 207, 111});
    public static final BiomeData desertM = new BiomeData("Desert M", 130, new int[]{255, 247, 174});
    public static final BiomeData extremeHillsM = new BiomeData("Extreme Hills M", 131, new int[]{91, 102, 91});
    public static final BiomeData flowerForest = new BiomeData("Flower Forest", 132, new int[]{46, 142, 74});
    public static final BiomeData taigaM = new BiomeData("Taiga M", 133, new int[]{50, 142, 28});
    public static final BiomeData swamplandM = new BiomeData("Swampland M", 134, new int[]{44, 126, 115});
    public static final BiomeData icePlainsSpikes = new BiomeData("Ice Plains Spikes", 140, new int[]{190, 232, 232});
    public static final BiomeData jungleM = new BiomeData("Jungle M", 149, new int[]{123, 163, 49});
    public static final BiomeData jungleEdgeM = new BiomeData("Jungle Edge M", 151, new int[]{140, 179, 64});
    public static final BiomeData birchForestM = new BiomeData("Birch Forest M", 155, new int[]{80, 135, 76});
    public static final BiomeData birchForestHillsM = new BiomeData("Birch Forest Hills M", 156, new int[]{64, 107, 61});
    public static final BiomeData roofedForestM = new BiomeData("Roofed Forest M", 157, new int[]{72, 104, 29});
    public static final BiomeData coldTaigaM = new BiomeData("Cold Taiga M", 158, new int[]{60, 67, 55});
    public static final BiomeData megaSpruceTaiga = new BiomeData("Mega Spruce Taiga", 160, new int[]{43, 74, 64});
    public static final BiomeData megaSpruceTaigaHills = new BiomeData("Mega Spruce Taiga (Hills)", 161, new int[]{32, 60, 52});
    public static final BiomeData extremeHillsPlusM = new BiomeData("Extreme Hills+ M", 162, new int[]{109, 121, 109});
    public static final BiomeData savannaM = new BiomeData("Savanna M", 163, new int[]{141, 150, 75});
    public static final BiomeData savannaPlateauM = new BiomeData("Savanna Plateau M", 164, new int[]{127, 135, 70});
    public static final BiomeData mesaBryce = new BiomeData("Mesa (Bryce)", 165, new int[]{221, 117, 55});
    public static final BiomeData mesaPlateauFM = new BiomeData("Mesa Plateau F M", 166, new int[]{124, 64, 29});
    public static final BiomeData mesaPlateauM = new BiomeData("Mesa Plateau M", 167, new int[]{150, 79, 36});
    public String name;
    public int index;
    public int color;

    public BiomeData(String name, int index, int[] color) {
        BiomeData.biomes[index] = this;
        this.name = name;
        this.index = index;
        this.color = (color[0] << 16) + (color[1] << 8) + color[2];
        biomeMap.put(name, this);
    }

    public BiomeData(String name, int index, int r, int g, int b) {
        this(name, index, new int[]{r, g, b});
    }

    public static int getColor(String name) {
        BiomeData biome = biomeMap.get(name);
        if (biome != null) {
            return biome.color;
        }
        return -1;
    }

    public static int getColor(int index) {
        BiomeData biome = biomes[index];
        if (biome != null) {
            return biome.color;
        }
        return -1;
    }

    public String toString() {
        return "[Biome " + this.name + "]";
    }

    public static int indexFromName(String name) {
        BiomeData biome = biomeMap.get(name);
        if (biome != null) {
            return biome.index;
        }
        return -1;
    }
}

