/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.tileentity;

import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ruby.bamboo.BambooInit;
import ruby.bamboo.block.BlockMultiPot;

public class TileEntityMultiPot
extends TileEntity {
    public static final int MAX_LENGTH = 9;
    private boolean[] matrix = new boolean[9];
    private ItemStack[] slots = new ItemStack[9];
    public static final int SQ = (int)Math.sqrt(9.0);

    public TileEntityMultiPot() {
        Arrays.fill(this.matrix, false);
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound slotNBT = new NBTTagCompound();
            slotNBT.func_74757_a("matrix", this.matrix[i]);
            if (this.matrix[i] && this.slots[i] != null) {
                NBTTagCompound itemNBT = new NBTTagCompound();
                this.slots[i].func_77955_b(itemNBT);
                slotNBT.func_74782_a("itemNBT", (NBTBase)itemNBT);
            }
            list.func_74742_a((NBTBase)slotNBT);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound slotNBT = list.func_150305_b(i);
            this.matrix[i] = slotNBT.func_74767_n("matrix");
            if (!this.matrix[i]) continue;
            if (slotNBT.func_74764_b("itemNBT")) {
                NBTTagCompound itemNBT = (NBTTagCompound)slotNBT.func_74781_a("itemNBT");
                if (this.slots[i] != null) {
                    this.slots[i].func_77963_c(itemNBT);
                    continue;
                }
                this.slots[i] = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
                continue;
            }
            this.slots[i] = null;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static int getSlotPositionNumber(float hitX, float hitZ, ForgeDirection fd) {
        float offset = 1.0f / (float)SQ / 2.0f;
        int res = (int)((float)SQ * (hitX += (float)fd.offsetX * offset)) + (int)((float)SQ * (hitZ += (float)fd.offsetZ * offset)) * SQ;
        return res < 9 ? res : 8;
    }

    public void addSlot(int num) {
        this.matrix[num] = true;
        this.func_70296_d();
    }

    public ItemStack removeSlot(int num) {
        ItemStack res = null;
        if (this.matrix[num]) {
            res = this.removeItemOnSlotNumber(num);
            this.matrix[num] = false;
            this.func_70296_d();
        }
        return res;
    }

    public void setItemOnSlotNumber(int slotNum, Item item, int meta) {
        if (this.matrix[slotNum]) {
            this.slots[slotNum] = new ItemStack(item, 1, meta);
        }
        this.func_70296_d();
    }

    public ItemStack removeItemOnSlotNumber(int slotNum) {
        ItemStack res = null;
        if (this.matrix[slotNum]) {
            if (this.slots[slotNum] != null) {
                res = this.slots[slotNum];
            }
            this.slots[slotNum] = null;
        }
        return res;
    }

    public Item getFlowerPotItem(int slotNum) {
        Item item = null;
        if (slotNum < 9 && this.slots[slotNum] != null) {
            item = this.slots[slotNum].func_77973_b();
        }
        return item;
    }

    public int getFlowerPotData(int slotNum) {
        int meta = 0;
        if (slotNum < 9 && this.slots[slotNum] != null) {
            meta = this.slots[slotNum].func_77960_j();
        }
        return meta;
    }

    public boolean isEnable(int slotNum) {
        return this.matrix[slotNum];
    }

    public void dropAllItems(World world) {
        if (!world.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                if (!this.matrix[i]) continue;
                ((BlockMultiPot)BambooInit.multiPot).func_149642_a(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(BambooInit.multiPot));
                if (this.slots[i] == null) continue;
                ((BlockMultiPot)BambooInit.multiPot).func_149642_a(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots[i]);
            }
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (!this.matrix[i]) continue;
            return false;
        }
        return true;
    }
}

