/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMultiBlock
extends TileEntity
implements IBlockAccess {
    private byte slotLength;
    private ItemStack[][][] slots;
    private float[] posPartition;
    private byte[][][] sideRenderCache;
    private static HashMap<Byte, float[]> renderOffsetCache;

    public TileEntityMultiBlock() {
        this.setSlotLength((byte)1);
    }

    public void setSlotLength(byte len) {
        if (len < 1 || 16 < len) {
            len = (byte)3;
        }
        this.slotLength = len;
        this.setPosPatition();
        this.slots = new ItemStack[this.slotLength][this.slotLength][this.slotLength];
    }

    private void setPosPatition() {
        float[] tmp = new float[this.slotLength];
        for (int i = 0; i < this.slotLength; ++i) {
            tmp[i] = 1.0f / (float)this.slotLength * (float)(i + 1);
        }
        this.posPartition = tmp;
    }

    public byte getFieldSize() {
        return this.slotLength;
    }

    public float[] getRenderOffset() {
        if (renderOffsetCache == null) {
            renderOffsetCache = new HashMap();
        }
        if (renderOffsetCache.containsKey(this.slotLength)) {
            return renderOffsetCache.get(this.slotLength);
        }
        float[] o = new float[this.slotLength];
        float offset = 1.0f / (float)this.slotLength;
        for (int i = 0; i < this.slotLength; ++i) {
            o[i] = (float)i * offset;
        }
        renderOffsetCache.put(this.slotLength, o);
        return o;
    }

    public Block getInnerBlock(int x, int y, int z) {
        Block res = Blocks.field_150350_a;
        if (this.isInnerRange(x, y, z) && this.slots[x][y][z] != null) {
            res = Block.func_149634_a((Item)this.slots[x][y][z].func_77973_b());
        }
        return res;
    }

    public int getInnerMeta(int x, int y, int z) {
        int res = 0;
        if (this.isInnerRange(x, y, z) && this.slots[x][y][z] != null) {
            res = this.slots[x][y][z].func_77960_j();
        }
        return res;
    }

    public ItemStack getInnerItemStack(int x, int y, int z) {
        return this.isInnerRange(x, y, z) ? this.slots[x][y][z] : null;
    }

    public boolean isExist(int x, int y, int z) {
        if (this.isInnerRange(x, y, z)) {
            return this.slots[x][y][z] != null;
        }
        return false;
    }

    public Block getOffsetedInnerBlock(int x, int y, int z, ForgeDirection fd) {
        return this.getInnerBlock(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ);
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.slotLength; ++x) {
            for (int y = 0; y < this.slotLength; ++y) {
                for (int z = 0; z < this.slotLength; ++z) {
                    if (this.slots[x][y][z] == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean setInnerBlock(World world, float hitX, float hitY, float hitZ, int side, ItemStack is) {
        byte[] innerPos = this.getInnerPos(hitX, hitY, hitZ, side);
        if (this.isInnerRange(innerPos[0], innerPos[1], innerPos[2]) && this.getInnerBlock(innerPos[0], innerPos[1], innerPos[2]) == Blocks.field_150350_a) {
            is.field_77994_a = 1;
            this.setInnerSlot(innerPos[0], innerPos[1], innerPos[2], is);
            return true;
        }
        return false;
    }

    public ItemStack removeInnerBlock(float hitX, float hitY, float hitZ, int side) {
        byte[] innerPos = this.getInnerPos(hitX, hitY, hitZ, ForgeDirection.OPPOSITES[side]);
        ItemStack res = this.getInnerItemStack(innerPos[0], innerPos[1], innerPos[2]);
        if (res != null) {
            res.func_77964_b(Block.func_149634_a((Item)res.func_77973_b()).func_149692_a(res.func_77960_j()));
            this.removeInnerSlot(innerPos[0], innerPos[1], innerPos[2]);
        }
        return res;
    }

    public void setInnerSlot(byte innerX, byte innerY, byte innerZ, ItemStack is) {
        if (this.isInnerRange(innerX, innerY, innerZ)) {
            this.slots[innerX][innerY][innerZ] = is;
            this.func_70296_d();
        }
    }

    public void removeInnerSlot(byte innerX, byte innerY, byte innerZ) {
        if (this.isInnerRange(innerX, innerY, innerZ)) {
            this.slots[innerX][innerY][innerZ] = null;
            this.func_70296_d();
        }
    }

    private byte[] getInnerPos(float hitX, float hitY, float hitZ, int side) {
        byte innerX = this.slotLength;
        byte innerY = this.slotLength;
        byte innerZ = this.slotLength;
        ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[side];
        float offset = 1.0f / (float)this.getFieldSize() / 2.0f;
        hitX += (float)fd.offsetX * offset;
        hitY += (float)fd.offsetY * offset;
        hitZ += (float)fd.offsetZ * offset;
        for (byte i = 0; i < this.posPartition.length; i = (byte)((byte)(i + 1))) {
            if (innerX == this.slotLength && hitX < this.posPartition[i]) {
                innerX = i;
            }
            if (innerY == this.slotLength && hitY < this.posPartition[i]) {
                innerY = i;
            }
            if (innerZ != this.slotLength || !(hitZ < this.posPartition[i])) continue;
            innerZ = i;
        }
        return new byte[]{innerX, innerY, innerZ};
    }

    private boolean isInnerRange(int x, int y, int z) {
        return 0 <= x && 0 <= y && 0 <= z && x < this.slotLength && y < this.slotLength && z < this.slotLength;
    }

    @SideOnly(value=Side.CLIENT)
    public byte[][][] getVisibleFlg() {
        if (this.sideRenderCache != null) {
            return this.sideRenderCache;
        }
        this.sideRenderCache = this.getSideRender();
        return this.sideRenderCache;
    }

    /*
     * Unable to fully structure code
     */
    public byte[][][] getSideRender() {
        flgs = new byte[this.slotLength][this.slotLength][this.slotLength];
        outerOpaqueCubeFlgs = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            outerOpaqueCubeFlgs[fd.ordinal()] = this.func_145831_w().func_147439_a(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ).func_149662_c();
        }
        for (x = 0; x < this.slotLength; ++x) {
            for (y = 0; y < this.slotLength; ++y) {
                for (z = 0; z < this.slotLength; ++z) {
                    if (this.getInnerBlock(x, y, z) == Blocks.field_150350_a) continue;
                    block12: for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                        switch (1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[fd.ordinal()]) {
                            case 1: {
                                if (y == 0 && outerOpaqueCubeFlgs[fd.ordinal()]) {
                                    continue block12;
                                }
                                ** GOTO lbl34
                            }
                            case 2: {
                                if (x == this.slotLength - 1 && outerOpaqueCubeFlgs[fd.ordinal()]) {
                                    continue block12;
                                }
                                ** GOTO lbl34
                            }
                            case 3: {
                                if (z == 0 && outerOpaqueCubeFlgs[fd.ordinal()]) {
                                    continue block12;
                                }
                                ** GOTO lbl34
                            }
                            case 4: {
                                if (z == this.slotLength - 1 && outerOpaqueCubeFlgs[fd.ordinal()]) {
                                    continue block12;
                                }
                                ** GOTO lbl34
                            }
                            case 5: {
                                if (y == this.slotLength - 1 && outerOpaqueCubeFlgs[fd.ordinal()]) {
                                    continue block12;
                                }
                                ** GOTO lbl34
                            }
                            case 6: {
                                if (x == 0 && outerOpaqueCubeFlgs[fd.ordinal()]) continue block12;
                            }
lbl34:
                            // 7 sources

                            default: {
                                if (this.getOffsetedInnerBlock(x, y, z, fd).func_149662_c() || this.getOffsetedInnerBlock(x, y, z, fd) == this.getInnerBlock(x, y, z)) continue block12;
                                v0 = flgs[x][y];
                                v1 = z;
                                v0[v1] = (byte)(v0[v1] | 1 << fd.ordinal());
                            }
                        }
                    }
                }
            }
        }
        return flgs;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeToSlotNBT(nbt);
    }

    public void writeToSlotNBT(NBTTagCompound nbt) {
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        NBTTagCompound parser = new NBTTagCompound();
        for (int i = 0; i < this.slotLength; ++i) {
            for (int j = 0; j < this.slotLength; ++j) {
                for (int k = 0; k < this.slotLength; ++k) {
                    NBTTagCompound slotNBT = this.slots[i][j][k] != null ? this.slots[i][j][k].func_77955_b(new NBTTagCompound()) : parser;
                    list.func_74742_a((NBTBase)slotNBT);
                }
            }
        }
        nbt.func_74774_a("this.slotLength", this.slotLength);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readFromSlotNBT(nbt);
    }

    public void readFromSlotNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("this.slotLength")) {
            this.setSlotLength(nbt.func_74771_c("this.slotLength"));
        }
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        int count = 0;
        for (int i = 0; i < this.slotLength; ++i) {
            for (int j = 0; j < this.slotLength; ++j) {
                for (int k = 0; k < this.slotLength; ++k) {
                    NBTTagCompound slotNBT;
                    if (!(slotNBT = list.func_150305_b(count++)).func_74764_b("id")) continue;
                    if (this.slots[i][j][k] != null) {
                        this.slots[i][j][k].func_77963_c(slotNBT);
                        continue;
                    }
                    this.slots[i][j][k] = ItemStack.func_77949_a((NBTTagCompound)slotNBT);
                }
            }
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.writeToSlotNBT(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromSlotNBT(pkt.func_148857_g());
        this.sideRenderCache = null;
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public List<ItemStack> getInnnerBlocks() {
        HashMap temp = new HashMap();
        for (int i = 0; i < this.slotLength; ++i) {
            for (int j = 0; j < this.slotLength; ++j) {
                for (int k = 0; k < this.slotLength; ++k) {
                    HashMap innerMap;
                    if (this.slots[i][j][k] == null) continue;
                    if (!temp.containsKey(this.slots[i][j][k].func_77973_b())) {
                        temp.put(this.slots[i][j][k].func_77973_b(), new HashMap());
                    }
                    if ((innerMap = (HashMap)temp.get(this.slots[i][j][k].func_77973_b())).containsKey(this.slots[i][j][k].func_77960_j())) {
                        innerMap.put(this.slots[i][j][k].func_77960_j(), (Integer)innerMap.get(this.slots[i][j][k].func_77960_j()) + 1);
                        continue;
                    }
                    innerMap.put(this.slots[i][j][k].func_77960_j(), 1);
                }
            }
        }
        ArrayList<ItemStack> res = new ArrayList<ItemStack>(temp.size());
        for (Item item : temp.keySet()) {
            Iterator i$ = ((HashMap)temp.get(item)).keySet().iterator();
            while (i$.hasNext()) {
                int dmg = (Integer)i$.next();
                res.add(new ItemStack(item, ((Integer)((HashMap)temp.get(item)).get(dmg)).intValue(), Block.func_149634_a((Item)item).func_149692_a(dmg)));
            }
        }
        return res;
    }

    public Block func_147439_a(int var1, int var2, int var3) {
        return this.getInnerBlock(var1, var2, var3);
    }

    public TileEntity func_147438_o(int var1, int var2, int var3) {
        return this;
    }

    public int func_72802_i(int var1, int var2, int var3, int var4) {
        return this.func_145831_w().func_72802_i(this.field_145851_c, this.field_145848_d, this.field_145849_e, var4);
    }

    public int func_72805_g(int var1, int var2, int var3) {
        return this.getInnerMeta(var1, var2, var3);
    }

    public boolean func_147437_c(int var1, int var2, int var3) {
        return this.getInnerBlock(var1, var2, var3) == Blocks.field_150350_a;
    }

    public BiomeGenBase func_72807_a(int var1, int var2) {
        return this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
    }

    public int func_72800_K() {
        return this.field_145850_b.func_72800_K();
    }

    public boolean func_72806_N() {
        return this.field_145850_b.func_72806_N();
    }

    public int func_72879_k(int var1, int var2, int var3, int var4) {
        return this.field_145850_b.func_72879_k(var1, var2, var3, var4);
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return this.field_145850_b.isSideSolid(x, y, z, side, _default);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$minecraftforge$common$util$ForgeDirection;

        static {
            $SwitchMap$net$minecraftforge$common$util$ForgeDirection = new int[ForgeDirection.values().length];
            try {
                1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[ForgeDirection.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[ForgeDirection.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[ForgeDirection.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[ForgeDirection.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[ForgeDirection.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$minecraftforge$common$util$ForgeDirection[ForgeDirection.WEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

