/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item.enchant;

import cpw.mods.fml.common.FMLLog;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import ruby.bamboo.item.enchant.BambooEnchantment;

public abstract class EnchantBase {
    final int id;
    final String name;
    final int maxLevel;
    final float weight;
    final float tp;
    static final Random rand = new Random();

    public EnchantBase(int id, String name, int maxLevel, float weight, float tp) {
        this.id = id;
        this.name = name;
        this.maxLevel = maxLevel;
        this.weight = weight;
        this.tp = tp;
        if (!BambooEnchantment.idToEnchantMap.containsKey(id)) {
            BambooEnchantment.idToEnchantMap.put((short)id, this);
        } else {
            FMLLog.warning((String)("[BambooMod] EnchantId Collision:" + id), (Object[])new Object[0]);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getTriggerPercent(int enchantLvl) {
        return this.tp;
    }

    public void activate(ItemStack itemStack, World world, int posX, int posY, int posZ, EntityLivingBase entity, int enchantLvl) {
        if (rand.nextFloat() < this.getTriggerPercent(enchantLvl)) {
            this.effect(itemStack, world, posX, posY, posZ, entity, enchantLvl);
        }
    }

    void effect(ItemStack itemStack, World world, int posX, int posY, int posZ, EntityLivingBase entity, int enchantLvl) {
    }

    void onUpdate(ItemStack itemStack, World world, Entity entity) {
    }
}

