/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ruby.bamboo.CustomRenderHandler;
import ruby.bamboo.block.BlockPillar;
import ruby.bamboo.block.IPillarRender;

public abstract class BlockLiangBase
extends Block
implements IPillarRender {
    @SideOnly(value=Side.CLIENT)
    IIcon[] icons;
    private final float minWidth;
    private final float maxWidth;
    private final float minHeight;
    private final float maxHeight;
    private int renderSide;

    public BlockLiangBase(float minWidth, float maxWidth, float minHeight, float maxHeight) {
        super(Material.field_151575_d);
        this.func_149711_c(0.2f);
        this.func_149752_b(1.0f);
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this.func_149691_a(par5, par1IBlockAccess.func_72805_g(par2, par3, par4));
    }

    public IIcon func_149691_a(int par1, int par2) {
        return this.icons[par2 % this.icons.length];
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return CustomRenderHandler.pillarUID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1Item, CreativeTabs par2Tab, List par3List) {
        for (int i = 0; i < this.icons.length; ++i) {
            par3List.add(new ItemStack(par1Item, 1, i));
        }
    }

    @Override
    public boolean setUpBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.UP, par2, par3, par4) : this);
        this.func_149676_a(block.getMinWidth(), block.getMaxHeight(), block.getMinWidth(), block.getMaxWidth(), 1.0f, block.getMaxWidth());
        return true;
    }

    @Override
    public boolean setDownBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.DOWN, par2, par3, par4) : this);
        this.func_149676_a(block.getMinWidth(), 0.0f, block.getMinWidth(), block.getMaxWidth(), block.getMinHeight(), block.getMaxWidth());
        return true;
    }

    @Override
    public boolean setSouthBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.SOUTH, par2, par3, par4) : this);
        this.func_149676_a(block.getMinWidth(), block.getMinHeight(), block.getMaxWidth(), block.getMaxWidth(), block.getMaxHeight(), 1.0f);
        return true;
    }

    @Override
    public boolean setNorthBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.NORTH, par2, par3, par4) : this);
        this.func_149676_a(block.getMinWidth(), block.getMinHeight(), 0.0f, block.getMaxWidth(), block.getMaxHeight(), block.getMinWidth());
        return true;
    }

    @Override
    public boolean setEastBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.EAST, par2, par3, par4) : this);
        this.func_149676_a(block.getMaxWidth(), block.getMinHeight(), block.getMinWidth(), 1.0f, block.getMaxHeight(), block.getMaxWidth());
        return true;
    }

    @Override
    public boolean setWestBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.WEST, par2, par3, par4) : this);
        this.func_149676_a(0.0f, block.getMinHeight(), block.getMinWidth(), block.getMinWidth(), block.getMaxHeight(), block.getMaxWidth());
        return true;
    }

    @Override
    public boolean isLink(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, ForgeDirection fd) {
        Block offsetBlock = par1IBlockAccess.func_147439_a(par2 + fd.offsetX, par3 + fd.offsetY, par4 + fd.offsetZ);
        return offsetBlock.func_149721_r() || !(offsetBlock instanceof BlockPillar) && (offsetBlock.func_149688_o() == Material.field_151575_d || offsetBlock.func_149688_o() == Material.field_151578_c);
    }

    @Override
    public void setRenderSide(int side) {
        this.renderSide = side;
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Block block = par1IBlockAccess.func_147439_a(par2, par3, par4);
        if (this.renderSide == par5) {
            return true;
        }
        return block == null || block != this;
    }

    @Override
    public void setCoreBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.func_149676_a(this.minWidth, this.minHeight, this.minWidth, this.maxWidth, this.maxHeight, this.maxWidth);
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int side, float hitX, float hitY, float hitZ, int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void func_149651_a(IIconRegister var1);

    private Block getOffsettedBlock(IBlockAccess iBlockAccess, ForgeDirection fd, int posX, int posY, int posZ) {
        return iBlockAccess.func_147439_a(posX + fd.offsetX, posY + fd.offsetY, posZ + fd.offsetZ);
    }

    public void func_149683_g() {
        this.func_149676_a(this.minWidth, this.minHeight, this.minWidth, this.maxWidth, this.maxHeight, this.maxWidth);
    }

    public AxisAlignedBB func_149668_a(World world, int posX, int posY, int posZ) {
        return AxisAlignedBB.func_72330_a((double)posX, (double)posY, (double)posZ, (double)(posX + 1), (double)(posY + 1), (double)(posZ + 1));
    }

    @Override
    public float getSize() {
        return this.maxWidth - this.minWidth;
    }

    @Override
    public float getMinWidth() {
        return this.minWidth;
    }

    @Override
    public float getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public float getMinHeight() {
        return this.minHeight;
    }

    @Override
    public float getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public boolean isLinkSkipp() {
        return false;
    }

    @Override
    public boolean canDifferentMetaLink(int meta1, int meta2) {
        return false;
    }

    public int func_149692_a(int par1) {
        return par1;
    }
}

