/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import ruby.bamboo.BambooInit;
import ruby.bamboo.BambooUtil;
import ruby.bamboo.block.IExOnBLockPlacedBy;

public class BlockDecoPlaster
extends Block
implements IExOnBLockPlacedBy {
    private IIcon[] icons = new IIcon[4];
    private EnumPattern pattern;

    public BlockDecoPlaster(EnumPattern pattern) {
        super(Material.field_151578_c);
        this.pattern = pattern;
        this.func_149711_c(0.2f);
        this.func_149752_b(1.0f);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack is = player.func_71045_bC();
        if (is != null && is.func_77973_b() == BambooInit.itembamboo) {
            int meta = world.func_72805_g(x, y, z) & 3;
            int sideMeta = side / 2 << 2;
            world.func_72921_c(x, y, z, sideMeta | ((meta & 3) < 3 ? meta + 1 : meta - 3), 2);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        for (int i = 0; i < 4; ++i) {
            this.icons[i] = p_149651_1_.func_94245_a("bamboo:" + this.func_149641_N() + "_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side / 2 != meta >> 2) {
            return BambooInit.decoration.func_149691_a(0, 0);
        }
        return this.icons[this.pattern.getPattern()[meta & 3][side] % 4];
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, EntityLivingBase entity, ItemStack itemStack, int meta) {
        byte playerDir = BambooUtil.getPlayerDir((Entity)entity);
        int sideMeta = 1;
        if (playerDir == 1 || playerDir == 3) {
            sideMeta = 2;
        }
        world.func_72921_c(x, y, z, sideMeta << 2, 2);
    }

    public static enum EnumPattern {
        straight(new byte[][]{{0, 0, 0, 2, 2, 0}, {1, 1, 1, 1, 1, 1}, {2, 2, 2, 0, 0, 2}, {3, 3, 3, 3, 3, 3}}),
        curve(new byte[][]{{0, 0, 0, 3, 0, 3}, {1, 1, 1, 2, 1, 2}, {2, 2, 2, 1, 2, 1}, {3, 3, 3, 0, 3, 0}});

        private byte[][] pattern;

        private EnumPattern(byte[][] pattern) {
            this.pattern = pattern;
        }

        public byte[][] getPattern() {
            return this.pattern;
        }
    }
}

