/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import ruby.bamboo.BambooInit;
import ruby.bamboo.BambooUtil;

public class BlockDSquare
extends Block {
    private final boolean isHalf;
    private String[] texNameList;
    private final IIcon[] icons;

    public BlockDSquare(boolean isHalf) {
        super(Material.field_151578_c);
        this.isHalf = isHalf;
        this.icons = new IIcon[16];
        if (isHalf) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
        this.func_149672_a(Block.field_149776_m);
        this.func_149711_c(0.2f);
        this.func_149752_b(0.0f);
        this.func_149675_a(true);
        this.func_149713_g(1);
    }

    public BlockDSquare addTexName(String ... texArray) {
        if (texArray.length % 4 != 0) {
            FMLCommonHandler.instance().raiseException((Throwable)new IllegalArgumentException(), "BlockDSquare.addTex() is multiples of 4 only", true);
        }
        if (this.texNameList != null) {
            String[] temp = new String[this.texNameList.length + texArray.length];
            System.arraycopy(this.texNameList, 0, temp, 0, this.texNameList.length);
            System.arraycopy(texArray, 0, temp, this.texNameList.length, texArray.length);
            this.texNameList = temp;
        } else {
            this.texNameList = texArray;
        }
        return this;
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        return false;
    }

    public void func_149690_a(World world, int i, int j, int k, int l, float f, int i1) {
        ItemStack is;
        if (world.field_72995_K) {
            return;
        }
        switch (l) {
            case 10: 
            case 11: {
                is = new ItemStack(this.isHalf ? BambooInit.dHalfSquare : BambooInit.dSquare, 1, 10);
                break;
            }
            default: {
                is = new ItemStack(this.isHalf ? BambooInit.dHalfSquare : BambooInit.dSquare, 1, l & 0xC);
            }
        }
        this.func_149642_a(world, i, j, k, is);
    }

    public IIcon func_149691_a(int side, int meta) {
        return (meta &= 0xF) < this.icons.length ? this.icons[meta] : this.icons[0];
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int meta = par1World.func_72805_g(par2, par3, par4) | BambooUtil.getPlayerDir((Entity)par5EntityLivingBase) + 1 & 3;
        switch (meta) {
            case 10: 
            case 11: {
                if (par6ItemStack.func_77960_j() != 8) break;
                meta -= 2;
            }
        }
        par1World.func_72921_c(par2, par3, par4, meta, 3);
    }

    public boolean func_149686_d() {
        return !this.isHalf;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 8));
        par3List.add(new ItemStack(par1, 1, 10));
        par3List.add(new ItemStack(par1, 1, 12));
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.func_72937_j(par2, par3 + 1, par4) && par5Random.nextInt(10) == 0) {
            switch (par1World.func_72805_g(par2, par3, par4)) {
                case 0: 
                case 1: {
                    par1World.func_72921_c(par2, par3, par4, par1World.func_72805_g(par2, par3, par4) + 8, 3);
                    break;
                }
                case 2: 
                case 3: {
                    par1World.func_72921_c(par2, par3, par4, par1World.func_72805_g(par2, par3, par4) + 6, 3);
                    break;
                }
                case 12: 
                case 13: {
                    par1World.func_72921_c(par2, par3, par4, par1World.func_72805_g(par2, par3, par4) - 2, 3);
                    break;
                }
                case 14: 
                case 15: {
                    par1World.func_72921_c(par2, par3, par4, par1World.func_72805_g(par2, par3, par4) - 4, 3);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        for (int i = 0; i < this.texNameList.length; ++i) {
            this.icons[i] = par1IconRegister.func_94245_a("bamboo:" + this.texNameList[i]);
        }
    }

    public int func_149692_a(int par1) {
        return par1;
    }
}

