/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.api.crafting.grind;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import ruby.bamboo.api.crafting.grind.IGrindInputItem;

public class GrindInputItem
implements IGrindInputItem {
    public final Item item;
    public final int stackSize;
    public final int itemDmg;
    public final int[] oreIDs;

    public GrindInputItem(ItemStack stack) {
        this(stack.func_77973_b(), stack.field_77994_a, stack.func_77960_j(), OreDictionary.getOreIDs((ItemStack)stack));
    }

    public GrindInputItem(Item item, int stackSize, int itemDamage) {
        this(new ItemStack(item, stackSize, itemDamage));
    }

    public GrindInputItem(Item item, int stackSize, int itemDamage, int[] oreIDs) {
        this.item = item;
        this.stackSize = stackSize;
        this.itemDmg = itemDamage;
        this.oreIDs = oreIDs;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }

    @Override
    public int getItemDamage() {
        return this.itemDmg;
    }

    @Override
    public int[] getOreIDs() {
        return this.oreIDs;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack(this.item, this.stackSize, this.itemDmg);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder().append((Object)this.getItem());
        if (this.getItemDamage() != Short.MAX_VALUE) {
            return hcb.append(this.getItemDamage()).toHashCode();
        }
        return hcb.toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IGrindInputItem)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        IGrindInputItem rhs = (IGrindInputItem)obj;
        EqualsBuilder eb = new EqualsBuilder().append((Object)this.getItem(), (Object)rhs.getItem());
        if (this.getItemDamage() != Short.MAX_VALUE) {
            return eb.append(this.getItemDamage(), rhs.getItemDamage()).isEquals();
        }
        return eb.isEquals();
    }
}

