/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import ruby.bamboo.render.block.IRenderBlocks;
import ruby.bamboo.render.block.IRenderInventory;
import ruby.bamboo.render.block.RenderBambooBlock;
import ruby.bamboo.render.block.RenderBambooPane;
import ruby.bamboo.render.block.RenderCoordinateBlock;
import ruby.bamboo.render.block.RenderDelude;
import ruby.bamboo.render.block.RenderInvAndon;
import ruby.bamboo.render.block.RenderInvCampfire;
import ruby.bamboo.render.block.RenderInvManeki;
import ruby.bamboo.render.block.RenderInvMillStone;
import ruby.bamboo.render.block.RenderInvVillagerBlock;
import ruby.bamboo.render.block.RenderKitunebi;
import ruby.bamboo.render.block.RenderMultiBlock;
import ruby.bamboo.render.block.RenderMultiPot;
import ruby.bamboo.render.block.RenderPillar;
import ruby.bamboo.render.block.RenderRotatedBlock;

public class CustomRenderHandler {
    public static final int kitunebiUID;
    public static final int coordinateCrossUID;
    public static final int bambooBlockUID;
    public static final int andonUID;
    public static final int campfireUID;
    public static final int bambooPaneUID;
    public static final int riceFieldUID;
    public static final int millStoneUID;
    public static final int pillarUID;
    public static final int deludeUID;
    public static final int manekiUID;
    public static final int multiPotUID;
    public static final int quadRotatedPillarUID;
    public static final int multiBlockUID;
    public static final int villagerBlockUID;
    public static HashMap<Integer, IRenderBlocks> customRenderMap;
    public static HashMap<Integer, IRenderInventory> customRenderInvMap;
    private static CustomRenderHandler instance;
    private final SimpleInvRender SimpleInvRenderInstance = new SimpleInvRender();
    private final Render3DInInventory Render3DInInvInstance = new Render3DInInventory();

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        customRenderMap.put(kitunebiUID, new RenderKitunebi());
        customRenderMap.put(coordinateCrossUID, new RenderCoordinateBlock());
        customRenderMap.put(bambooBlockUID, RenderBambooBlock.instance);
        customRenderMap.put(bambooPaneUID, new RenderBambooPane());
        customRenderMap.put(pillarUID, RenderPillar.instance);
        customRenderMap.put(deludeUID, RenderDelude.instance);
        customRenderMap.put(multiPotUID, new RenderMultiPot());
        customRenderMap.put(quadRotatedPillarUID, RenderRotatedBlock.instance);
        customRenderMap.put(multiBlockUID, new RenderMultiBlock());
        customRenderInvMap.put(andonUID, new RenderInvAndon());
        customRenderInvMap.put(campfireUID, new RenderInvCampfire());
        customRenderInvMap.put(millStoneUID, new RenderInvMillStone());
        customRenderInvMap.put(pillarUID, RenderPillar.instance);
        customRenderInvMap.put(deludeUID, RenderDelude.instance);
        customRenderInvMap.put(manekiUID, new RenderInvManeki());
        customRenderInvMap.put(quadRotatedPillarUID, RenderRotatedBlock.instance);
        customRenderInvMap.put(villagerBlockUID, new RenderInvVillagerBlock());
    }

    private static int getUIDAndRegistSimpleInvRender() {
        int id = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)id, (ISimpleBlockRenderingHandler)CustomRenderHandler.instance.SimpleInvRenderInstance);
        return id;
    }

    private static int getUIDAndRegist3DRender() {
        int id = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)id, (ISimpleBlockRenderingHandler)CustomRenderHandler.instance.Render3DInInvInstance);
        return id;
    }

    static {
        instance = new CustomRenderHandler();
        customRenderMap = new HashMap();
        customRenderInvMap = new HashMap();
        coordinateCrossUID = CustomRenderHandler.getUIDAndRegistSimpleInvRender();
        kitunebiUID = CustomRenderHandler.getUIDAndRegistSimpleInvRender();
        bambooPaneUID = CustomRenderHandler.getUIDAndRegistSimpleInvRender();
        riceFieldUID = CustomRenderHandler.getUIDAndRegistSimpleInvRender();
        bambooBlockUID = CustomRenderHandler.getUIDAndRegistSimpleInvRender();
        multiPotUID = CustomRenderHandler.getUIDAndRegistSimpleInvRender();
        multiBlockUID = CustomRenderHandler.getUIDAndRegistSimpleInvRender();
        andonUID = CustomRenderHandler.getUIDAndRegist3DRender();
        campfireUID = CustomRenderHandler.getUIDAndRegist3DRender();
        millStoneUID = CustomRenderHandler.getUIDAndRegist3DRender();
        pillarUID = CustomRenderHandler.getUIDAndRegist3DRender();
        deludeUID = CustomRenderHandler.getUIDAndRegist3DRender();
        manekiUID = CustomRenderHandler.getUIDAndRegist3DRender();
        quadRotatedPillarUID = CustomRenderHandler.getUIDAndRegist3DRender();
        villagerBlockUID = CustomRenderHandler.getUIDAndRegist3DRender();
    }

    private class Render3DInInventory
    extends SimpleInvRender {
        private Render3DInInventory() {
        }

        @Override
        public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
            if (customRenderInvMap.containsKey(modelID)) {
                customRenderInvMap.get(modelID).renderInventory(renderer, block, metadata);
            }
        }

        @Override
        public boolean shouldRender3DInInventory(int modelId) {
            return true;
        }
    }

    private class SimpleInvRender
    implements ISimpleBlockRenderingHandler {
        private SimpleInvRender() {
        }

        public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        }

        public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
            if (customRenderMap.containsKey(modelId)) {
                customRenderMap.get(modelId).renderBlock(renderer, block, x, y, z);
                return true;
            }
            return false;
        }

        public int getRenderId() {
            return 0;
        }

        public boolean shouldRender3DInInventory(int modelId) {
            return false;
        }
    }
}

