/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.UnaryOpNode;
import openmods.calc.types.multi.TypedValue;

public abstract class ArgUnpackCompilerHelper {
    private final UnaryOperator<TypedValue> unpackMarker;

    public ArgUnpackCompilerHelper(UnaryOperator<TypedValue> unpackMarker) {
        this.unpackMarker = unpackMarker;
    }

    public void compileArgUnpack(Iterable<IExprNode<TypedValue>> args) {
        ArrayList compiledArgs = Lists.newArrayList();
        int normalArgCount = 0;
        int varArgCount = 0;
        int singleArgWrapCount = 0;
        boolean wrapSingleArgs = false;
        for (IExprNode<TypedValue> arg : args) {
            Optional<IExprNode<TypedValue>> unpackNode = this.tryExtractVarArgNode(arg);
            if (unpackNode.isPresent()) {
                if (singleArgWrapCount > 0) {
                    compiledArgs.add(new SymbolCall("list", singleArgWrapCount, 1));
                    singleArgWrapCount = 0;
                    ++varArgCount;
                }
                ((IExprNode)unpackNode.get()).flatten(compiledArgs);
                ++varArgCount;
                wrapSingleArgs = true;
                continue;
            }
            if (wrapSingleArgs) {
                arg.flatten(compiledArgs);
                ++singleArgWrapCount;
                continue;
            }
            arg.flatten(compiledArgs);
            ++normalArgCount;
        }
        if (singleArgWrapCount > 0) {
            compiledArgs.add(new SymbolCall("list", singleArgWrapCount, 1));
            ++varArgCount;
        }
        if (varArgCount > 0) {
            if (varArgCount > 1) {
                compiledArgs.add(new SymbolCall("flatten", varArgCount, 1));
            }
            this.compileWithVarArgs(normalArgCount, compiledArgs);
        } else {
            this.compileWithoutVarArgs(normalArgCount, compiledArgs);
        }
    }

    protected abstract void compileWithVarArgs(int var1, List<IExecutable<TypedValue>> var2);

    protected abstract void compileWithoutVarArgs(int var1, List<IExecutable<TypedValue>> var2);

    private Optional<IExprNode<TypedValue>> tryExtractVarArgNode(IExprNode<TypedValue> arg) {
        if (arg instanceof UnaryOpNode) {
            UnaryOpNode opNode = (UnaryOpNode)arg;
            if (opNode.operator == this.unpackMarker) {
                return Optional.of(opNode.argument);
            }
        }
        return Optional.absent();
    }
}

