/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.base.Preconditions;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.parsing.IExecutableListBuilder;
import openmods.calc.parsing.IPostfixCompilerState;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.utils.OptionalInt;

public class SimplePostfixCompilerState<E>
implements IPostfixCompilerState<E> {
    final IExecutableListBuilder<E> builder;

    public SimplePostfixCompilerState(IExecutableListBuilder<E> builder) {
        this.builder = builder;
    }

    @Override
    public IPostfixCompilerState.Result acceptToken(Token token) {
        if (token.type == TokenType.OPERATOR) {
            this.builder.appendOperator(token.value);
        } else if (token.type == TokenType.SYMBOL) {
            this.builder.appendSymbolCall(token.value, SymbolCall.DEFAULT_ARG_COUNT, SymbolCall.DEFAULT_RET_COUNT);
        } else if (token.type == TokenType.SYMBOL_WITH_ARGS) {
            SimplePostfixCompilerState.parseSymbolWithArgs(token.value, this.builder);
        } else if (token.type.isValue()) {
            this.builder.appendValue(token);
        } else {
            return IPostfixCompilerState.Result.REJECTED;
        }
        return IPostfixCompilerState.Result.ACCEPTED;
    }

    private static <E> void parseSymbolWithArgs(String value, IExecutableListBuilder<E> output) {
        int argsStart = value.lastIndexOf(36);
        Preconditions.checkArgument((argsStart >= 0 ? 1 : 0) != 0, (String)"No args in token '%s'", (Object[])new Object[]{value});
        String id = value.substring(0, argsStart);
        OptionalInt argCount = OptionalInt.absent();
        OptionalInt retCount = OptionalInt.absent();
        try {
            String args = value.substring(argsStart + 1, value.length());
            int argsSeparator = args.indexOf(44);
            if (argsSeparator >= 0) {
                String retCountStr;
                String argCountStr = args.substring(0, argsSeparator);
                if (!argCountStr.isEmpty()) {
                    argCount = OptionalInt.of(Integer.parseInt(argCountStr));
                }
                if (!(retCountStr = args.substring(argsSeparator + 1, args.length())).isEmpty()) {
                    retCount = OptionalInt.of(Integer.parseInt(retCountStr));
                }
            } else {
                argCount = OptionalInt.of(Integer.parseInt(args));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't parse args on token '" + value + "'", e);
        }
        output.appendSymbolCall(id, argCount, retCount);
    }

    @Override
    public IPostfixCompilerState.Result acceptExecutable(IExecutable<E> executable) {
        this.builder.appendExecutable(executable);
        return IPostfixCompilerState.Result.ACCEPTED;
    }

    @Override
    public IExecutable<E> exit() {
        return this.builder.build();
    }
}

