/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.base.Preconditions;
import java.util.List;
import openmods.calc.BinaryOperator;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.BinaryOpNode;
import openmods.calc.parsing.BracketNode;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.IExprNodeFactory;
import openmods.calc.parsing.IValueParser;
import openmods.calc.parsing.SymbolGetNode;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenUtils;
import openmods.calc.parsing.UnaryOpNode;
import openmods.calc.parsing.ValueNode;

public class DefaultExprNodeFactory<E>
implements IExprNodeFactory<E> {
    private final IValueParser<E> valueParser;

    public DefaultExprNodeFactory(IValueParser<E> valueParser) {
        this.valueParser = valueParser;
    }

    @Override
    public IExprNode<E> createBracketNode(String openingBracket, String closingBracket, List<IExprNode<E>> children) {
        TokenUtils.checkIsValidBracketPair(openingBracket, closingBracket);
        Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0, (String)"Invalid number of children for bracket node: %s", (Object[])new Object[]{children});
        return new BracketNode<E>(children.iterator().next());
    }

    @Override
    public IExprNode<E> createBinaryOpNode(BinaryOperator<E> op, IExprNode<E> leftChild, IExprNode<E> rightChild) {
        return new BinaryOpNode<E>(op, leftChild, rightChild);
    }

    @Override
    public IExprNode<E> createUnaryOpNode(UnaryOperator<E> op, IExprNode<E> child) {
        return new UnaryOpNode<E>(op, child);
    }

    @Override
    public IExprNode<E> createValueNode(E value) {
        return new ValueNode<E>(value);
    }

    @Override
    public IExprNode<E> createValueNode(Token token) {
        return this.createValueNode(this.valueParser.parseToken(token));
    }

    @Override
    public IExprNode<E> createSymbolGetNode(String id) {
        return new SymbolGetNode(id);
    }
}

