/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.ExecutableList;
import openmods.calc.ICalculatorFrame;
import openmods.calc.ICompiler;
import openmods.calc.IExecutable;
import openmods.calc.IValueParser;
import openmods.calc.InvalidTokenException;
import openmods.calc.Operator;
import openmods.calc.OperatorDictionary;
import openmods.calc.SymbolReference;
import openmods.calc.Token;
import openmods.calc.TokenType;
import openmods.calc.Value;
import openmods.utils.Stack;

public class InfixCompiler<E>
implements ICompiler<E> {
    private final IValueParser<E> valueParser;
    private final OperatorDictionary<E> operators;

    public InfixCompiler(IValueParser<E> valueParser, OperatorDictionary<E> operators) {
        this.valueParser = valueParser;
        this.operators = operators;
    }

    @Override
    public IExecutable<E> compile(Iterable<Token> input) {
        ArrayList output = Lists.newArrayList();
        Stack<IExecutable<Object>> operatorStack = Stack.create();
        Token lastToken = null;
        for (Token token : input) {
            if (token.type.isValue()) {
                Object value = this.valueParser.parseToken(token);
                output.add(Value.create(value));
            } else if (token.type.isPossibleFunction()) {
                Preconditions.checkArgument((token.type != TokenType.SYMBOL_WITH_ARGS ? 1 : 0) != 0, (String)"Symbol '%s' can't be used in infix mode", (Object[])new Object[]{token.value});
                operatorStack.push((IExecutable<Object>)new SymbolReference(token.value));
            } else {
                if (lastToken != null && token.type != TokenType.LEFT_BRACKET && lastToken.type.isPossibleFunction()) {
                    IExecutable top = (IExecutable)operatorStack.pop();
                    this.setArgCount(top, 0);
                    output.add(top);
                }
                switch (token.type) {
                    case LEFT_BRACKET: {
                        operatorStack.push(new BracketMarker());
                        break;
                    }
                    case RIGHT_BRACKET: {
                        IExecutable<E> top;
                        Preconditions.checkNotNull((Object)lastToken, (Object)"Right bracket on invalid postion");
                        int argCount = lastToken.type != TokenType.LEFT_BRACKET ? this.popUntilBracket(output, operatorStack) : 0;
                        operatorStack.pop();
                        if (!operatorStack.isEmpty()) {
                            top = operatorStack.peek(0);
                            if (!(top instanceof SymbolReference)) break;
                            ((SymbolReference)top).setArgumentsCount(argCount).setReturnsCount(1);
                            operatorStack.pop();
                            output.add(top);
                            break;
                        }
                        Preconditions.checkState((argCount > 0 ? 1 : 0) != 0, (Object)"Empty brackets after non-fuction");
                        Preconditions.checkState((argCount == 1 ? 1 : 0) != 0, (Object)"Comma used in non-function brackets");
                        break;
                    }
                    case SEPARATOR: {
                        this.popUntilBracket(output, operatorStack);
                        break;
                    }
                    case OPERATOR: {
                        Operator topOp;
                        Operator op;
                        IExecutable<E> top;
                        if (lastToken == null || lastToken.type.isNextOpInfix()) {
                            op = this.operators.getUnaryOperator(token.value);
                            Preconditions.checkArgument((op != null ? 1 : 0) != 0, (String)"No unary version of operator: %s", (Object[])new Object[]{token.value});
                        } else {
                            op = this.operators.getBinaryOperator(token.value);
                            Preconditions.checkArgument((op != null ? 1 : 0) != 0, (String)"Invalid operator: %s", (Object[])new Object[]{token.value});
                        }
                        while (!operatorStack.isEmpty() && (top = operatorStack.peek(0)) instanceof Operator && op.isLessThan(topOp = (Operator)top)) {
                            operatorStack.pop();
                            output.add(top);
                        }
                        operatorStack.push(op);
                        break;
                    }
                    default: {
                        throw new InvalidTokenException(token);
                    }
                }
            }
            lastToken = token;
        }
        while (!operatorStack.isEmpty()) {
            IExecutable top = (IExecutable)operatorStack.pop();
            if (top instanceof BracketMarker) {
                throw new IllegalArgumentException("Unmatched brackets");
            }
            this.setArgCount(top, 0);
            output.add(top);
        }
        return new ExecutableList(output);
    }

    protected void setArgCount(IExecutable<E> symbol, int argCount) {
        if (symbol instanceof SymbolReference) {
            ((SymbolReference)symbol).setArgumentsCount(argCount).setReturnsCount(1);
        }
    }

    private int popUntilBracket(List<IExecutable<E>> output, Stack<IExecutable<E>> operatorStack) {
        try {
            while (true) {
                IExecutable<E> op;
                if ((op = operatorStack.peek(0)) instanceof BracketMarker) {
                    return ((BracketMarker)op).incrementArgCount();
                }
                operatorStack.pop();
                output.add(op);
            }
        }
        catch (Stack.StackUnderflowException e) {
            throw new IllegalArgumentException("Unmatched brackets");
        }
    }

    private class BracketMarker
    implements IExecutable<E> {
        private int argCount = 0;

        private BracketMarker() {
        }

        public int incrementArgCount() {
            return ++this.argCount;
        }

        @Override
        public void execute(ICalculatorFrame<E> frame) {
            throw new UnsupportedOperationException();
        }
    }
}

