/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import java.util.Set;
import openmods.calc.CompiledFunction;
import openmods.calc.Compilers;
import openmods.calc.Environment;
import openmods.calc.IExecutable;
import openmods.calc.IValuePrinter;
import openmods.config.simpler.ConfigurableClassAdapter;

public class Calculator<E, M> {
    public final Environment<E> environment;
    public final Compilers<E, M> compilers;
    public final IValuePrinter<E> printer;
    private final ConfigurableClassAdapter<IValuePrinter> printerConfig;

    public Calculator(Environment<E> environment, Compilers<E, M> compilers, IValuePrinter<E> printer) {
        this.environment = environment;
        this.compilers = compilers;
        this.printer = printer;
        this.printerConfig = ConfigurableClassAdapter.getFor(printer.getClass());
    }

    public Set<String> getProperties() {
        return this.printerConfig.keys();
    }

    public String getProperty(String key) {
        return this.printerConfig.get(this.printer, key);
    }

    public void setProperty(String key, String value) {
        this.printerConfig.set(this.printer, key, value);
    }

    public void compileAndExecute(M exprType, String expr) {
        IExecutable<E> executable = this.compilers.compile(exprType, expr);
        this.environment.execute(executable);
    }

    public E compileExecuteAndPop(M exprType, String expr) {
        IExecutable<E> executable = this.compilers.compile(exprType, expr);
        return this.environment.executeAndPop(executable);
    }

    public String compileExecuteAndPrint(M exprType, String expr) {
        E result = this.compileExecuteAndPop(exprType, expr);
        return this.printer.repr(result);
    }

    public E compileAndSetGlobalSymbol(M exprType, String id, String expr) {
        E value = this.compileExecuteAndPop(exprType, expr);
        this.environment.setGlobalSymbol(id, value);
        return value;
    }

    public void compileAndDefineGlobalFunction(M exprType, String id, int argCount, String bodyExpr) {
        IExecutable<E> funcBody = this.compilers.compile(exprType, bodyExpr);
        this.environment.setGlobalSymbol(id, new CompiledFunction<E>(argCount, 1, funcBody, this.environment.topFrame()));
    }
}

