/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.tile.AEBaseInvTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AERootPoweredTile
extends AEBaseInvTile
implements IAEPowerStorage {
    private double internalMaxPower = 10000.0;
    private boolean internalPublicPowerStorage = false;
    private AccessRestriction internalPowerFlow = AccessRestriction.READ_WRITE;
    private double internalCurrentPower = 0.0;
    private EnumSet<ForgeDirection> internalPowerSides = EnumSet.allOf(ForgeDirection.class);

    protected EnumSet<ForgeDirection> getPowerSides() {
        return this.internalPowerSides.clone();
    }

    protected void setPowerSides(EnumSet<ForgeDirection> sides) {
        this.internalPowerSides = sides;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_AERootPoweredTile(NBTTagCompound data) {
        data.func_74780_a("internalCurrentPower", this.getInternalCurrentPower());
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_AERootPoweredTile(NBTTagCompound data) {
        this.setInternalCurrentPower(data.func_74769_h("internalCurrentPower"));
    }

    protected final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired))));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        return this.getInternalMaxPower() - this.getInternalCurrentPower();
    }

    public final double injectExternalPower(PowerUnits input, double amt) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), Actionable.MODULATE));
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        return this.injectAEPower(power, mode);
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (amt < 1.0E-6) {
            return 0.0;
        }
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.getInternalCurrentPower() + amt;
            if (fakeBattery > this.getInternalMaxPower()) {
                return fakeBattery - this.getInternalMaxPower();
            }
            return 0.0;
        }
        if (this.getInternalCurrentPower() < 0.01 && amt > 0.01) {
            this.PowerEvent(MENetworkPowerStorage.PowerEventType.PROVIDE_POWER);
        }
        this.setInternalCurrentPower(this.getInternalCurrentPower() + amt);
        if (this.getInternalCurrentPower() > this.getInternalMaxPower()) {
            amt = this.getInternalCurrentPower() - this.getInternalMaxPower();
            this.setInternalCurrentPower(this.getInternalMaxPower());
            return amt;
        }
        return 0.0;
    }

    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
    }

    @Override
    public final double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public final double getAECurrentPower() {
        return this.getInternalCurrentPower();
    }

    @Override
    public final boolean isAEPublicPowerStorage() {
        return this.isInternalPublicPowerStorage();
    }

    @Override
    public final AccessRestriction getPowerFlow() {
        return this.getInternalPowerFlow();
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return multiplier.divide(this.extractAEPower(multiplier.multiply(amt), mode));
    }

    protected double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.getInternalCurrentPower() > amt) {
                return amt;
            }
            return this.getInternalCurrentPower();
        }
        boolean bl = wasFull = this.getInternalCurrentPower() >= this.getInternalMaxPower() - 0.001;
        if (wasFull && amt > 0.001) {
            this.PowerEvent(MENetworkPowerStorage.PowerEventType.REQUEST_POWER);
        }
        if (this.getInternalCurrentPower() > amt) {
            this.setInternalCurrentPower(this.getInternalCurrentPower() - amt);
            return amt;
        }
        amt = this.getInternalCurrentPower();
        this.setInternalCurrentPower(0.0);
        return amt;
    }

    public double getInternalCurrentPower() {
        return this.internalCurrentPower;
    }

    public void setInternalCurrentPower(double internalCurrentPower) {
        this.internalCurrentPower = internalCurrentPower;
    }

    public double getInternalMaxPower() {
        return this.internalMaxPower;
    }

    public void setInternalMaxPower(double internalMaxPower) {
        this.internalMaxPower = internalMaxPower;
    }

    private boolean isInternalPublicPowerStorage() {
        return this.internalPublicPowerStorage;
    }

    public void setInternalPublicPowerStorage(boolean internalPublicPowerStorage) {
        this.internalPublicPowerStorage = internalPublicPowerStorage;
    }

    private AccessRestriction getInternalPowerFlow() {
        return this.internalPowerFlow;
    }

    public void setInternalPowerFlow(AccessRestriction internalPowerFlow) {
        this.internalPowerFlow = internalPowerFlow;
    }
}

