/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.config.TunnelType;
import appeng.api.parts.IPartHelper;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;

public final class RF
implements IIntegrationModule {
    public static RF instance;

    public RF() {
        IntegrationHelper.testClassExistence(this, IEnergyReceiver.class);
        IntegrationHelper.testClassExistence(this, IEnergyProvider.class);
        IntegrationHelper.testClassExistence(this, IEnergyHandler.class);
        IntegrationHelper.testClassExistence(this, IEnergyConnection.class);
    }

    @Override
    public void init() {
        IAppEngApi api = AEApi.instance();
        IPartHelper partHelper = api.partHelper();
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.RF)) {
            partHelper.registerNewLayer("appeng.parts.layers.LayerIEnergyHandler", "cofh.api.energy.IEnergyReceiver");
        }
    }

    @Override
    public void postInit() {
        this.registerRFAttunement("ExtraUtilities", "extractor_base", 12);
        this.registerRFAttunement("ExtraUtilities", "pipes", 11);
        this.registerRFAttunement("ExtraUtilities", "pipes", 14);
        this.registerRFAttunement("ExtraUtilities", "generator", Short.MAX_VALUE);
        this.registerRFAttunement("ThermalExpansion", "Cell", Short.MAX_VALUE);
        this.registerRFAttunement("ThermalExpansion", "Dynamo", Short.MAX_VALUE);
        this.registerRFAttunement("ThermalDynamics", "ThermalDynamics_0", 0);
        this.registerRFAttunement("EnderIO", "itemPowerConduit", Short.MAX_VALUE);
        this.registerRFAttunement("EnderIO", "blockCapacitorBank", 0);
        this.registerRFAttunement("EnderIO", "blockPowerMonitor", 0);
    }

    private void registerRFAttunement(String mod, String name, int dmg) {
        assert (mod != null);
        assert (!mod.isEmpty());
        assert (name != null);
        assert (!name.isEmpty());
        assert (dmg >= 0);
        ItemStack modItem = GameRegistry.findItemStack((String)mod, (String)name, (int)1);
        if (modItem != null) {
            modItem.func_77964_b(dmg);
            AEApi.instance().registries().p2pTunnel().addNewAttunement(modItem, TunnelType.RF_POWER);
        }
    }
}

