/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseItemBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.render.WorldRender;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.MissingIcon;
import appeng.core.features.AEBlockFeatureHandler;
import appeng.core.features.AEFeature;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.IAEFeature;
import appeng.core.features.IFeatureHandler;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.util.LookDirection;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AEBaseBlock
extends Block
implements IAEFeature {
    private final String featureFullName;
    protected final Optional<String> featureSubName;
    protected boolean isOpaque = true;
    protected boolean isFullSize = true;
    protected boolean hasSubtypes = false;
    protected boolean isInventory = false;
    private IFeatureHandler handler;
    @SideOnly(value=Side.CLIENT)
    private BlockRenderInfo renderInfo;

    protected AEBaseBlock(Material mat) {
        this(mat, (Optional<String>)Optional.absent());
        this.func_149713_g(255);
        this.func_149715_a(0.0f);
        this.func_149711_c(2.2f);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected AEBaseBlock(Material mat, Optional<String> subName) {
        super(mat);
        if (mat == AEGlassMaterial.INSTANCE || mat == Material.field_151592_s) {
            this.func_149672_a(Block.field_149778_k);
        } else if (mat == Material.field_151576_e) {
            this.func_149672_a(Block.field_149769_e);
        } else if (mat == Material.field_151575_d) {
            this.func_149672_a(Block.field_149766_f);
        } else {
            this.func_149672_a(Block.field_149777_j);
        }
        this.featureFullName = new FeatureNameExtractor(this.getClass(), subName).get();
        this.featureSubName = subName;
    }

    public String toString() {
        return this.featureFullName;
    }

    public void registerNoIcons() {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon i = new FlippableIcon(new MissingIcon(this));
        info.updateIcons(i, i, i, i, i, i);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderInfo getRendererInstance() {
        if (this.renderInfo != null) {
            return this.renderInfo;
        }
        BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> renderer = this.getRenderer();
        this.renderInfo = new BlockRenderInfo(renderer);
        return this.renderInfo;
    }

    @SideOnly(value=Side.CLIENT)
    protected BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> getRenderer() {
        return new BaseBlockRender();
    }

    IIcon unmappedGetIcon(IBlockAccess w, int x, int y, int z, int s) {
        return super.func_149673_e(w, x, y, z, s);
    }

    protected void setFeature(EnumSet<AEFeature> f) {
        AEBlockFeatureHandler featureHandler = new AEBlockFeatureHandler(f, this, this.featureSubName);
        this.setHandler(featureHandler);
    }

    @Override
    public final IFeatureHandler handler() {
        return this.handler;
    }

    protected final void setHandler(IFeatureHandler handler) {
        this.handler = handler;
    }

    @Override
    public void postInit() {
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public boolean func_149686_d() {
        return this.isFullSize && this.isOpaque;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return WorldRender.INSTANCE.getRenderId();
    }

    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        return this.func_149691_a(this.mapRotation(w, x, y, z, s), w.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        return this.getRendererInstance().getTexture(ForgeDirection.getOrientation((int)direction));
    }

    protected ICustomCollision getCustomCollision(World w, int x, int y, int z) {
        if (this instanceof ICustomCollision) {
            return (ICustomCollision)((Object)this);
        }
        return null;
    }

    public void func_149743_a(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, x, y, z);
        if (collisionHandler != null && bb != null) {
            ArrayList<AxisAlignedBB> tmp = new ArrayList<AxisAlignedBB>();
            collisionHandler.addCollidingBlockToList(w, x, y, z, bb, tmp, e);
            for (AxisAlignedBB b : tmp) {
                b.field_72340_a += (double)x;
                b.field_72338_b += (double)y;
                b.field_72339_c += (double)z;
                b.field_72336_d += (double)x;
                b.field_72337_e += (double)y;
                b.field_72334_f += (double)z;
                if (!bb.func_72326_a(b)) continue;
                out.add(b);
            }
        } else {
            super.func_149743_a(w, x, y, z, bb, out, e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB func_149633_g(World w, int x, int y, int z) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, x, y, z);
        if (collisionHandler != null) {
            if (Platform.isClient()) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                LookDirection ld = Platform.getPlayerRay((EntityPlayer)player, Platform.getEyeOffset((EntityPlayer)player));
                Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, (Entity)Minecraft.func_71410_x().field_71439_g, true);
                AxisAlignedBB br = null;
                double lastDist = 0.0;
                for (AxisAlignedBB bb : bbs) {
                    this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
                    MovingObjectPosition r = super.func_149731_a(w, x, y, z, ld.getA(), ld.getB());
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    if (r == null) continue;
                    double xLen = ld.getA().field_72450_a - r.field_72307_f.field_72450_a;
                    double yLen = ld.getA().field_72448_b - r.field_72307_f.field_72448_b;
                    double zLen = ld.getA().field_72449_c - r.field_72307_f.field_72449_c;
                    double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                    if (br != null && !(lastDist > thisDist)) continue;
                    lastDist = thisDist;
                    br = bb;
                }
                if (br != null) {
                    br.func_72324_b(br.field_72340_a + (double)x, br.field_72338_b + (double)y, br.field_72339_c + (double)z, br.field_72336_d + (double)x, br.field_72337_e + (double)y, br.field_72334_f + (double)z);
                    return br;
                }
            }
            AxisAlignedBB b = AxisAlignedBB.func_72330_a((double)16.0, (double)16.0, (double)16.0, (double)0.0, (double)0.0, (double)0.0);
            for (AxisAlignedBB bx : collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, false)) {
                double minX = Math.min(b.field_72340_a, bx.field_72340_a);
                double minY = Math.min(b.field_72338_b, bx.field_72338_b);
                double minZ = Math.min(b.field_72339_c, bx.field_72339_c);
                double maxX = Math.max(b.field_72336_d, bx.field_72336_d);
                double maxY = Math.max(b.field_72337_e, bx.field_72337_e);
                double maxZ = Math.max(b.field_72334_f, bx.field_72334_f);
                b.func_72324_b(minX, minY, minZ, maxX, maxY, maxZ);
            }
            b.func_72324_b(b.field_72340_a + (double)x, b.field_72338_b + (double)y, b.field_72339_c + (double)z, b.field_72336_d + (double)x, b.field_72337_e + (double)y, b.field_72334_f + (double)z);
            return b;
        }
        return super.func_149633_g(w, x, y, z);
    }

    public final boolean func_149662_c() {
        return this.isOpaque;
    }

    public MovingObjectPosition func_149731_a(World w, int x, int y, int z, Vec3 a, Vec3 b) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, x, y, z);
        if (collisionHandler != null) {
            Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, true);
            MovingObjectPosition br = null;
            double lastDist = 0.0;
            for (AxisAlignedBB bb : bbs) {
                this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
                MovingObjectPosition r = super.func_149731_a(w, x, y, z, a, b);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (r == null) continue;
                double xLen = a.field_72450_a - r.field_72307_f.field_72450_a;
                double yLen = a.field_72448_b - r.field_72307_f.field_72448_b;
                double zLen = a.field_72449_c - r.field_72307_f.field_72449_c;
                double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                if (br != null && !(lastDist > thisDist)) continue;
                lastDist = thisDist;
                br = r;
            }
            if (br != null) {
                return br;
            }
            return null;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_149731_a(w, x, y, z, a, b);
    }

    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item item, CreativeTabs tabs, List itemStacks) {
        this.getCheckedSubBlocks(item, tabs, itemStacks);
    }

    public boolean func_149740_M() {
        return this.isInventory;
    }

    public int func_149736_g(World w, int x, int y, int z, int s) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegistry) {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon topIcon = this.optionalIcon(iconRegistry, this.func_149641_N(), null);
        FlippableIcon bottomIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Bottom", topIcon);
        FlippableIcon sideIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Side", topIcon);
        FlippableIcon eastIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "East", sideIcon);
        FlippableIcon westIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "West", sideIcon);
        FlippableIcon southIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Front", sideIcon);
        FlippableIcon northIcon = this.optionalIcon(iconRegistry, this.func_149641_N() + "Back", sideIcon);
        this.field_149761_L = topIcon;
        info.updateIcons(bottomIcon, topIcon, northIcon, southIcon, eastIcon, westIcon);
    }

    public final boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return this.isFullSize;
    }

    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        if (this instanceof IOrientableBlock) {
            return ((IOrientableBlock)((Object)this)).getOrientable(w, x, y, z);
        }
        return null;
    }

    public final boolean rotateBlock(World w, int x, int y, int z, ForgeDirection axis) {
        IOrientable rotatable = this.getOrientable((IBlockAccess)w, x, y, z);
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, axis);
                return true;
            }
            ForgeDirection forward = rotatable.getForward();
            ForgeDirection up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(w, x, y, z, forward = Platform.rotateAround(forward, axis), up = Platform.rotateAround(up, axis))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return super.rotateBlock(w, x, y, z, axis);
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, ForgeDirection axis) {
    }

    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        return true;
    }

    public ForgeDirection[] getValidRotations(World w, int x, int y, int z) {
        return new ForgeDirection[0];
    }

    @SideOnly(value=Side.CLIENT)
    private FlippableIcon optionalIcon(IIconRegister ir, String name, IIcon substitute) {
        while (substitute instanceof FlippableIcon) {
            substitute = ((FlippableIcon)substitute).getOriginal();
        }
        if (substitute != null) {
            try {
                ResourceLocation resLoc = new ResourceLocation(name);
                resLoc = new ResourceLocation(resLoc.func_110624_b(), String.format("%s/%s%s", "textures/blocks", resLoc.func_110623_a(), ".png"));
                IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);
                if (res != null) {
                    return new FlippableIcon(ir.func_94245_a(name));
                }
            }
            catch (Throwable e) {
                return new FlippableIcon(substitute);
            }
        }
        return new FlippableIcon(ir.func_94245_a(name));
    }

    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.func_149666_a(item, tabs, itemStacks);
    }

    private int mapRotation(IBlockAccess w, int x, int y, int z, int s) {
        IOrientable ori = this.getOrientable(w, x, y, z);
        if (ori != null && ori.canBeRotated()) {
            return this.mapRotation(ori, ForgeDirection.getOrientation((int)s)).ordinal();
        }
        return s;
    }

    public ForgeDirection mapRotation(IOrientable ori, ForgeDirection dir) {
        ForgeDirection forward = ori.getForward();
        ForgeDirection up = ori.getUp();
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        ForgeDirection west = ForgeDirection.UNKNOWN;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir == forward) {
            return ForgeDirection.SOUTH;
        }
        if (dir == forward.getOpposite()) {
            return ForgeDirection.NORTH;
        }
        if (dir == up) {
            return ForgeDirection.UP;
        }
        if (dir == up.getOpposite()) {
            return ForgeDirection.DOWN;
        }
        if (dir == west) {
            return ForgeDirection.WEST;
        }
        if (dir == west.getOpposite()) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderStateByMeta(int itemDamage) {
    }

    public String getUnlocalizedName(ItemStack is) {
        return this.func_149739_a();
    }

    void addInformation(ItemStack is, EntityPlayer player, List<String> lines, boolean advancedItemTooltips) {
    }

    public Class<? extends AEBaseItemBlock> getItemBlockClass() {
        return AEBaseItemBlock.class;
    }

    public boolean hasSubtypes() {
        return this.hasSubtypes;
    }
}

