/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.MoreFurnaces;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityIronFurnace
extends TileEntity
implements ISidedInventory {
    public int[] furnaceCookTime;
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    private FurnaceType type;
    private ItemStack[] furnaceContents;
    private byte facing;
    private boolean isActive = false;
    private int ticksSinceSync = 0;

    public TileEntityIronFurnace() {
        this(FurnaceType.IRON);
    }

    protected TileEntityIronFurnace(FurnaceType type) {
        this.type = type;
        this.furnaceCookTime = new int[type.parallelSmelting];
        Arrays.fill(this.furnaceCookTime, 0);
        this.furnaceContents = new ItemStack[this.func_70302_i_()];
    }

    public int getSpeed() {
        return MoreFurnaces.ironSpeed;
    }

    public float getConsumptionRate() {
        return MoreFurnaces.ironConsumptionRate;
    }

    public int func_70302_i_() {
        return this.type.getNumSlots();
    }

    public byte getFacing() {
        return this.facing;
    }

    public void setFacing(byte value) {
        this.facing = value;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public FurnaceType getType() {
        return this.type;
    }

    public ItemStack func_70301_a(int i) {
        return this.furnaceContents[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.furnaceContents[i] != null) {
            if (this.furnaceContents[i].field_77994_a <= j) {
                ItemStack itemstack = this.furnaceContents[i];
                this.furnaceContents[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceContents[i].func_77979_a(j);
            if (this.furnaceContents[i].field_77994_a == 0) {
                this.furnaceContents[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.furnaceContents[i] != null) {
            ItemStack stack = this.furnaceContents[i];
            this.furnaceContents[i] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.furnaceContents[i] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.type.name();
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        NBTTagList var2 = nbtTagCompound.func_150295_c("Items", 10);
        this.furnaceContents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < var2.func_74745_c(); ++i) {
            NBTTagCompound var4 = var2.func_150305_b(i);
            byte j = var4.func_74771_c("Slot");
            if (j < 0 || j >= this.furnaceContents.length) continue;
            this.furnaceContents[j] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.furnaceBurnTime = nbtTagCompound.func_74765_d("BurnTime");
        this.currentItemBurnTime = (int)((float)TileEntityIronFurnace.getItemBurnTime(this.furnaceContents[this.type.getFirstFuelSlot()]) / this.getConsumptionRate());
        NBTTagList cookList = nbtTagCompound.func_150295_c("CookTimes", 10);
        this.furnaceCookTime = new int[this.type.parallelSmelting];
        for (int i = 0; i < cookList.func_74745_c(); ++i) {
            int cookTime;
            NBTTagCompound tag = cookList.func_150305_b(i);
            byte cookId = tag.func_74771_c("Id");
            this.furnaceCookTime[cookId] = cookTime = tag.func_74762_e("Time");
        }
        this.facing = nbtTagCompound.func_74771_c("facing");
        this.isActive = nbtTagCompound.func_74767_n("isActive");
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        NBTTagList cookList = new NBTTagList();
        for (int i = 0; i < this.furnaceCookTime.length; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Id", (byte)i);
            tag.func_74768_a("Time", this.furnaceCookTime[i]);
            cookList.func_74742_a((NBTBase)tag);
        }
        nbtTagCompound.func_74782_a("CookTimes", (NBTBase)cookList);
        nbtTagCompound.func_74774_a("facing", this.facing);
        nbtTagCompound.func_74757_a("isActive", this.isActive);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.furnaceContents.length; ++var3) {
            if (this.furnaceContents[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.furnaceContents[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int id, int i) {
        return this.furnaceCookTime[id] * i / this.getSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.getSpeed();
        }
        return this.furnaceBurnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_145845_h() {
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)MoreFurnaces.blockFurnaces, 1, this.facing & 0xFF);
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)MoreFurnaces.blockFurnaces, 2, (int)((byte)(this.isActive ? 1 : 0)));
        }
        boolean var1 = this.isBurning();
        boolean inventoryChanged = false;
        if (this.isBurning() && this.type.fuelSlots > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            int i;
            if (this.updateStacks()) {
                inventoryChanged = true;
            }
            boolean canSmelt = false;
            for (i = 0; i < this.type.parallelSmelting; ++i) {
                if (!this.canSmelt(i)) continue;
                canSmelt = true;
                break;
            }
            if (this.furnaceBurnTime == 0 && canSmelt && this.type.fuelSlots > 0) {
                int slot = this.type.getFirstFuelSlot();
                this.currentItemBurnTime = this.furnaceBurnTime = (int)((float)TileEntityIronFurnace.getItemBurnTime(this.furnaceContents[slot]) / this.getConsumptionRate());
                if (this.isBurning()) {
                    inventoryChanged = true;
                    if (this.furnaceContents[slot] != null) {
                        --this.furnaceContents[slot].field_77994_a;
                        if (this.furnaceContents[slot].field_77994_a == 0) {
                            this.furnaceContents[slot] = this.furnaceContents[slot].func_77973_b().getContainerItem(this.furnaceContents[slot]);
                        }
                    }
                }
            }
            for (i = 0; i < this.type.parallelSmelting; ++i) {
                if (this.isBurning() && this.canSmelt(i)) {
                    int n = i;
                    this.furnaceCookTime[n] = this.furnaceCookTime[n] + 1;
                    if (this.furnaceCookTime[i] != this.getSpeed()) continue;
                    this.furnaceCookTime[i] = 0;
                    this.smeltItem(i);
                    inventoryChanged = true;
                    continue;
                }
                this.furnaceCookTime[i] = 0;
            }
            if (var1 != this.isBurning() && this.type.fuelSlots > 0) {
                inventoryChanged = true;
                this.isActive = this.isBurning();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (this.type.fuelSlots == 0 && this.isActive != this.isBurning()) {
                this.furnaceBurnTime = 3600;
                this.currentItemBurnTime = 3600;
                inventoryChanged = true;
                this.isActive = this.isBurning();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (inventoryChanged) {
            this.func_70296_d();
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.facing = (byte)j;
            return true;
        }
        if (i == 2) {
            this.isActive = j == 1;
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return super.func_145842_c(i, j);
    }

    private boolean updateStacks() {
        boolean invChanged = false;
        for (int id = 0; id < this.type.parallelSmelting; ++id) {
            int startSlot = this.type.getFirstInputSlot(id);
            int endSlot = this.type.getLastInputSlot(id);
            for (int i = startSlot + 1; i <= endSlot; ++i) {
                if (this.furnaceContents[startSlot] != null || this.furnaceContents[i] == null) continue;
                this.furnaceContents[startSlot] = this.furnaceContents[i].func_77946_l();
                this.furnaceContents[i] = null;
                invChanged = true;
            }
            startSlot = this.type.getFirstOutputSlot(id);
            endSlot = this.type.getLastOutputSlot(id);
            ItemStack result = null;
            if (this.furnaceContents[this.type.getFirstInputSlot(id)] != null) {
                result = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceContents[this.type.getFirstInputSlot(id)]);
            }
            if (result == null) continue;
            for (int i = startSlot + 1; i <= endSlot; ++i) {
                if (this.furnaceContents[startSlot] == null || this.furnaceContents[startSlot].field_77994_a < this.furnaceContents[startSlot].func_77976_d() - result.field_77994_a + 1 && result.func_77969_a(this.furnaceContents[startSlot])) continue;
                if (this.furnaceContents[i] == null) {
                    this.furnaceContents[i] = this.furnaceContents[startSlot].func_77946_l();
                    this.furnaceContents[startSlot] = null;
                    invChanged = true;
                    continue;
                }
                if (!this.furnaceContents[i].func_77969_a(this.furnaceContents[startSlot]) || this.furnaceContents[i].field_77994_a >= this.furnaceContents[i].func_77976_d() || this.furnaceContents[startSlot].field_77994_a <= 0) continue;
                int emptySlots = this.furnaceContents[i].func_77976_d() - this.furnaceContents[i].field_77994_a;
                int adding = Math.min(this.furnaceContents[startSlot].field_77994_a, emptySlots);
                this.furnaceContents[i].field_77994_a += adding;
                this.furnaceContents[startSlot].field_77994_a -= adding;
                if (this.furnaceContents[i].field_77994_a == 0) {
                    this.furnaceContents[i] = null;
                }
                if (this.furnaceContents[startSlot].field_77994_a == 0) {
                    this.furnaceContents[startSlot] = null;
                }
                invChanged = true;
            }
        }
        if (this.type.fuelSlots > 0) {
            int startSlot = this.type.getFirstFuelSlot();
            int endSlot = this.type.getLastFuelSlot();
            for (int i = startSlot; i <= endSlot; ++i) {
                if (this.furnaceContents[startSlot] != null || this.furnaceContents[i] == null) continue;
                this.furnaceContents[startSlot] = this.furnaceContents[i].func_77946_l();
                this.furnaceContents[i] = null;
                invChanged = true;
            }
        }
        return invChanged;
    }

    private boolean canSmelt(int id) {
        if (this.furnaceContents[this.type.getFirstInputSlot(id)] == null) {
            return false;
        }
        ItemStack var1 = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceContents[this.type.getFirstInputSlot(id)]);
        if (var1 == null) {
            return false;
        }
        if (this.furnaceContents[this.type.getFirstOutputSlot(id)] == null) {
            return true;
        }
        if (!this.furnaceContents[this.type.getFirstOutputSlot(id)].func_77969_a(var1)) {
            return false;
        }
        int result = this.furnaceContents[this.type.getFirstOutputSlot((int)id)].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void smeltItem(int id) {
        if (this.canSmelt(id)) {
            ItemStack var1 = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceContents[this.type.getFirstInputSlot(id)]);
            if (this.furnaceContents[this.type.getFirstOutputSlot(id)] == null) {
                this.furnaceContents[this.type.getFirstOutputSlot((int)id)] = var1.func_77946_l();
            } else if (this.furnaceContents[this.type.getFirstOutputSlot(id)].func_77969_a(var1)) {
                this.furnaceContents[this.type.getFirstOutputSlot((int)id)].field_77994_a += var1.field_77994_a;
            }
            --this.furnaceContents[this.type.getFirstInputSlot((int)id)].field_77994_a;
            if (this.furnaceContents[this.type.getFirstInputSlot((int)id)].field_77994_a <= 0) {
                this.furnaceContents[this.type.getFirstInputSlot((int)id)] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityIronFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.type.isOutputSlot(slot) ? false : (this.type.isFuelSlot(slot) ? TileEntityIronFurnace.isItemFuel(itemstack) : true);
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? this.type.outputSlotIds : (side == 1 ? this.type.inputSlotIds : this.type.fuelSlotIds);
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return side != 0 || !this.type.isFuelSlot(slot) || itemstack.func_77973_b() == Items.field_151133_ar;
    }
}

