/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.core.IAreaProvider;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TileMarker;
import com.yogpc.qp.tile.TilePump;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQuarry
extends TileBasic {
    private int targetX;
    private int targetY;
    private int targetZ;
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax = Integer.MIN_VALUE;
    public int zMin;
    public int zMax;
    public boolean filler;
    private IAreaProvider iap = null;
    private boolean addX = true;
    private boolean addZ = true;
    private boolean digged = true;
    private boolean changeZ = false;
    private ForgeChunkManager.Ticket chunkTicket;
    public static final byte NONE = 0;
    public static final byte NOTNEEDBREAK = 1;
    public static final byte MAKEFRAME = 2;
    public static final byte MOVEHEAD = 4;
    public static final byte BREAKBLOCK = 5;
    public double headPosX;
    public double headPosY;
    public double headPosZ;
    private boolean initialized = true;
    private byte now = 0;

    private void S_updateEntity() {
        if (this.iap != null) {
            if (this.iap instanceof TileMarker) {
                this.cacheItems.addAll(((TileMarker)this.iap).removeFromWorldWithItem());
            } else {
                this.iap.removeFromWorld();
            }
            this.iap = null;
        }
        switch (this.now) {
            case 2: {
                if (!this.S_makeFrame()) break;
                while (!this.S_checkTarget()) {
                    this.S_setNextTarget();
                }
                break;
            }
            case 4: {
                boolean done = this.S_moveHead();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    dos.writeDouble(this.headPosX);
                    dos.writeDouble(this.headPosY);
                    dos.writeDouble(this.headPosZ);
                    PacketHandler.sendPacketToAround(new YogpstopPacket(bos.toByteArray(), this, 5), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (!done) break;
                this.now = (byte)5;
            }
            case 1: 
            case 5: {
                if (!this.S_breakBlock()) break;
                while (!this.S_checkTarget()) {
                    this.S_setNextTarget();
                }
                break;
            }
        }
        this.S_pollItems();
    }

    private boolean S_checkTarget() {
        Block b;
        if (this.targetY > this.yMax) {
            this.targetY = this.yMax;
        }
        float h = (b = this.field_145850_b.func_72863_F().func_73158_c(this.targetX >> 4, this.targetZ >> 4).func_150810_a(this.targetX & 0xF, this.targetY, this.targetZ & 0xF)) == null ? -1.0f : b.func_149712_f(this.field_145850_b, this.targetX, this.targetY, this.targetZ);
        switch (this.now) {
            case 4: 
            case 5: {
                if (this.targetY < 1) {
                    this.G_destroy();
                    PacketHandler.sendNowPacket(this, this.now);
                    return true;
                }
                if (b == null || h < 0.0f || b.isAir((IBlockAccess)this.field_145850_b, this.targetX, this.targetY, this.targetZ)) {
                    return false;
                }
                return this.pump != ForgeDirection.UNKNOWN || !TilePump.isLiquid(b, false, null, 0, 0, 0, 0);
            }
            case 1: {
                if (this.targetY < this.yMin) {
                    if (this.filler) {
                        this.G_destroy();
                        PacketHandler.sendNowPacket(this, this.now);
                        return true;
                    }
                    this.now = (byte)2;
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin;
                    this.targetY = this.yMax;
                    this.targetZ = this.zMin;
                    this.digged = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    PacketHandler.sendNowPacket(this, this.now);
                    return this.S_checkTarget();
                }
                if (b == null || h < 0.0f || b.isAir((IBlockAccess)this.field_145850_b, this.targetX, this.targetY, this.targetZ)) {
                    return false;
                }
                if (this.pump == ForgeDirection.UNKNOWN && TilePump.isLiquid(b, false, null, 0, 0, 0, 0)) {
                    return false;
                }
                if (b == QuarryPlusI.blockFrame && this.field_145850_b.func_72805_g(this.targetX, this.targetY, this.targetZ) == 0) {
                    int flag = 0;
                    if (this.targetX == this.xMin || this.targetX == this.xMax) {
                        flag = (byte)(flag + 1);
                    }
                    if (this.targetY == this.yMin || this.targetY == this.yMax) {
                        flag = (byte)(flag + 1);
                    }
                    if (this.targetZ == this.zMin || this.targetZ == this.zMax) {
                        flag = (byte)(flag + 1);
                    }
                    if (flag > 1) {
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                if (this.targetY < this.yMin) {
                    this.now = (byte)4;
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin + 1;
                    this.targetY = this.yMin;
                    this.targetZ = this.zMin + 1;
                    this.digged = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    PacketHandler.sendNowPacket(this, this.now);
                    return this.S_checkTarget();
                }
                if (b != null && b.func_149688_o().func_76220_a() && (b != QuarryPlusI.blockFrame || this.field_145850_b.func_72805_g(this.targetX, this.targetY, this.targetZ) != 0)) {
                    this.now = 1;
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin;
                    this.targetZ = this.zMin;
                    this.targetY = this.yMax;
                    this.digged = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    PacketHandler.sendNowPacket(this, this.now);
                    return this.S_checkTarget();
                }
                int flag = 0;
                if (this.targetX == this.xMin || this.targetX == this.xMax) {
                    flag = (byte)(flag + 1);
                }
                if (this.targetY == this.yMin || this.targetY == this.yMax) {
                    flag = (byte)(flag + 1);
                }
                if (this.targetZ == this.zMin || this.targetZ == this.zMax) {
                    flag = (byte)(flag + 1);
                }
                if (flag > 1) {
                    return b != QuarryPlusI.blockFrame || this.field_145850_b.func_72805_g(this.targetX, this.targetY, this.targetZ) != 0;
                }
                return false;
            }
        }
        return true;
    }

    private void S_setNextTarget() {
        if (this.now == 2) {
            if (this.changeZ) {
                this.targetZ = this.addZ ? ++this.targetZ : --this.targetZ;
            } else {
                this.targetX = this.addX ? ++this.targetX : --this.targetX;
            }
            if (this.targetX < this.xMin || this.xMax < this.targetX) {
                this.addX = !this.addX;
                this.changeZ = true;
                this.targetX = Math.max(this.xMin, Math.min(this.xMax, this.targetX));
            }
            if (this.targetZ < this.zMin || this.zMax < this.targetZ) {
                this.addZ = !this.addZ;
                this.changeZ = false;
                this.targetZ = Math.max(this.zMin, Math.min(this.zMax, this.targetZ));
            }
            if (this.xMin == this.targetX && this.zMin == this.targetZ) {
                if (this.digged) {
                    this.digged = false;
                } else {
                    --this.targetY;
                }
            }
        } else {
            int out;
            this.targetX = this.addX ? ++this.targetX : --this.targetX;
            int n = out = this.now == 1 ? 0 : 1;
            if (this.targetX < this.xMin + out || this.xMax - out < this.targetX) {
                this.addX = !this.addX;
                this.targetX = Math.max(this.xMin + out, Math.min(this.targetX, this.xMax - out));
                this.targetZ = this.addZ ? ++this.targetZ : --this.targetZ;
                if (this.targetZ < this.zMin + out || this.zMax - out < this.targetZ) {
                    this.addZ = !this.addZ;
                    this.targetZ = Math.max(this.zMin + out, Math.min(this.targetZ, this.zMax - out));
                    if (this.digged) {
                        this.digged = false;
                    } else {
                        double dd;
                        double da;
                        double ad;
                        --this.targetY;
                        double aa = this.S_getDistance(this.xMin + 1, this.targetY, this.zMin + out);
                        double res = Math.min(aa, Math.min(ad = this.S_getDistance(this.xMin + 1, this.targetY, this.zMax - out), Math.min(da = this.S_getDistance(this.xMax - 1, this.targetY, this.zMin + out), dd = this.S_getDistance(this.xMax - 1, this.targetY, this.zMax - out))));
                        if (res == aa) {
                            this.addX = true;
                            this.addZ = true;
                            this.targetX = this.xMin + out;
                            this.targetZ = this.zMin + out;
                        } else if (res == ad) {
                            this.addX = true;
                            this.addZ = false;
                            this.targetX = this.xMin + out;
                            this.targetZ = this.zMax - out;
                        } else if (res == da) {
                            this.addX = false;
                            this.addZ = true;
                            this.targetX = this.xMax - out;
                            this.targetZ = this.zMin + out;
                        } else if (res == dd) {
                            this.addX = false;
                            this.addZ = false;
                            this.targetX = this.xMax - out;
                            this.targetZ = this.zMax - out;
                        }
                    }
                }
            }
        }
    }

    private double S_getDistance(int x, int y, int z) {
        return Math.sqrt(Math.pow((double)x - this.headPosX, 2.0) + Math.pow((double)(y + 1) - this.headPosY, 2.0) + Math.pow((double)z - this.headPosZ, 2.0));
    }

    private boolean S_makeFrame() {
        this.digged = true;
        if (!PowerManager.useEnergyF(this, this.unbreaking)) {
            return false;
        }
        this.field_145850_b.func_147449_b(this.targetX, this.targetY, this.targetZ, QuarryPlusI.blockFrame);
        this.S_setNextTarget();
        return true;
    }

    private boolean S_breakBlock() {
        this.digged = true;
        if (this.S_breakBlock(this.targetX, this.targetY, this.targetZ)) {
            this.S_checkDropItem();
            if (this.now == 5) {
                this.now = (byte)4;
            }
            this.S_setNextTarget();
            return true;
        }
        return false;
    }

    private void S_checkDropItem() {
        AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(this.targetX - 4), (double)(this.targetY - 4), (double)(this.targetZ - 4), (double)(this.targetX + 6), (double)(this.targetY + 6), (double)(this.targetZ + 6));
        List result = this.field_145850_b.func_72872_a(EntityItem.class, axis);
        for (int ii = 0; ii < result.size(); ++ii) {
            if (!(result.get(ii) instanceof EntityItem)) continue;
            EntityItem entity = (EntityItem)result.get(ii);
            if (entity.field_70128_L) continue;
            ItemStack drop = entity.func_92059_d();
            if (drop.field_77994_a <= 0) continue;
            QuarryPlus.proxy.removeEntity((Entity)entity);
            this.cacheItems.add(drop);
        }
    }

    private void S_createBox() {
        if (this.yMax != Integer.MIN_VALUE) {
            return;
        }
        if (!(this.S_checkIAreaProvider(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) || this.S_checkIAreaProvider(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) || this.S_checkIAreaProvider(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) || this.S_checkIAreaProvider(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) || this.S_checkIAreaProvider(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || this.S_checkIAreaProvider(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e))) {
            ForgeDirection o = ForgeDirection.values()[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)].getOpposite();
            switch (o) {
                case EAST: {
                    this.xMin = this.field_145851_c + 1;
                    this.zMin = this.field_145849_e - 5;
                    break;
                }
                case WEST: {
                    this.xMin = this.field_145851_c - 11;
                    this.zMin = this.field_145849_e - 5;
                    break;
                }
                case SOUTH: {
                    this.xMin = this.field_145851_c - 5;
                    this.zMin = this.field_145849_e + 1;
                    break;
                }
                default: {
                    this.xMin = this.field_145851_c - 5;
                    this.zMin = this.field_145849_e - 11;
                }
            }
            this.yMin = this.field_145848_d;
            this.xMax = this.xMin + 10;
            this.zMax = this.zMin + 10;
            this.yMax = this.field_145848_d + 4;
        }
    }

    private boolean S_checkIAreaProvider(int x, int y, int z) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|core") && te instanceof IAreaProvider) {
            int tmp;
            this.iap = (IAreaProvider)te;
            this.xMin = this.iap.xMin();
            this.xMax = this.iap.xMax();
            this.yMin = this.iap.yMin();
            this.zMin = this.iap.zMin();
            this.zMax = this.iap.zMax();
            this.yMax = this.iap.yMax();
            if (this.xMin > this.xMax) {
                tmp = this.xMin;
                this.xMin = this.xMax;
                this.xMax = tmp;
            }
            if (this.yMin > this.yMax) {
                tmp = this.yMin;
                this.yMin = this.yMax;
                this.yMax = tmp;
            }
            if (this.zMin > this.zMax) {
                tmp = this.zMin;
                this.zMin = this.zMax;
                this.zMax = tmp;
            }
            if (this.field_145851_c >= this.xMin && this.field_145851_c <= this.xMax && this.field_145848_d >= this.yMin && this.field_145848_d <= this.yMax && this.field_145849_e >= this.zMin && this.field_145849_e <= this.zMax) {
                this.yMax = Integer.MIN_VALUE;
                return false;
            }
            if (this.xMax - this.xMin < 2 || this.zMax - this.zMin < 2) {
                this.yMax = Integer.MIN_VALUE;
                return false;
            }
            if (this.yMax - this.yMin < 2) {
                this.yMax = this.yMin + 3;
            }
            return true;
        }
        return false;
    }

    private void S_setFirstPos() {
        this.targetX = this.xMin;
        this.targetZ = this.zMin;
        this.targetY = this.yMax;
        this.headPosX = (this.xMin + this.xMax + 1) / 2;
        this.headPosZ = (this.zMin + this.zMax + 1) / 2;
        this.headPosY = this.yMax - 1;
    }

    private void S_destroyFrames() {
        if (this.yMax == Integer.MIN_VALUE) {
            return;
        }
        int xn = this.xMin;
        int xx = this.xMax;
        int yn = this.yMin;
        int yx = this.yMax;
        int zn = this.zMin;
        int zx = this.zMax;
        for (int x = xn; x <= xx; ++x) {
            this.S_setBreakableFrame(x, yn, zn);
            this.S_setBreakableFrame(x, yn, zx);
            this.S_setBreakableFrame(x, yx, zn);
            this.S_setBreakableFrame(x, yx, zx);
        }
        for (int y = yn; y <= yx; ++y) {
            this.S_setBreakableFrame(xn, y, zn);
            this.S_setBreakableFrame(xn, y, zx);
            this.S_setBreakableFrame(xx, y, zn);
            this.S_setBreakableFrame(xx, y, zx);
        }
        for (int z = zn; z <= zx; ++z) {
            this.S_setBreakableFrame(xn, yn, z);
            this.S_setBreakableFrame(xn, yx, z);
            this.S_setBreakableFrame(xx, yn, z);
            this.S_setBreakableFrame(xx, yx, z);
        }
    }

    private void S_setBreakableFrame(int x, int y, int z) {
        if (this.field_145850_b.func_147439_a(x, y, z) == QuarryPlusI.blockFrame) {
            this.field_145850_b.func_72921_c(x, y, z, 1, 3);
        }
    }

    private boolean S_moveHead() {
        double x = (double)this.targetX - this.headPosX;
        double y = (double)(this.targetY + 1) - this.headPosY;
        double z = (double)this.targetZ - this.headPosZ;
        double distance = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
        double blocks = PowerManager.useEnergyH(this, distance, this.unbreaking);
        if (blocks * 2.0 >= distance) {
            this.headPosX = this.targetX;
            this.headPosY = this.targetY + 1;
            this.headPosZ = this.targetZ;
            return true;
        }
        if (blocks > 0.0) {
            this.headPosX += x * blocks / distance;
            this.headPosY += y * blocks / distance;
            this.headPosZ += z * blocks / distance;
        }
        return false;
    }

    public byte G_getNow() {
        return this.now;
    }

    @Override
    protected void G_destroy() {
        this.now = 0;
        this.G_renew_powerConfigure();
        if (!this.field_145850_b.field_72995_K) {
            this.S_destroyFrames();
            PacketHandler.sendNowPacket(this, this.now);
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    @Override
    public void G_reinit() {
        if (this.yMax == Integer.MIN_VALUE && !this.field_145850_b.field_72995_K) {
            this.S_createBox();
        }
        this.now = 1;
        this.G_renew_powerConfigure();
        if (!this.field_145850_b.field_72995_K) {
            this.S_setFirstPos();
            PacketHandler.sendPacketToAround(new YogpstopPacket(this), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void requestTicket() {
        if (this.chunkTicket != null) {
            return;
        }
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)QuarryPlus.I, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.chunkTicket == null) {
            return;
        }
        NBTTagCompound tag = this.chunkTicket.getModData();
        tag.func_74768_a("quarryX", this.field_145851_c);
        tag.func_74768_a("quarryY", this.field_145848_d);
        tag.func_74768_a("quarryZ", this.field_145849_e);
        this.forceChunkLoading(this.chunkTicket);
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        ChunkCoordIntPair quarryChunk = new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)quarryChunk);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialized) {
            this.G_renew_powerConfigure();
            this.initialized = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.S_updateEntity();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.xMin = nbttc.func_74762_e("xMin");
        this.xMax = nbttc.func_74762_e("xMax");
        this.yMin = nbttc.func_74762_e("yMin");
        this.zMin = nbttc.func_74762_e("zMin");
        this.zMax = nbttc.func_74762_e("zMax");
        this.yMax = nbttc.func_74762_e("yMax");
        this.targetX = nbttc.func_74762_e("targetX");
        this.targetY = nbttc.func_74762_e("targetY");
        this.targetZ = nbttc.func_74762_e("targetZ");
        this.addZ = nbttc.func_74767_n("addZ");
        this.addX = nbttc.func_74767_n("addX");
        this.digged = nbttc.func_74767_n("digged");
        this.changeZ = nbttc.func_74767_n("changeZ");
        this.now = nbttc.func_74771_c("now");
        this.headPosX = nbttc.func_74769_h("headPosX");
        this.headPosY = nbttc.func_74769_h("headPosY");
        this.headPosZ = nbttc.func_74769_h("headPosZ");
        this.filler = nbttc.func_74767_n("filler");
        this.initialized = false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttc) {
        super.func_145841_b(nbttc);
        nbttc.func_74768_a("xMin", this.xMin);
        nbttc.func_74768_a("xMax", this.xMax);
        nbttc.func_74768_a("yMin", this.yMin);
        nbttc.func_74768_a("yMax", this.yMax);
        nbttc.func_74768_a("zMin", this.zMin);
        nbttc.func_74768_a("zMax", this.zMax);
        nbttc.func_74768_a("targetX", this.targetX);
        nbttc.func_74768_a("targetY", this.targetY);
        nbttc.func_74768_a("targetZ", this.targetZ);
        nbttc.func_74757_a("addZ", this.addZ);
        nbttc.func_74757_a("addX", this.addX);
        nbttc.func_74757_a("digged", this.digged);
        nbttc.func_74757_a("changeZ", this.changeZ);
        nbttc.func_74774_a("now", this.now);
        nbttc.func_74780_a("headPosX", this.headPosX);
        nbttc.func_74780_a("headPosY", this.headPosY);
        nbttc.func_74780_a("headPosZ", this.headPosZ);
        nbttc.func_74757_a("filler", this.filler);
    }

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        super.C_recievePacket(id, data, ep);
        switch (id) {
            case 4: {
                this.now = data[0];
                this.G_renew_powerConfigure();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 5: {
                ByteArrayDataInput badi = ByteStreams.newDataInput((byte[])data);
                this.headPosX = badi.readDouble();
                this.headPosY = badi.readDouble();
                this.headPosZ = badi.readDouble();
            }
        }
    }

    @Override
    public void G_renew_powerConfigure() {
        byte pmp = 0;
        if (this.field_145850_b != null && this.pump != ForgeDirection.UNKNOWN) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.pump.offsetX, this.field_145848_d + this.pump.offsetY, this.field_145849_e + this.pump.offsetZ);
            if (te instanceof TilePump) {
                pmp = ((TilePump)te).unbreaking;
            } else {
                this.pump = ForgeDirection.UNKNOWN;
            }
        }
        if (this.now == 0) {
            PowerManager.configure0(this);
        } else if (this.now == 2) {
            PowerManager.configureF(this, this.efficiency, this.unbreaking, pmp);
        } else {
            PowerManager.configureB(this, this.efficiency, this.unbreaking, pmp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)Double.NEGATIVE_INFINITY, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        if (this.yMax == Integer.MIN_VALUE) {
            return aabb;
        }
        double xn = (double)this.xMin + 0.46875;
        double xx = (double)this.xMax + 0.53125;
        double yx = (double)this.yMax + 0.75;
        double zn = (double)this.zMin + 0.46875;
        double zx = (double)this.zMax + 0.53125;
        if (xn < aabb.field_72340_a) {
            aabb.field_72340_a = xn;
        }
        if (xx > aabb.field_72336_d) {
            aabb.field_72336_d = xx;
        }
        if (aabb.field_72337_e < yx) {
            aabb.field_72337_e = yx;
        }
        if (zn < aabb.field_72339_c) {
            aabb.field_72339_c = zn;
        }
        if (zx > aabb.field_72334_f) {
            aabb.field_72334_f = zx;
        }
        return aabb;
    }
}

