/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TileQuarry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class TilePump
extends APacketTile
implements IFluidHandler,
IEnchantableTile {
    private ForgeDirection connectTo = ForgeDirection.UNKNOWN;
    private boolean initialized = false;
    private byte prev = (byte)ForgeDirection.UNKNOWN.ordinal();
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    private static final int Y_SIZE = 256;
    private static final int CHUNK_SCALE = 16;
    private byte[][][] blocks;
    private ExtendedBlockStorage[][][] ebses;
    private int xOffset;
    private int yOffset;
    private int zOffset;
    private int px;
    private int py = Integer.MIN_VALUE;
    private int cx;
    private int cy = -1;
    private int cz;
    private byte range = 0;
    private boolean quarryRange = true;
    private int block_side_x;
    private int block_side_z;
    private static final int ARRAY_MAX = 524288;
    private static final int[] xb = new int[524288];
    private static final int[] yb = new int[524288];
    private static final int[] zb = new int[524288];
    private static int cp = 0;
    private static int cg = 0;
    private long fwt;
    private final LinkedList<FluidStack> liquids = new LinkedList();
    public final LinkedList<String>[] mapping = new LinkedList[ForgeDirection.VALID_DIRECTIONS.length];

    public TilePump() {
        for (int i = 0; i < this.mapping.length; ++i) {
            this.mapping[i] = new LinkedList();
        }
    }

    public TileBasic G_connected() {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.connectTo.offsetX, this.field_145848_d + this.connectTo.offsetY, this.field_145849_e + this.connectTo.offsetZ);
        if (te instanceof TileBasic) {
            return (TileBasic)te;
        }
        this.connectTo = ForgeDirection.UNKNOWN;
        if (!this.field_145850_b.field_72995_K) {
            this.S_sendNowPacket();
        }
        return null;
    }

    public boolean G_working() {
        return this.py >= this.cy;
    }

    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.silktouch = nbttc.func_74767_n("silktouch");
        this.fortune = nbttc.func_74771_c("fortune");
        this.unbreaking = nbttc.func_74771_c("unbreaking");
        this.connectTo = ForgeDirection.values()[nbttc.func_74771_c("connectTo")];
        if (nbttc.func_74781_a("mapping0") instanceof NBTTagList) {
            for (int i = 0; i < this.mapping.length; ++i) {
                TilePump.readStringCollection(nbttc.func_150295_c("mapping" + i, 8), this.mapping[i]);
            }
        }
        this.range = nbttc.func_74771_c("range");
        this.quarryRange = nbttc.func_74767_n("quarryRange");
        this.prev = (byte)(this.connectTo.ordinal() | (this.G_working() ? 128 : 0));
        if (this.silktouch) {
            this.liquids.clear();
            NBTTagList nbttl = nbttc.func_150295_c("liquids", 10);
            for (int i = 0; i < nbttl.func_74745_c(); ++i) {
                this.liquids.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttl.func_150305_b(i)));
            }
        }
    }

    private static void readStringCollection(NBTTagList nbttl, Collection<String> target) {
        target.clear();
        for (int i = 0; i < nbttl.func_74745_c(); ++i) {
            target.add(nbttl.func_150307_f(i));
        }
    }

    public void func_145841_b(NBTTagCompound nbttc) {
        super.func_145841_b(nbttc);
        nbttc.func_74757_a("silktouch", this.silktouch);
        nbttc.func_74774_a("fortune", this.fortune);
        nbttc.func_74774_a("unbreaking", this.unbreaking);
        nbttc.func_74774_a("connectTo", (byte)this.connectTo.ordinal());
        for (int i = 0; i < this.mapping.length; ++i) {
            nbttc.func_74782_a("mapping" + i, (NBTBase)TilePump.writeStringCollection(this.mapping[i]));
        }
        nbttc.func_74774_a("range", this.range);
        nbttc.func_74757_a("quarryRange", this.quarryRange);
        if (this.silktouch) {
            NBTTagList nbttl = new NBTTagList();
            for (FluidStack l : this.liquids) {
                nbttl.func_74742_a((NBTBase)l.writeToNBT(new NBTTagCompound()));
            }
            nbttc.func_74782_a("liquids", (NBTBase)nbttl);
        }
    }

    private static NBTTagList writeStringCollection(Collection<String> target) {
        NBTTagList nbttl = new NBTTagList();
        for (String l : target) {
            nbttl.func_74742_a((NBTBase)new NBTTagString(l));
        }
        return nbttl;
    }

    public void func_145845_h() {
        int pZ;
        TileEntity te;
        super.func_145845_h();
        block0: for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            te = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
            if (!(te instanceof IFluidHandler)) continue;
            for (String s : this.mapping[fd.ordinal()]) {
                pZ = this.liquids.indexOf(FluidRegistry.getFluidStack((String)s, (int)0));
                if (pZ == -1) continue;
                FluidStack fs = this.liquids.get(pZ);
                fs.amount -= ((IFluidHandler)te).fill(fd.getOpposite(), fs, true);
                continue block0;
            }
        }
        if (this.field_145850_b.field_72995_K || this.initialized) {
            return;
        }
        int pX = this.field_145851_c + this.connectTo.offsetX;
        int pY = this.field_145848_d + this.connectTo.offsetY;
        pZ = this.field_145849_e + this.connectTo.offsetZ;
        te = this.field_145850_b.func_147438_o(pX, pY, pZ);
        if (te instanceof TileBasic && ((TileBasic)te).S_connect(this.connectTo.getOpposite())) {
            this.S_sendNowPacket();
            this.initialized = true;
        } else if (this.field_145850_b.func_147437_c(pX, pY, pZ) || this.connectTo == ForgeDirection.UNKNOWN) {
            this.connectTo = ForgeDirection.UNKNOWN;
            this.S_sendNowPacket();
            this.initialized = true;
        }
    }

    @Override
    public void G_reinit() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
            if (!(te instanceof TileBasic) || !((TileBasic)te).S_connect(fd.getOpposite())) continue;
            this.connectTo = fd;
            this.S_sendNowPacket();
            return;
        }
        this.connectTo = ForgeDirection.UNKNOWN;
        this.S_sendNowPacket();
    }

    private void S_sendNowPacket() {
        byte c = (byte)(this.connectTo.ordinal() | (this.G_working() ? 128 : 0));
        if (c != this.prev) {
            this.prev = c;
            PacketHandler.sendNowPacket(this, c);
        }
    }

    @Override
    public void S_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        ByteArrayDataInput badi = ByteStreams.newDataInput((byte[])data);
        switch (id) {
            case 16: {
                byte target = badi.readByte();
                this.mapping[target].add(badi.readUTF());
                this.S_OpenGUI(target, ep);
                break;
            }
            case 17: {
                byte target = badi.readByte();
                this.mapping[target].remove(badi.readUTF());
                this.S_OpenGUI(target, ep);
                break;
            }
            case 18: {
                byte target = badi.readByte();
                int pos = this.mapping[target].indexOf(badi.readUTF());
                if (pos > 0) {
                    String buf = this.mapping[target].get(pos);
                    this.mapping[target].remove(pos);
                    this.mapping[target].add(pos - 1, buf);
                }
                this.S_OpenGUI(target, ep);
                break;
            }
            case 19: {
                byte target = badi.readByte();
                int pos = this.mapping[target].indexOf(badi.readUTF());
                if (pos >= 0 && pos + 1 < this.mapping[target].size()) {
                    String buf = this.mapping[target].get(pos);
                    this.mapping[target].remove(pos);
                    this.mapping[target].add(pos + 1, buf);
                }
                this.S_OpenGUI(target, ep);
                break;
            }
            case 20: {
                byte target = badi.readByte();
                int pos = this.mapping[target].indexOf(badi.readUTF());
                if (pos >= 0) {
                    String buf = this.mapping[target].get(pos);
                    this.mapping[target].remove(pos);
                    this.mapping[target].addFirst(buf);
                }
                this.S_OpenGUI(target, ep);
                break;
            }
            case 21: {
                byte target = badi.readByte();
                int pos = this.mapping[target].indexOf(badi.readUTF());
                if (pos >= 0) {
                    String buf = this.mapping[target].get(pos);
                    this.mapping[target].remove(pos);
                    this.mapping[target].addLast(buf);
                }
                this.S_OpenGUI(target, ep);
                break;
            }
            case 22: {
                this.S_OpenGUI(badi.readByte(), ep);
                break;
            }
            case 23: {
                byte from = badi.readByte();
                byte target = badi.readByte();
                this.mapping[target].clear();
                this.mapping[target].addAll(this.mapping[from]);
                this.S_OpenGUI(target, ep);
            }
        }
    }

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        ByteArrayDataInput badi = ByteStreams.newDataInput((byte[])data);
        switch (id) {
            case 4: {
                byte flag = badi.readByte();
                if ((flag & 0x80) != 0) {
                    this.py = -1;
                    this.cy = -1;
                } else {
                    this.py = Integer.MIN_VALUE;
                }
                this.connectTo = ForgeDirection.getOrientation((int)(flag & 0x7F));
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 3: {
                byte target = badi.readByte();
                int len = badi.readInt();
                this.mapping[target].clear();
                for (int i = 0; i < len; ++i) {
                    this.mapping[target].add(badi.readUTF());
                }
                ep.openGui((Object)QuarryPlus.I, 6 + target, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void S_OpenGUI(int d, EntityPlayer ep) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(d);
            dos.writeInt(this.mapping[d].size());
            for (String s : this.mapping[d]) {
                dos.writeUTF(s);
            }
            PacketHandler.sendPacketToPlayer(new YogpstopPacket(bos.toByteArray(), this, 3), ep);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void S_changeRange(EntityPlayer ep) {
        if (this.range >= (this.fortune + 1) * 2) {
            if (this.G_connected() instanceof TileQuarry) {
                this.quarryRange = true;
            }
            this.range = 0;
        } else if (this.quarryRange) {
            this.quarryRange = false;
        } else {
            this.range = (byte)(this.range + 1);
        }
        if (this.quarryRange) {
            ep.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pump_rtoggle.quarry", new Object[0]));
        } else {
            ep.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pump_rtoggle.num", new Object[]{Integer.toString(this.range * 2 + 1)}));
        }
        this.fwt = 0L;
    }

    private static void S_put(int x, int y, int z) {
        TilePump.xb[TilePump.cp] = x;
        TilePump.yb[TilePump.cp] = y;
        TilePump.zb[TilePump.cp] = z;
        if (++cp == 524288) {
            cp = 0;
        }
    }

    private void S_searchLiquid(int x, int y, int z) {
        int chunk_side_z;
        int chunk_side_x;
        this.fwt = this.field_145850_b.func_72820_D();
        cg = 0;
        cp = 0;
        this.cx = x;
        this.cy = y;
        this.cz = z;
        this.yOffset = y & 0xFFFFFFF0;
        this.py = 255;
        this.px = -1;
        TileBasic tb = this.G_connected();
        TileQuarry b = null;
        if (tb instanceof TileQuarry) {
            b = (TileQuarry)tb;
        }
        if (b != null && b.yMax != Integer.MIN_VALUE) {
            int z_add;
            chunk_side_x = 1 + (b.xMax >> 4) - (b.xMin >> 4);
            chunk_side_z = 1 + (b.zMax >> 4) - (b.zMin >> 4);
            this.xOffset = b.xMin & 0xFFFFFFF0;
            this.zOffset = b.zMin & 0xFFFFFFF0;
            int x_add = this.range * 2 + 1 - chunk_side_x;
            if (x_add > 0) {
                chunk_side_x += x_add;
                this.xOffset -= ((x_add & 0xFFFFFFFE) << 3) + (x_add % 2 != 0 && (b.xMax + b.xMin + 1) / 2 % 16 <= 8 ? 16 : 0);
            }
            if ((z_add = this.range * 2 + 1 - chunk_side_z) > 0) {
                chunk_side_z += z_add;
                this.zOffset -= ((z_add & 0xFFFFFFFE) << 3) + (z_add % 2 != 0 && (b.zMax + b.zMin + 1) / 2 % 16 <= 8 ? 16 : 0);
            }
        } else {
            this.quarryRange = false;
            chunk_side_x = chunk_side_z = 1 + this.range * 2;
            this.xOffset = (x >> 4) - this.range << 4;
            this.zOffset = (z >> 4) - this.range << 4;
        }
        if (!this.quarryRange) {
            b = null;
        }
        this.block_side_x = chunk_side_x * 16;
        this.block_side_z = chunk_side_z * 16;
        this.blocks = new byte[256 - this.yOffset][this.block_side_x][this.block_side_z];
        this.ebses = new ExtendedBlockStorage[chunk_side_x][chunk_side_z][];
        for (int kx = 0; kx < chunk_side_x; ++kx) {
            for (int kz = 0; kz < chunk_side_z; ++kz) {
                this.ebses[kx][kz] = this.field_145850_b.func_72863_F().func_73158_c(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4)).func_76587_i();
            }
        }
        TilePump.S_put(x - this.xOffset, y, z - this.zOffset);
        while (cp != cg) {
            ExtendedBlockStorage ebs_c = this.ebses[xb[cg] >> 4][zb[cg] >> 4][yb[cg] >> 4];
            if (ebs_c != null) {
                Block b_c = ebs_c.func_150819_a(xb[cg] & 0xF, yb[cg] & 0xF, zb[cg] & 0xF);
                if (this.blocks[yb[cg] - this.yOffset][xb[cg]][zb[cg]] == 0 && TilePump.isLiquid(b_c, false, null, 0, 0, 0, 0)) {
                    this.blocks[TilePump.yb[TilePump.cg] - this.yOffset][TilePump.xb[TilePump.cg]][TilePump.zb[TilePump.cg]] = 63;
                    if ((b != null ? b.xMin & 0xF : 0) < xb[cg]) {
                        TilePump.S_put(xb[cg] - 1, yb[cg], zb[cg]);
                    } else {
                        this.blocks[TilePump.yb[TilePump.cg] - this.yOffset][TilePump.xb[TilePump.cg]][TilePump.zb[TilePump.cg]] = 127;
                    }
                    if (xb[cg] < (b != null ? b.xMax - this.xOffset : this.block_side_x - 1)) {
                        TilePump.S_put(xb[cg] + 1, yb[cg], zb[cg]);
                    } else {
                        this.blocks[TilePump.yb[TilePump.cg] - this.yOffset][TilePump.xb[TilePump.cg]][TilePump.zb[TilePump.cg]] = 127;
                    }
                    if ((b != null ? b.zMin & 0xF : 0) < zb[cg]) {
                        TilePump.S_put(xb[cg], yb[cg], zb[cg] - 1);
                    } else {
                        this.blocks[TilePump.yb[TilePump.cg] - this.yOffset][TilePump.xb[TilePump.cg]][TilePump.zb[TilePump.cg]] = 127;
                    }
                    if (zb[cg] < (b != null ? b.zMax - this.zOffset : this.block_side_z - 1)) {
                        TilePump.S_put(xb[cg], yb[cg], zb[cg] + 1);
                    } else {
                        this.blocks[TilePump.yb[TilePump.cg] - this.yOffset][TilePump.xb[TilePump.cg]][TilePump.zb[TilePump.cg]] = 127;
                    }
                    if (yb[cg] + 1 < 256) {
                        TilePump.S_put(xb[cg], yb[cg] + 1, zb[cg]);
                    }
                }
            }
            if (++cg != 524288) continue;
            cg = 0;
        }
    }

    boolean S_removeLiquids(APowerTile tbpp, int x, int y, int z) {
        int bz;
        int bx;
        this.S_sendNowPacket();
        if (this.cx != x || this.cy != y || this.cz != z || this.py < this.cy || this.field_145850_b.func_72820_D() - this.fwt > 200L) {
            this.S_searchLiquid(x, y, z);
        } else {
            this.ebses = new ExtendedBlockStorage[this.ebses.length][this.ebses[0].length][];
            for (int kx = 0; kx < this.ebses.length; ++kx) {
                for (int kz = 0; kz < this.ebses[0].length; ++kz) {
                    this.ebses[kx][kz] = this.field_145850_b.func_72863_F().func_73158_c(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4)).func_76587_i();
                }
            }
        }
        int count = 0;
        while (true) {
            if (this.px == -1) {
                for (bx = 0; bx < this.block_side_x; ++bx) {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        Block bb;
                        if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0 || !TilePump.isLiquid(bb = this.ebses[bx >> 4][bz >> 4][this.py >> 4].func_150819_a(bx & 0xF, this.py & 0xF, bz & 0xF), false, null, 0, 0, 0, 0)) continue;
                        ++count;
                    }
                }
            } else {
                for (bz = 0; bz < this.block_side_z; ++bz) {
                    int meta;
                    Block bb;
                    if (this.blocks[this.py - this.yOffset][this.px][bz] == 0 || !TilePump.isLiquid(bb = this.ebses[this.px >> 4][bz >> 4][this.py >> 4].func_150819_a(this.px & 0xF, this.py & 0xF, bz & 0xF), true, this.field_145850_b, this.px + this.xOffset, this.py, bz + this.zOffset, meta = this.ebses[this.px >> 4][bz >> 4][this.py >> 4].func_76665_b(this.px & 0xF, this.py & 0xF, bz & 0xF))) continue;
                    ++count;
                }
            }
            if (count <= 0 && ++this.px < this.block_side_x) continue;
            if (count > 0) break;
            this.px = -1;
            if (--this.py < this.cy) break;
        }
        if (count > 0 && PowerManager.useEnergyP(tbpp, this.unbreaking, count, this.px == -1 ? (long)count : 0L)) {
            if (this.px == -1) {
                for (bx = 0; bx < this.block_side_x; ++bx) {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0) continue;
                        this.drainBlock(bx, bz, QuarryPlusI.blockFrame);
                    }
                }
            } else {
                for (bz = 0; bz < this.block_side_z; ++bz) {
                    if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                    this.drainBlock(this.px, bz, Blocks.field_150350_a);
                }
            }
        }
        this.S_sendNowPacket();
        return this.py < this.cy;
    }

    public IChatComponent[] C_getNames() {
        IChatComponent[] ret = new IChatComponent[this.liquids.size() + 1];
        if (this.liquids.size() > 0) {
            ret[0] = new ChatComponentTranslation("chat.pumpcontain", new Object[0]);
            for (int i = 0; i < this.liquids.size(); ++i) {
                FluidStack s = this.liquids.get(i);
                ret[i + 1] = new ChatComponentTranslation("yog.pump.liquid", new Object[]{new ChatComponentTranslation(s.getFluid().getUnlocalizedName(s), new Object[0]), Integer.toString(s.amount)});
            }
        } else {
            ret[0] = new ChatComponentTranslation("chat.pumpcontainno", new Object[0]);
        }
        return ret;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection fd, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        int index = this.liquids.indexOf(resource);
        if (index == -1) {
            return null;
        }
        FluidStack fs = this.liquids.get(index);
        if (fs == null) {
            return null;
        }
        FluidStack ret = fs.copy();
        ret.amount = Math.min(fs.amount, resource.amount);
        if (doDrain) {
            fs.amount -= ret.amount;
        }
        if (fs.amount <= 0) {
            this.liquids.remove(fs);
        }
        if (ret.amount <= 0) {
            return null;
        }
        return ret;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection fd) {
        if (fd.ordinal() < 0 || fd.ordinal() >= this.mapping.length) {
            return this.getTankInfo(ForgeDirection.UP);
        }
        LinkedList<FluidTankInfo> ret = new LinkedList<FluidTankInfo>();
        if (this.mapping[fd.ordinal()].size() <= 0) {
            if (this.liquids.size() <= 0) {
                for (Integer i : FluidRegistry.getRegisteredFluidIDs().values()) {
                    ret.add(new FluidTankInfo(new FluidStack(i.intValue(), 0), Integer.MAX_VALUE));
                }
            } else {
                for (FluidStack fs : this.liquids) {
                    ret.add(new FluidTankInfo(fs, Integer.MAX_VALUE));
                }
            }
        } else {
            for (String s : this.mapping[fd.ordinal()]) {
                FluidStack fs = FluidRegistry.getFluidStack((String)s, (int)0);
                if (fs == null) continue;
                int index = this.liquids.indexOf(fs);
                if (index != -1) {
                    ret.add(new FluidTankInfo(this.liquids.get(index), Integer.MAX_VALUE));
                    continue;
                }
                ret.add(new FluidTankInfo(fs, Integer.MAX_VALUE));
            }
        }
        return ret.toArray(new FluidTankInfo[ret.size()]);
    }

    public FluidStack drain(ForgeDirection fd, int maxDrain, boolean doDrain) {
        if (fd.ordinal() < 0 || fd.ordinal() >= this.mapping.length) {
            return this.drain(ForgeDirection.UP, maxDrain, doDrain);
        }
        if (this.mapping[fd.ordinal()].size() <= 0) {
            if (this.liquids.size() <= 0) {
                return null;
            }
            return this.drain(fd, this.liquids.getFirst(), doDrain);
        }
        for (String s : this.mapping[fd.ordinal()]) {
            int index;
            FluidStack fs = FluidRegistry.getFluidStack((String)s, (int)maxDrain);
            if (fs == null || (index = this.liquids.indexOf(fs)) == -1) continue;
            return this.drain(fd, this.liquids.get(index), doDrain);
        }
        return null;
    }

    static final boolean isLiquid(Block b, boolean s, World w, int x, int y, int z, int m) {
        if (b instanceof IFluidBlock) {
            return !s || ((IFluidBlock)b).canDrain(w, x, y, z);
        }
        if (b == Blocks.field_150355_j || b == Blocks.field_150358_i || b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
            return !s || m == 0;
        }
        return false;
    }

    private final void drainBlock(int bx, int bz, Block tb) {
        Block b = this.ebses[bx >> 4][bz >> 4][this.py >> 4].func_150819_a(bx & 0xF, this.py & 0xF, bz & 0xF);
        int meta = this.ebses[bx >> 4][bz >> 4][this.py >> 4].func_76665_b(bx & 0xF, this.py & 0xF, bz & 0xF);
        if (TilePump.isLiquid(b, false, null, 0, 0, 0, 0)) {
            FluidStack fs = null;
            if (b instanceof IFluidBlock && ((IFluidBlock)b).canDrain(this.field_145850_b, bx + this.xOffset, this.py, bz + this.zOffset)) {
                fs = ((IFluidBlock)b).drain(this.field_145850_b, bx + this.xOffset, this.py, bz + this.zOffset, true);
            } else if ((b == Blocks.field_150355_j || b == Blocks.field_150358_i) && meta == 0) {
                fs = new FluidStack(FluidRegistry.WATER, 1000);
            } else if ((b == Blocks.field_150353_l || b == Blocks.field_150356_k) && meta == 0) {
                fs = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            if (fs != null) {
                int index = this.liquids.indexOf(fs);
                if (index != -1) {
                    this.liquids.get((int)index).amount += fs.amount;
                } else {
                    this.liquids.add(fs);
                }
                fs = null;
            }
            this.field_145850_b.func_147449_b(bx + this.xOffset, this.py, bz + this.zOffset, tb);
        }
    }

    @Override
    public Map<Integer, Byte> get() {
        HashMap<Integer, Byte> ret = new HashMap<Integer, Byte>();
        if (this.fortune > 0) {
            ret.put(Enchantment.field_77346_s.field_77352_x, this.fortune);
        }
        if (this.unbreaking > 0) {
            ret.put(Enchantment.field_77347_r.field_77352_x, this.unbreaking);
        }
        if (this.silktouch) {
            ret.put(Enchantment.field_77348_q.field_77352_x, (byte)1);
        }
        return ret;
    }

    @Override
    public void set(int id, byte val) {
        if (id == Enchantment.field_77346_s.field_77352_x) {
            this.fortune = val;
        } else if (id == Enchantment.field_77347_r.field_77352_x) {
            this.unbreaking = val;
        } else if (id == Enchantment.field_77348_q.field_77352_x && val > 0) {
            this.silktouch = true;
        }
    }
}

