/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.core.IAreaProvider;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.block.BlockMarker;
import com.yogpc.qp.entity.EntityLaser;
import com.yogpc.qp.tile.APacketTile;
import cpw.mods.fml.common.Optional;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

@Optional.Interface(iface="buildcraft.api.core.IAreaProvider", modid="BuildCraftAPI|core")
public class TileMarker
extends APacketTile
implements IAreaProvider {
    public static final ArrayList<Link> linkList = new ArrayList();
    public static final ArrayList<Laser> laserList = new ArrayList();
    private static final int MAX_SIZE = 256;
    public Link link;
    public Laser laser;
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean vlF;

    @PacketHandler.Handler
    public static void recievePacket(byte[] pdata) {
        int index;
        ByteArrayDataInput data = ByteStreams.newDataInput((byte[])pdata);
        byte flag = data.readByte();
        int dimId = data.readInt();
        World w = QuarryPlus.proxy.getClientWorld();
        if (w.field_73011_w.field_76574_g != dimId) {
            return;
        }
        if (flag == 0) {
            int index2 = linkList.indexOf(new Link(w, data.readInt(), data.readInt(), data.readInt(), data.readInt(), data.readInt(), data.readInt()));
            if (index2 >= 0) {
                linkList.get(index2).removeConnection(false);
            }
        } else if (flag == 1 && (index = laserList.indexOf(new BlockIndex(w, data.readInt(), data.readInt(), data.readInt()))) >= 0) {
            laserList.get(index).destructor();
        }
    }

    public int xMin() {
        return this.link == null ? this.field_145851_c : this.link.xn;
    }

    public int yMin() {
        return this.link == null ? this.field_145848_d : this.link.yn;
    }

    public int zMin() {
        return this.link == null ? this.field_145849_e : this.link.zn;
    }

    public int xMax() {
        return this.link == null ? this.field_145851_c : this.link.xx;
    }

    public int yMax() {
        return this.link == null ? this.field_145848_d : this.link.yx;
    }

    public int zMax() {
        return this.link == null ? this.field_145849_e : this.link.zx;
    }

    public void removeFromWorld() {
        if (this.link == null) {
            QuarryPlusI.blockMarker.func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        ArrayList<ItemStack> al = this.link.removeConnection(true);
        for (ItemStack is : al) {
            float f = 0.7f;
            double d0 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d2 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + d0, (double)this.field_145848_d + d1, (double)this.field_145849_e + d2, is);
            entityitem.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public Collection<ItemStack> removeFromWorldWithItem() {
        if (this.link != null) {
            return this.link.removeConnection(true);
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        ret.addAll(QuarryPlusI.blockMarker.getDrops(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0));
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return ret;
    }

    private static void S_renewConnection(Link l, World w, int x, int y, int z) {
        Block b;
        int tx = 0;
        int ty = 0;
        int tz = 0;
        if (l.xx == l.xn) {
            for (tx = 1; tx <= 256; ++tx) {
                b = w.func_147439_a(x + tx, y, z);
                if (b instanceof BlockMarker && !linkList.contains(new BlockIndex(w, x + tx, y, z))) {
                    l.xx = x + tx;
                    break;
                }
                b = w.func_147439_a(x - tx, y, z);
                if (!(b instanceof BlockMarker) || linkList.contains(new BlockIndex(w, x - tx, y, z))) continue;
                tx = -tx;
                l.xn = x + tx;
                break;
            }
            if (l.xx == l.xn) {
                tx = 0;
            }
        }
        if (l.yx == l.yn) {
            for (ty = 1; ty <= 256; ++ty) {
                b = w.func_147439_a(x, y + ty, z);
                if (b instanceof BlockMarker && !linkList.contains(new BlockIndex(w, x, y + ty, z))) {
                    l.yx = y + ty;
                    break;
                }
                b = w.func_147439_a(x, y - ty, z);
                if (!(b instanceof BlockMarker) || linkList.contains(new BlockIndex(w, x, y - ty, z))) continue;
                ty = -ty;
                l.yn = y + ty;
                break;
            }
            if (l.yx == l.yn) {
                ty = 0;
            }
        }
        if (l.zx == l.zn) {
            for (tz = 1; tz <= 256; ++tz) {
                b = w.func_147439_a(x, y, z + tz);
                if (b instanceof BlockMarker && !linkList.contains(new BlockIndex(w, x, y, z + tz))) {
                    l.zx = z + tz;
                    break;
                }
                b = w.func_147439_a(x, y, z - tz);
                if (!(b instanceof BlockMarker) || linkList.contains(new BlockIndex(w, x, y, z - tz))) continue;
                tz = -tz;
                l.zn = z + tz;
                break;
            }
            if (l.zx == l.zn) {
                tz = 0;
            }
        }
        if (l.xx == l.xn && ty != 0) {
            TileMarker.S_renewConnection(l, w, x, y + ty, z);
        }
        if (l.xx == l.xn && tz != 0) {
            TileMarker.S_renewConnection(l, w, x, y, z + tz);
        }
        if (l.yx == l.yn && tx != 0) {
            TileMarker.S_renewConnection(l, w, x + tx, y, z);
        }
        if (l.yx == l.yn && tz != 0) {
            TileMarker.S_renewConnection(l, w, x, y, z + tz);
        }
        if (l.zx == l.zn && tx != 0) {
            TileMarker.S_renewConnection(l, w, x + tx, y, z);
        }
        if (l.zx == l.zn && ty != 0) {
            TileMarker.S_renewConnection(l, w, x, y + ty, z);
        }
    }

    public void G_updateSignal() {
        if (this.laser != null) {
            this.laser.destructor();
            this.laser = null;
        }
        if ((this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) && (this.link == null || this.link.xn == this.link.xx || this.link.yn == this.link.yx || this.link.zn == this.link.zx)) {
            this.laser = new Laser(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.link);
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendPacketToAround(this, (byte)6);
        }
    }

    public void S_tryConnection() {
        if (this.link != null) {
            this.link.removeConnection(false);
        }
        this.link = new Link(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        TileMarker.S_renewConnection(this.link, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.link.xx == this.link.xn && this.link.yx == this.link.yn && this.link.zx == this.link.zn) {
            this.link = null;
            return;
        }
        this.link.init();
        this.link.makeLaser();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(this.link.xx);
            dos.writeInt(this.link.xn);
            dos.writeInt(this.link.yx);
            dos.writeInt(this.link.yn);
            dos.writeInt(this.link.zx);
            dos.writeInt(this.link.zn);
            PacketHandler.sendPacketToAround(new YogpstopPacket(bos.toByteArray(), this, 7), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.G_updateSignal();
    }

    @Override
    public void S_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        switch (id) {
            case 14: {
                if (this.link == null) break;
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    dos.writeInt(this.link.xx);
                    dos.writeInt(this.link.xn);
                    dos.writeInt(this.link.yx);
                    dos.writeInt(this.link.yn);
                    dos.writeInt(this.link.zx);
                    dos.writeInt(this.link.zn);
                    PacketHandler.sendPacketToPlayer(new YogpstopPacket(bos.toByteArray(), this, 7), ep);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    void G_destroy() {
        if (this.link != null) {
            this.link.removeConnection(false);
        }
        if (this.laser != null) {
            this.laser.destructor();
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        ByteArrayDataInput badi = ByteStreams.newDataInput((byte[])data);
        switch (id) {
            case 7: {
                if (this.link != null) {
                    this.link.removeConnection(false);
                }
                this.link = new Link(this.field_145850_b, badi.readInt(), badi.readInt(), badi.readInt(), badi.readInt(), badi.readInt(), badi.readInt());
                this.link.init();
                this.link.makeLaser();
            }
            case 6: {
                this.G_updateSignal();
            }
        }
    }

    public void requestTicket() {
        if (this.chunkTicket != null) {
            return;
        }
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)QuarryPlus.I, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.chunkTicket == null) {
            return;
        }
        NBTTagCompound tag = this.chunkTicket.getModData();
        tag.func_74768_a("quarryX", this.field_145851_c);
        tag.func_74768_a("quarryY", this.field_145848_d);
        tag.func_74768_a("quarryZ", this.field_145849_e);
        this.forceChunkLoading(this.chunkTicket);
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        ChunkCoordIntPair quarryChunk = new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)quarryChunk);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.vlF) {
            this.vlF = false;
            int i = linkList.indexOf((Object)this);
            if (i >= 0) {
                this.link = linkList.get(i);
            }
            if ((i = laserList.indexOf((Object)this)) >= 0) {
                this.laser = laserList.get(i);
            }
            this.G_updateSignal();
            if (this.field_145850_b.field_72995_K) {
                PacketHandler.sendPacketToServer(this, (byte)14);
            }
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.vlF = true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) != QuarryPlusI.blockMarker) {
            this.G_destroy();
        }
    }

    public static class Link {
        public int xx;
        public int xn;
        public int yx;
        public int yn;
        public int zx;
        public int zn;
        private final EntityLaser[] lasers = new EntityLaser[12];
        public final World w;

        Link(World pw, int vx, int vy, int vz) {
            this.xx = vx;
            this.xn = vx;
            this.yx = vy;
            this.yn = vy;
            this.zx = vz;
            this.zn = vz;
            this.w = pw;
        }

        Link(World pw, int vxx, int vxn, int vyx, int vyn, int vzx, int vzn) {
            this.xx = vxx;
            this.xn = vxn;
            this.yx = vyx;
            this.yn = vyn;
            this.zx = vzx;
            this.zn = vzn;
            this.w = pw;
        }

        private final void connect(TileEntity te) {
            if (te instanceof TileMarker) {
                if (((TileMarker)te).link != null && ((TileMarker)te).link != this) {
                    ((TileMarker)te).link.removeConnection(false);
                }
                ((TileMarker)te).link = this;
            }
        }

        private final ArrayList<ItemStack> removeLink(int x, int y, int z, boolean bb) {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            TileEntity te = this.w.func_147438_o(x, y, z);
            Block b = this.w.func_147439_a(x, y, z);
            if (b instanceof BlockMarker) {
                if (te instanceof TileMarker) {
                    ((TileMarker)te).link = null;
                }
                ret.addAll(b.getDrops(this.w, x, y, z, this.w.func_72805_g(x, y, z), 0));
                if (bb) {
                    this.w.func_147468_f(x, y, z);
                }
            }
            return ret;
        }

        void init() {
            int i = linkList.indexOf(this);
            if (i >= 0) {
                linkList.get(i).removeConnection(false);
            }
            linkList.add(this);
            this.connect(this.w.func_147438_o(this.xn, this.yn, this.zn));
            this.connect(this.w.func_147438_o(this.xn, this.yn, this.zx));
            this.connect(this.w.func_147438_o(this.xn, this.yx, this.zn));
            this.connect(this.w.func_147438_o(this.xn, this.yx, this.zx));
            this.connect(this.w.func_147438_o(this.xx, this.yn, this.zn));
            this.connect(this.w.func_147438_o(this.xx, this.yn, this.zx));
            this.connect(this.w.func_147438_o(this.xx, this.yx, this.zn));
            this.connect(this.w.func_147438_o(this.xx, this.yx, this.zx));
        }

        public ArrayList<ItemStack> removeConnection(boolean bb) {
            linkList.remove(this);
            if (!this.w.field_72995_K) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    dos.writeByte(0);
                    dos.writeInt(this.w.field_73011_w.field_76574_g);
                    dos.writeInt(this.xx);
                    dos.writeInt(this.xn);
                    dos.writeInt(this.yx);
                    dos.writeInt(this.yn);
                    dos.writeInt(this.zx);
                    dos.writeInt(this.zn);
                    PacketHandler.sendPacketToDimension(new YogpstopPacket(bos.toByteArray(), TileMarker.class), this.w.field_73011_w.field_76574_g);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.deleteLaser();
            ArrayList<ItemStack> i = new ArrayList<ItemStack>();
            i.addAll(this.removeLink(this.xn, this.yn, this.zn, bb));
            i.addAll(this.removeLink(this.xn, this.yn, this.zx, bb));
            i.addAll(this.removeLink(this.xn, this.yx, this.zn, bb));
            i.addAll(this.removeLink(this.xn, this.yx, this.zx, bb));
            i.addAll(this.removeLink(this.xx, this.yn, this.zn, bb));
            i.addAll(this.removeLink(this.xx, this.yn, this.zx, bb));
            i.addAll(this.removeLink(this.xx, this.yx, this.zn, bb));
            i.addAll(this.removeLink(this.xx, this.yx, this.zx, bb));
            return i;
        }

        void makeLaser() {
            this.deleteLaser();
            byte flag = 0;
            double a = 0.5;
            double b = 0.45;
            double c = 0.1;
            if (this.xn != this.xx) {
                flag = (byte)(flag | 1);
            }
            if (this.yn != this.yx) {
                flag = (byte)(flag | 2);
            }
            if (this.zn != this.zx) {
                flag = (byte)(flag | 4);
            }
            if ((flag & 1) == 1) {
                this.lasers[0] = new EntityLaser(this.w, (double)this.xn + 0.5, (double)this.yn + 0.45, (double)this.zn + 0.45, this.xx - this.xn, 0.1, 0.1, 3);
            }
            if ((flag & 2) == 2) {
                this.lasers[4] = new EntityLaser(this.w, (double)this.xn + 0.45, (double)this.yn + 0.5, (double)this.zn + 0.45, 0.1, this.yx - this.yn, 0.1, 3);
            }
            if ((flag & 4) == 4) {
                this.lasers[8] = new EntityLaser(this.w, (double)this.xn + 0.45, (double)this.yn + 0.45, (double)this.zn + 0.5, 0.1, 0.1, this.zx - this.zn, 3);
            }
            if ((flag & 3) == 3) {
                this.lasers[2] = new EntityLaser(this.w, (double)this.xn + 0.5, (double)this.yx + 0.45, (double)this.zn + 0.45, this.xx - this.xn, 0.1, 0.1, 3);
                this.lasers[6] = new EntityLaser(this.w, (double)this.xx + 0.45, (double)this.yn + 0.5, (double)this.zn + 0.45, 0.1, this.yx - this.yn, 0.1, 3);
            }
            if ((flag & 5) == 5) {
                this.lasers[1] = new EntityLaser(this.w, (double)this.xn + 0.5, (double)this.yn + 0.45, (double)this.zx + 0.45, this.xx - this.xn, 0.1, 0.1, 3);
                this.lasers[9] = new EntityLaser(this.w, (double)this.xx + 0.45, (double)this.yn + 0.45, (double)this.zn + 0.5, 0.1, 0.1, this.zx - this.zn, 3);
            }
            if ((flag & 6) == 6) {
                this.lasers[5] = new EntityLaser(this.w, (double)this.xn + 0.45, (double)this.yn + 0.5, (double)this.zx + 0.45, 0.1, this.yx - this.yn, 0.1, 3);
                this.lasers[10] = new EntityLaser(this.w, (double)this.xn + 0.45, (double)this.yx + 0.45, (double)this.zn + 0.5, 0.1, 0.1, this.zx - this.zn, 3);
            }
            if ((flag & 7) == 7) {
                this.lasers[3] = new EntityLaser(this.w, (double)this.xn + 0.5, (double)this.yx + 0.45, (double)this.zx + 0.45, this.xx - this.xn, 0.1, 0.1, 3);
                this.lasers[7] = new EntityLaser(this.w, (double)this.xx + 0.45, (double)this.yn + 0.5, (double)this.zx + 0.45, 0.1, this.yx - this.yn, 0.1, 3);
                this.lasers[11] = new EntityLaser(this.w, (double)this.xx + 0.45, (double)this.yx + 0.45, (double)this.zn + 0.5, 0.1, 0.1, this.zx - this.zn, 3);
            }
            for (EntityLaser eb : this.lasers) {
                if (eb == null) continue;
                eb.field_70170_p.func_72838_d((Entity)eb);
            }
        }

        void deleteLaser() {
            for (EntityLaser eb : this.lasers) {
                if (eb == null) continue;
                QuarryPlus.proxy.removeEntity(eb);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof BlockIndex) {
                BlockIndex bi = (BlockIndex)o;
                return !(bi.x != this.xn && bi.x != this.xx || bi.y != this.yn && bi.y != this.yx || bi.z != this.zn && bi.z != this.zx || this.w != bi.w);
            }
            if (o instanceof TileEntity) {
                TileEntity te = (TileEntity)o;
                return !(te.field_145851_c != this.xn && te.field_145851_c != this.xx || te.field_145848_d != this.yn && te.field_145848_d != this.yx || te.field_145849_e != this.zn && te.field_145849_e != this.zx || this.w != te.func_145831_w());
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link l = (Link)o;
            return l.xn == this.xn && l.xx == this.xx && l.yn == this.yn && l.yx == this.yx && l.zn == this.zn && l.zx == this.zx && l.w == this.w;
        }

        public int hashCode() {
            return this.xn << 26 ^ this.xx << 21 ^ this.yn << 16 ^ this.yx << 11 ^ this.zn << 6 ^ this.zx;
        }
    }

    public static class Laser {
        public final World w;
        final int x;
        final int y;
        final int z;
        private final EntityLaser[] lasers = new EntityLaser[3];

        Laser(World pw, int px, int py, int pz, Link l) {
            double a = 0.5;
            double b = 0.45;
            double c = 0.1;
            this.x = px;
            this.y = py;
            this.z = pz;
            this.w = pw;
            if (l == null || l.xn == l.xx) {
                this.lasers[0] = new EntityLaser(pw, (double)(px - 256) + 0.5, (double)py + 0.45, (double)pz + 0.45, 512.0, 0.1, 0.1, 2);
            }
            if (l == null || l.yn == l.yx) {
                this.lasers[1] = new EntityLaser(pw, (double)px + 0.45, 0.5, (double)pz + 0.45, 0.1, 255.0, 0.1, 2);
            }
            if (l == null || l.zn == l.zx) {
                this.lasers[2] = new EntityLaser(pw, (double)px + 0.45, (double)py + 0.45, (double)(pz - 256) + 0.5, 0.1, 0.1, 512.0, 2);
            }
            for (EntityLaser eb : this.lasers) {
                if (eb == null) continue;
                eb.field_70170_p.func_72838_d((Entity)eb);
            }
            int i = laserList.indexOf(this);
            if (i >= 0) {
                laserList.get(i).destructor();
            }
            laserList.add(this);
        }

        public void destructor() {
            laserList.remove(this);
            if (!this.w.field_72995_K) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    dos.writeByte(1);
                    dos.writeInt(this.w.field_73011_w.field_76574_g);
                    dos.writeInt(this.x);
                    dos.writeInt(this.y);
                    dos.writeInt(this.z);
                    PacketHandler.sendPacketToDimension(new YogpstopPacket(bos.toByteArray(), TileMarker.class), this.w.field_73011_w.field_76574_g);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (EntityLaser eb : this.lasers) {
                if (eb == null) continue;
                QuarryPlus.proxy.removeEntity(eb);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof BlockIndex) {
                BlockIndex bi = (BlockIndex)o;
                return bi.x == this.x && bi.y == this.y && bi.z == this.z && bi.w == this.w;
            }
            if (o instanceof TileEntity) {
                TileEntity te = (TileEntity)o;
                return te.field_145851_c == this.x && te.field_145848_d == this.y && te.field_145849_e == this.z && this.w == te.func_145831_w();
            }
            if (!(o instanceof Laser)) {
                return false;
            }
            Laser l = (Laser)o;
            return l.x == this.x && l.y == this.y && l.z == this.z && l.w == this.w;
        }

        public int hashCode() {
            return this.x << 21 ^ this.y << 11 ^ this.z;
        }
    }

    static class BlockIndex {
        final World w;
        final int x;
        final int y;
        final int z;

        BlockIndex(World pw, int px, int py, int pz) {
            this.w = pw;
            this.x = px;
            this.y = py;
            this.z = pz;
        }
    }
}

