/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.ReflectionHelper;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.container.IPacketContainer;
import com.yogpc.qp.tile.APacketTile;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<YogpstopPacket> {
    private static final Map<String, Method> registeredStaticHandlers = new HashMap<String, Method>();
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    static final byte Tile = 0;
    static final byte NBT = 1;
    static final byte WINPROP = 2;
    static final byte STATIC = 3;
    static final byte KEY = 4;
    public static final byte StC_OPENGUI_MAPPING = 3;
    public static final byte StC_NOW = 4;
    public static final byte StC_HEAD_POS = 5;
    public static final byte StC_UPDATE_MARKER = 6;
    public static final byte StC_LINK_RES = 7;
    public static final byte CtS_REMOVE_FORTUNE = 10;
    public static final byte CtS_REMOVE_SILKTOUCH = 11;
    public static final byte CtS_TOGGLE_FORTUNE = 12;
    public static final byte CtS_TOGGLE_SILKTOUCH = 13;
    public static final byte CtS_LINK_REQ = 14;
    public static final byte CtS_INFMJSRC = 15;
    public static final byte CtS_ADD_MAPPING = 16;
    public static final byte CtS_REMOVE_MAPPING = 17;
    public static final byte CtS_UP_MAPPING = 18;
    public static final byte CtS_DOWN_MAPPING = 19;
    public static final byte CtS_TOP_MAPPING = 20;
    public static final byte CtS_BOTTOM_MAPPING = 21;
    public static final byte CtS_RENEW_DIRECTION = 22;
    public static final byte CtS_COPY_MAPPING = 23;
    public static final byte remove_link = 0;
    public static final byte remove_laser = 1;

    public static final void registerStaticHandler(Class<?> c) {
        List<Method> l = ReflectionHelper.getMethods(c, Handler.class);
        if (l.size() == 1) {
            registeredStaticHandlers.put(c.getName(), l.get(0));
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, YogpstopPacket packet) throws Exception {
        if (packet.getChannel() == 1) {
            PacketHandler.setNBTFromPacket(packet);
        } else if (packet.getChannel() == 2) {
            Container container = packet.getPlayer().field_71070_bA;
            if (container instanceof IPacketContainer && container.field_75152_c == packet.getHeader()[0]) {
                ((IPacketContainer)container).receivePacket(packet.getData());
            }
        } else if (packet.getChannel() == 0) {
            ByteArrayDataInput hdr = ByteStreams.newDataInput((byte[])packet.getHeader());
            TileEntity t = packet.getPlayer().field_70170_p.func_147438_o(hdr.readInt(), hdr.readInt(), hdr.readInt());
            if (t instanceof APacketTile) {
                APacketTile tb = (APacketTile)t;
                if (tb.func_145831_w().field_72995_K) {
                    tb.C_recievePacket(hdr.readByte(), packet.getData(), packet.getPlayer());
                } else {
                    tb.S_recievePacket(hdr.readByte(), packet.getData(), packet.getPlayer());
                }
            }
        } else if (packet.getChannel() == 3) {
            ByteArrayDataInput hdr = ByteStreams.newDataInput((byte[])packet.getHeader());
            ReflectionHelper.invoke(registeredStaticHandlers.get(hdr.readUTF()), null, new Object[]{packet.getData()});
        } else if (packet.getChannel() == 4) {
            QuarryPlus.proxy.setKeys(packet.getPlayer(), packet.getData()[0] << 24 | packet.getData()[1] << 16 | packet.getData()[2] << 8 | packet.getData()[3]);
        }
    }

    public static void sendPacketToServer(YogpstopPacket p) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeOutbound(new Object[]{p});
    }

    public static void sendPacketToAround(YogpstopPacket p, int d, int x, int y, int z) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(d, (double)x, (double)y, (double)z, 256.0));
        channels.get(Side.SERVER).writeOutbound(new Object[]{p});
    }

    public static void sendPacketToDimension(YogpstopPacket p, int d) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new Integer(d));
        channels.get(Side.SERVER).writeOutbound(new Object[]{p});
    }

    public static void sendPacketToPlayer(YogpstopPacket p, EntityPlayer e) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)e);
        channels.get(Side.SERVER).writeOutbound(new Object[]{p});
    }

    private static void setNBTFromPacket(YogpstopPacket p) {
        try {
            NBTTagCompound cache = CompressedStreamTools.func_152457_a((byte[])p.getData(), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            TileEntity te = p.getPlayer().field_70170_p.func_147438_o(cache.func_74762_e("x"), cache.func_74762_e("y"), cache.func_74762_e("z"));
            if (te != null) {
                te.func_145839_a(cache);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendPacketToServer(APacketTile te, byte id, byte pos, String data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeByte(pos);
            dos.writeUTF(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PacketHandler.sendPacketToServer(new YogpstopPacket(bos.toByteArray(), te, id));
    }

    public static void sendNowPacket(APacketTile te, byte data) {
        PacketHandler.sendPacketToAround(new YogpstopPacket(new byte[]{data}, te, 4), te.func_145831_w().field_73011_w.field_76574_g, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static void sendPacketToServer(APacketTile te, byte id) {
        PacketHandler.sendPacketToServer(new YogpstopPacket(new byte[0], te, id));
    }

    public static void sendPacketToAround(APacketTile te, byte id) {
        PacketHandler.sendPacketToAround(new YogpstopPacket(new byte[0], te, id), te.func_145831_w().field_73011_w.field_76574_g, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Handler {
    }
}

