/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.google.common.collect.Lists;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.tile.TileMarker;
import com.yogpc.qp.tile.TileQuarry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadingHandler
implements ForgeChunkManager.OrderedLoadingCallback {
    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int quarryZ;
            int quarryY;
            int quarryX = ticket.getModData().func_74762_e("quarryX");
            TileEntity te = world.func_147438_o(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ"));
            if (te instanceof TileQuarry) {
                ((TileQuarry)te).forceChunkLoading(ticket);
                continue;
            }
            if (!(te instanceof TileMarker)) continue;
            ((TileMarker)te).forceChunkLoading(ticket);
        }
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        ArrayList validTickets = Lists.newArrayList();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int quarryZ;
            int quarryY;
            int quarryX = ticket.getModData().func_74762_e("quarryX");
            Block b = world.func_147439_a(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ"));
            if (b != QuarryPlusI.blockQuarry && b != QuarryPlusI.blockMarker) continue;
            validTickets.add(ticket);
        }
        return validTickets;
    }
}

