/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import openblocks.OpenBlocks;
import openblocks.api.IFlimFlamDescription;
import openblocks.enchantments.flimflams.FlimFlamRegistry;
import openmods.Log;

public class FlimFlamEnchantmentsHandler {
    public static final String LUCK_PROPERTY = "OpenBlocks-Luck";
    public static final int LUCK_MARGIN = -30;
    public static final int EFFECT_DELAY = 300;
    private static final Random RANDOM = new Random();

    private static Luck getProperty(Entity entity) {
        IExtendedEntityProperties prop = entity.getExtendedProperties(LUCK_PROPERTY);
        return prop instanceof Luck ? (Luck)prop : null;
    }

    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing evt) {
        if (evt.entity instanceof EntityPlayer) {
            evt.entity.registerExtendedProperties(LUCK_PROPERTY, (IExtendedEntityProperties)new Luck());
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent e) {
        int flimFlamsToApply;
        EntityPlayer flimFlamTarget;
        if (!(e.entityLiving instanceof EntityPlayer)) {
            return;
        }
        if (e.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer targetPlayer = (EntityPlayer)e.entityLiving;
        if (e.source == null) {
            return;
        }
        Entity damageSource = e.source.func_76346_g();
        if (!(damageSource instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer sourcePlayer = (EntityPlayer)damageSource;
        if (sourcePlayer == targetPlayer) {
            return;
        }
        int sourceFlimFlam = FlimFlamEnchantmentsHandler.getFlimFlamToolLevel(sourcePlayer);
        int targetFlimFlam = FlimFlamEnchantmentsHandler.getFlimFlamArmorLevel(targetPlayer);
        int flimFlamDiff = targetFlimFlam / 3 - sourceFlimFlam;
        if (flimFlamDiff == 0) {
            return;
        }
        if (flimFlamDiff > 0) {
            flimFlamTarget = sourcePlayer;
            flimFlamsToApply = flimFlamDiff;
        } else {
            flimFlamTarget = targetPlayer;
            flimFlamsToApply = -flimFlamDiff;
        }
        Luck victimLuck = FlimFlamEnchantmentsHandler.getProperty((Entity)flimFlamTarget);
        if (victimLuck != null) {
            for (int i = 0; i < flimFlamsToApply; ++i) {
                int roll = FlimFlamEnchantmentsHandler.rollD20();
                if (roll == 20) {
                    victimLuck.forceNext = true;
                }
                victimLuck.luck -= roll;
            }
            if (victimLuck.luck < -30) {
                victimLuck.forceNext = true;
            }
        }
    }

    private static int rollD20() {
        return RANDOM.nextInt(20) + 1;
    }

    public static void deliverKarma(EntityPlayerMP player) {
        if (player.field_70128_L) {
            return;
        }
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        if (property == null || !FlimFlamEnchantmentsHandler.canFlimFlam(property)) {
            return;
        }
        int luck = property.luck;
        int totalWeight = 0;
        ArrayList selectedEffects = Lists.newArrayList();
        for (IFlimFlamDescription effectMeta : FlimFlamRegistry.instance.getFlimFlams()) {
            if (!effectMeta.canApply(luck) || FlimFlamRegistry.BLACKLIST.isBlacklisted(effectMeta)) continue;
            selectedEffects.add(effectMeta);
            totalWeight += effectMeta.weight();
        }
        if (selectedEffects.isEmpty()) {
            return;
        }
        Collections.shuffle(selectedEffects);
        block3: while (!selectedEffects.isEmpty()) {
            int selectedWeight = RANDOM.nextInt(totalWeight);
            int currentWeight = 0;
            Iterator it = selectedEffects.iterator();
            while (it.hasNext()) {
                IFlimFlamDescription effectMeta = (IFlimFlamDescription)it.next();
                if (selectedWeight > (currentWeight += effectMeta.weight())) continue;
                try {
                    if (effectMeta.action().execute(player)) {
                        property.luck -= effectMeta.cost();
                        Log.debug((String)"Player %s flim-flammed with %s, current luck: %s", (Object[])new Object[]{player, effectMeta.name(), property.luck});
                        if (!effectMeta.isSilent()) {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.flim_flammed", new Object[0]));
                        }
                        return;
                    }
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Error during flimflam '%s' execution", (Object[])new Object[]{effectMeta.name()});
                }
                totalWeight -= effectMeta.weight();
                it.remove();
                continue block3;
            }
        }
    }

    public static int getLuck(EntityPlayer player) {
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        return property != null ? property.luck : 0;
    }

    public static int modifyLuck(EntityPlayer player, int amount) {
        Luck property = FlimFlamEnchantmentsHandler.getProperty((Entity)player);
        if (property == null) {
            return 0;
        }
        property.luck += amount;
        return property.luck;
    }

    private static boolean canFlimFlam(Luck property) {
        if (property.forceNext) {
            property.forceNext = false;
            property.cooldown = 300;
            return true;
        }
        if (property.luck > 30 || property.cooldown-- > 0) {
            return false;
        }
        property.cooldown = 300;
        double probability = 1.5 * Math.abs(Math.atan((double)property.luck / 250.0) / Math.PI);
        double r = RANDOM.nextDouble();
        return r < probability;
    }

    private static int getFlimFlamToolLevel(EntityPlayer player) {
        return FlimFlamEnchantmentsHandler.getFlimFlamLevel(player.func_70694_bm());
    }

    private static int getFlimFlamArmorLevel(EntityPlayer player) {
        int sum = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            sum += FlimFlamEnchantmentsHandler.getFlimFlamLevel(stack);
        }
        return sum;
    }

    private static int getFlimFlamLevel(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Integer result = (Integer)enchantments.get(OpenBlocks.Enchantments.flimFlam.field_77352_x);
        return result != null ? result : 0;
    }

    private static class Luck
    implements IExtendedEntityProperties {
        public int luck;
        public int cooldown;
        public boolean forceNext;

        private Luck() {
        }

        public void saveNBTData(NBTTagCompound entityTag) {
            entityTag.func_74768_a(FlimFlamEnchantmentsHandler.LUCK_PROPERTY, this.luck);
        }

        public void loadNBTData(NBTTagCompound entityTag) {
            this.luck = entityTag.func_74762_e(FlimFlamEnchantmentsHandler.LUCK_PROPERTY);
        }

        public void init(Entity entity, World world) {
        }
    }
}

