/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityBigButton;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class BlockBigButton
extends OpenBlock {
    public BlockBigButton() {
        super(Material.field_151594_q);
        this.setRotationMode(BlockRotationMode.FOUR_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
    }

    public boolean canPlaceBlock(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection sideDir, Orientation blockDirection, float hitX, float hitY, float hitZ, int newMeta) {
        return super.canPlaceBlock(world, player, stack, x, y, z, sideDir, blockDirection, hitX, hitY, hitZ, newMeta) && BlockBigButton.isNeighborBlockSolid((IBlockAccess)world, (int)x, (int)y, (int)z, (ForgeDirection)blockDirection.north());
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntityBigButton tile = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityBigButton.class));
        if (tile == null) {
            return;
        }
        boolean pressed = tile.isButtonActive();
        Orientation orientation = tile.getOrientation();
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)(pressed ? 0.0625 : 0.125));
        AxisAlignedBB rotatedAabb = BlockSpaceTransform.instance.mapBlockToWorld(orientation, aabb);
        this.setBlockBounds(rotatedAabb);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0625f, 0.0625f, 0.4f, 0.9375f, 0.9375f, 0.525f);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityBigButton te = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityBigButton.class));
        return te != null && te.isButtonActive() ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side).getOpposite();
        TileEntityBigButton button = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityBigButton.class));
        return button != null && direction == button.getOrientation().north() && button.isButtonActive() ? 15 : 0;
    }
}

