/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.renderer.tileentity.guide.GuideAdvancedRenderer;
import openblocks.client.renderer.tileentity.guide.GuideLegacyRenderer;
import openblocks.client.renderer.tileentity.guide.IGuideRenderer;
import openblocks.common.block.BlockGuide;
import openmods.Log;
import openmods.renderer.shaders.ArraysHelper;
import openmods.renderer.shaders.BufferHelper;
import openmods.renderer.shaders.ShaderHelper;

public class GuideRendererSelector {
    private static IGuideRenderer renderer;

    private static Runnable createMarkerRenderer() {
        return new Runnable(){

            @Override
            public void run() {
                Tessellator t = Tessellator.field_78398_a;
                RenderBlocks renderBlocks = new RenderBlocks();
                renderBlocks.func_147782_a(0.05, 0.05, 0.05, 0.95, 0.95, 0.95);
                t.func_78382_b();
                t.func_78380_c(200);
                renderBlocks.func_147798_e((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
                renderBlocks.func_147764_f((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
                renderBlocks.func_147768_a((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
                renderBlocks.func_147806_b((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
                renderBlocks.func_147761_c((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
                renderBlocks.func_147734_d((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
            }
        };
    }

    private static IGuideRenderer createRenderer() {
        Runnable marker = GuideRendererSelector.createMarkerRenderer();
        if (!(ShaderHelper.isSupported() && BufferHelper.isSupported() && ArraysHelper.isSupported())) {
            Log.debug((String)"Advanced guide renderer not supported, falling back to legacy renderer.", (Object[])new Object[0]);
            return new GuideLegacyRenderer(marker);
        }
        if (!Config.useAdvancedRenderer) {
            Log.debug((String)"Advanced guide renderer disabled, falling back to legacy renderer.", (Object[])new Object[0]);
            return new GuideLegacyRenderer(marker);
        }
        try {
            return new GuideAdvancedRenderer(marker);
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Error trying to create advanced renderer, falling back to legacy renderer", (Object[])new Object[0]);
            return new GuideLegacyRenderer(marker);
        }
    }

    public IGuideRenderer getRenderer() {
        if (renderer == null) {
            renderer = GuideRendererSelector.createRenderer();
        }
        return renderer;
    }
}

